/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.types.CloudImageDescription;
import integratedtoolkit.types.resources.MethodResourceDescription;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CloudImageManager {
    private HashMap<String, CloudImageDescription> images;
    private static final Logger logger = LogManager.getLogger((String)"integratedtoolkit.Components.CloudManager");

    public CloudImageManager() {
        logger.info("Initializing CloudImageManager");
        this.images = new HashMap();
    }

    public void add(CloudImageDescription cid) {
        logger.debug("Add new Image description");
        this.images.put(cid.getImageName(), cid);
    }

    public LinkedList<CloudImageDescription> getCompatibleImages(MethodResourceDescription requested) {
        LinkedList<CloudImageDescription> compatiblesList = new LinkedList<CloudImageDescription>();
        for (CloudImageDescription cid : this.images.values()) {
            String imageOSType = cid.getOperatingSystemType();
            String reqOSType = requested.getOperatingSystemType();
            if (!imageOSType.equals("[unassigned]") && !reqOSType.equals("[unassigned]") && !imageOSType.equals(reqOSType)) continue;
            String imageOSDistr = cid.getOperatingSystemDistribution();
            String reqOSDistr = requested.getOperatingSystemDistribution();
            if (!imageOSDistr.equals("[unassigned]") && !reqOSDistr.equals("[unassigned]") && !imageOSDistr.equals(reqOSDistr)) continue;
            String imageOSVersion = cid.getOperatingSystemVersion();
            String reqOSVersion = requested.getOperatingSystemVersion();
            if (!imageOSVersion.equals("[unassigned]") && !reqOSVersion.equals("[unassigned]") && !imageOSVersion.equals(reqOSVersion) || !cid.getAppSoftware().containsAll(requested.getAppSoftware())) continue;
            List req_queues = requested.getHostQueues();
            List<String> image_queues = cid.getQueues();
            if (!req_queues.isEmpty() && Collections.disjoint(req_queues, image_queues)) continue;
            compatiblesList.add(cid);
        }
        return compatiblesList;
    }

    public Set<String> getAllImageNames() {
        return this.images.keySet();
    }

    public String getCurrentState(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("IMAGES = [").append("\n");
        for (Map.Entry<String, CloudImageDescription> image : this.images.entrySet()) {
            String imageName = image.getKey();
            sb.append(prefix).append("\t").append("IMAGE = [").append("\n");
            sb.append(prefix).append("\t").append("\t").append("NAME = ").append(imageName).append("\n");
            sb.append(prefix).append("\t").append("\t").append("]").append("\n");
            sb.append(prefix).append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("]").append("\n");
        return sb.toString();
    }
}

