/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.connectors.ConnectorException;
import integratedtoolkit.types.CloudImageDescription;
import integratedtoolkit.types.CloudProvider;
import integratedtoolkit.types.ResourceCreationRequest;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.CloudMethodWorker;
import integratedtoolkit.types.resources.MethodResourceDescription;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import integratedtoolkit.util.Classpath;
import integratedtoolkit.util.CoreManager;
import integratedtoolkit.util.ErrorManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CloudManager {
    private static final String CONNECTORS_REL_PATH = File.separator + "Runtime" + File.separator + "connectors" + File.separator;
    private static final String WARN_NO_IT_HOME = "WARN: IT_HOME not defined, no default connectors loaded";
    private static final String WARN_NO_IT_HOME_RESOURCES = "WARN_MSG = [IT_HOME NOT DEFINED, NO DEFAULT CONNECTORS LOADED]";
    private static final String WARN_NO_CONNECTORS_FOLDER = "WARN: Connectors folder not defined, no default connectors loaded";
    private static final String WARN_NO_CONNECTORS_FOLDER_RESOURCES = "WARN_MSG = [CONNECTORS FOLDER NOT DEFINED, NO DEFAULT CONNECTORS LOADED]";
    private static final String WARN_NO_RESOURCE_MATCHES = "WARN: No resource matches the constraints";
    private static final String WARN_CANNOT_TURN_ON = "WARN: Connector cannot turn on resource";
    private static final String WARN_EXCEPTION_TURN_ON = "WARN: Connector exception on turn on resource";
    private static boolean useCloud;
    private static int initialVMs;
    private static int minVMs;
    private static int maxVMs;
    private static HashMap<String, CloudProvider> providers;
    private static HashMap<String, CloudProvider> VM2Provider;
    private static final LinkedList<ResourceCreationRequest> pendingRequests;
    private static int[] pendingCoreCount;
    private static final Logger runtimeLogger;
    private static final Logger resourcesLogger;

    public static void initialize() {
        runtimeLogger.info("Initializing Cloud Manager");
        useCloud = false;
        providers = new HashMap();
        VM2Provider = new HashMap();
        CloudManager.loadRuntimeConnectorJars();
    }

    public static void setUseCloud(boolean useCloud) {
        CloudManager.useCloud = useCloud;
    }

    public static int getInitialVMs() {
        return initialVMs;
    }

    public static void setInitialVMs(int initialVMs) {
        if (initialVMs > 0) {
            CloudManager.initialVMs = initialVMs;
        }
    }

    public static int getMinVMs() {
        return minVMs;
    }

    public static void setMinVMs(int minVMs) {
        if (minVMs > 0) {
            CloudManager.minVMs = minVMs;
        }
    }

    public static int getMaxVMs() {
        return maxVMs;
    }

    public static void setMaxVMs(int maxVMs) {
        CloudManager.maxVMs = maxVMs;
    }

    public static boolean isUseCloud() {
        return useCloud;
    }

    public static void newCloudProvider(String providerName, Integer limitOfVMs, String connectorJarPath, String connectorMainClass, HashMap<String, String> connectorProperties) throws ConnectorException {
        CloudProvider cp = new CloudProvider(providerName, limitOfVMs, connectorJarPath, connectorMainClass, connectorProperties);
        providers.put(providerName, cp);
    }

    public static void addImageToProvider(String providerName, CloudImageDescription cid) throws Exception {
        CloudProvider cp = providers.get(providerName);
        if (cp == null) {
            throw new Exception("Inexistent Cloud Provider " + providerName);
        }
        cp.addCloudImage(cid);
    }

    public static void addInstanceTypeToProvider(String providerName, CloudMethodResourceDescription rd) throws Exception {
        CloudProvider cp = providers.get(providerName);
        if (cp == null) {
            throw new Exception("Inexistent Cloud Provider " + providerName);
        }
        cp.addInstanceType(rd);
    }

    public static void newCoreElementsDetected(List<Integer> newCores) {
        pendingCoreCount = new int[CoreManager.getCoreCount()];
        for (ResourceCreationRequest rcr : pendingRequests) {
            int[][] reqCounts = rcr.requestedSimultaneousTaskCount();
            int coreId = 0;
            while (coreId < reqCounts.length) {
                int coreSlots = 0;
                for (int implId = 0; implId < reqCounts[coreId].length; ++implId) {
                    coreSlots = Math.max(coreSlots, reqCounts[coreId][implId]);
                }
                int n = coreId++;
                pendingCoreCount[n] = pendingCoreCount[n] + coreSlots;
            }
        }
        for (CloudProvider cp : providers.values()) {
            cp.newCoreElementsDetected(newCores);
        }
    }

    public static LinkedList<ResourceCreationRequest> getPendingRequests() {
        return pendingRequests;
    }

    public static int[] getPendingCoreCounts() {
        return pendingCoreCount;
    }

    public static ResourceCreationRequest askForResources(MethodResourceDescription requirements, boolean contained) {
        return CloudManager.askForResources(1, requirements, contained);
    }

    public static ResourceCreationRequest askForResources(Integer amount, MethodResourceDescription requirements, boolean contained) {
        CloudProvider bestProvider = null;
        CloudMethodResourceDescription bestConstraints = null;
        Float bestValue = Float.valueOf(Float.MAX_VALUE);
        for (CloudProvider cp : providers.values()) {
            CloudMethodResourceDescription rc = cp.getBestIncrease(amount, requirements, contained);
            if (rc == null || !(rc.getValue().floatValue() < bestValue.floatValue())) continue;
            bestProvider = cp;
            bestConstraints = rc;
            bestValue = rc.getValue();
        }
        if (bestConstraints == null) {
            runtimeLogger.warn(WARN_NO_RESOURCE_MATCHES);
            return null;
        }
        int coreCount = CoreManager.getCoreCount();
        Object simultaneousCounts = bestProvider.getSimultaneousImpls(bestConstraints.getType());
        if (simultaneousCounts == null) {
            simultaneousCounts = new int[coreCount][];
            for (int coreId = 0; coreId < coreCount; ++coreId) {
                List impls = CoreManager.getCoreImplementations((int)coreId);
                int implsSize = impls.size();
                simultaneousCounts[coreId] = new int[implsSize];
                for (int implId = 0; implId < implsSize; ++implId) {
                    MethodResourceDescription description;
                    Implementation impl = (Implementation)impls.get(implId);
                    if (impl.getTaskType() != Implementation.TaskType.METHOD || (description = (MethodResourceDescription)impl.getRequirements()) == null) continue;
                    Integer into = bestConstraints.canHostSimultaneously(description);
                    simultaneousCounts[coreId][implId] = into;
                }
            }
        }
        runtimeLogger.debug("[Cloud Manager] Asking for resource creation " + bestConstraints.getName() + " with image" + bestConstraints.getImage().getImageName());
        ResourceCreationRequest rcr = new ResourceCreationRequest(bestConstraints, (int[][])simultaneousCounts, bestProvider.getName());
        try {
            if (bestProvider.turnON(rcr)) {
                pendingRequests.add(rcr);
                int[][] reqCounts = rcr.requestedSimultaneousTaskCount();
                int coreId = 0;
                while (coreId < reqCounts.length) {
                    int coreSlots = 0;
                    for (int implId = 0; implId < reqCounts[coreId].length; ++implId) {
                        coreSlots = Math.max(coreSlots, reqCounts[coreId][implId]);
                    }
                    int n = coreId++;
                    pendingCoreCount[n] = pendingCoreCount[n] + coreSlots;
                }
                return rcr;
            }
            runtimeLogger.warn(WARN_CANNOT_TURN_ON);
            return null;
        }
        catch (Exception e) {
            runtimeLogger.warn(WARN_EXCEPTION_TURN_ON, (Throwable)e);
            return null;
        }
    }

    public static void confirmedRequest(ResourceCreationRequest rcr, CloudMethodWorker r) {
        pendingRequests.remove(rcr);
        int[][] reqCounts = rcr.requestedSimultaneousTaskCount();
        int coreId = 0;
        while (coreId < reqCounts.length) {
            int coreSlots = 0;
            for (int implId = 0; implId < reqCounts[coreId].length; ++implId) {
                coreSlots = Math.max(coreSlots, reqCounts[coreId][implId]);
            }
            int n = coreId++;
            pendingCoreCount[n] = pendingCoreCount[n] - coreSlots;
        }
        String provider = rcr.getProvider();
        CloudProvider cp = providers.get(provider);
        String vmName = r.getName();
        VM2Provider.put(vmName, cp);
        cp.createdVM(vmName, (CloudMethodResourceDescription)((Object)r.getDescription()));
    }

    public static void refusedRequest(ResourceCreationRequest rcr) {
        pendingRequests.remove(rcr);
        int[][] reqCounts = rcr.requestedSimultaneousTaskCount();
        int coreId = 0;
        while (coreId < reqCounts.length) {
            int coreSlots = 0;
            for (int implId = 0; implId < reqCounts[coreId].length; ++implId) {
                coreSlots = Math.max(coreSlots, reqCounts[coreId][implId]);
            }
            int n = coreId++;
            pendingCoreCount[n] = pendingCoreCount[n] - coreSlots;
        }
        CloudProvider cp = providers.get(rcr.getProvider());
        cp.refusedWorker(rcr.getRequested());
    }

    public static Object[] getBestDestruction(Collection<CloudMethodWorker> resourceSet, float[] destroyRecommendations) {
        float[] bestRecord = new float[]{Float.MAX_VALUE, Float.MAX_VALUE, Float.MIN_VALUE};
        CloudMethodWorker bestResource = null;
        CloudProvider bestCP = null;
        String bestType = null;
        CloudMethodResourceDescription bestRD = null;
        for (CloudMethodWorker res : resourceSet) {
            CloudProvider cp = VM2Provider.get(res.getName());
            if (cp == null || res.hasPendingReductions()) continue;
            HashMap<String, Object[]> typeToPoints = cp.getPossibleReductions(res, destroyRecommendations);
            for (Map.Entry<String, Object[]> destruction : typeToPoints.entrySet()) {
                String typeName = destruction.getKey();
                Object[] description = destruction.getValue();
                float[] values = (float[])description[0];
                CloudMethodResourceDescription rd = (CloudMethodResourceDescription)((Object)description[1]);
                if (bestRecord[0] == values[0]) {
                    if (bestRecord[1] == values[1]) {
                        if (!(bestRecord[2] < values[2])) continue;
                        bestRecord = values;
                        bestResource = res;
                        bestType = typeName;
                        bestCP = cp;
                        bestRD = rd;
                        continue;
                    }
                    if (!(bestRecord[1] > values[1])) continue;
                    bestRecord = values;
                    bestResource = res;
                    bestType = typeName;
                    bestCP = cp;
                    bestRD = rd;
                    continue;
                }
                if (!(bestRecord[0] > values[0])) continue;
                bestRecord = values;
                bestResource = res;
                bestType = typeName;
                bestCP = cp;
                bestRD = rd;
            }
        }
        if (bestResource != null) {
            Object[] ret = new Object[]{bestResource, bestRecord, bestCP.getSimultaneousImpls(bestType), bestRD};
            return ret;
        }
        return null;
    }

    public static void destroyResources(CloudMethodWorker res, CloudMethodResourceDescription reduction) {
        runtimeLogger.debug("[Cloud Manager] Destroying resource " + res.getName() + " for reduction");
        CloudProvider cp = VM2Provider.get(res.getName());
        cp.turnOff(res, reduction);
    }

    public static void terminateALL() throws ConnectorException {
        runtimeLogger.debug("[Cloud Manager] Terminate ALL resources");
        if (providers != null) {
            for (Map.Entry<String, CloudProvider> vm : providers.entrySet()) {
                CloudProvider cp = vm.getValue();
                cp.terminateAll();
            }
            VM2Provider.clear();
        }
    }

    public static float currentCostPerHour() {
        float total = 0.0f;
        for (CloudProvider cp : providers.values()) {
            total += cp.getCurrentCostPerHour();
        }
        return total;
    }

    public static void stopReached() {
        for (CloudProvider cp : providers.values()) {
            cp.stopReached();
        }
    }

    public static float getTotalCost() {
        float total = 0.0f;
        for (CloudProvider cp : providers.values()) {
            total += cp.getTotalCost();
        }
        return total;
    }

    public static long getNextCreationTime() throws Exception {
        long total = 0L;
        for (CloudProvider cp : providers.values()) {
            total = Math.max(total, cp.getNextCreationTime());
        }
        return total;
    }

    public static long getTimeSlot() throws Exception {
        long total = Long.MAX_VALUE;
        for (CloudProvider cp : providers.values()) {
            total = Math.min(total, cp.getTimeSlot());
        }
        return total;
    }

    public static int getCurrentVMCount() {
        int total = 0;
        for (CloudProvider cp : providers.values()) {
            total += cp.getCurrentVMCount();
        }
        return total;
    }

    public static String getCurrentState(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("CLOUD = [").append("\n");
        sb.append(prefix).append("\t").append("CURRENT_STATE = [").append("\n");
        for (CloudProvider cp : providers.values()) {
            sb.append(cp.getCurrentState(prefix + "\t" + "\t"));
        }
        sb.append(prefix).append("\t").append("]").append("\n");
        sb.append(prefix).append("\t").append("PENDING_REQUESTS = [").append("\n");
        for (ResourceCreationRequest rcr : pendingRequests) {
            sb.append(prefix).append("\t").append("\t").append("REQUEST = ").append(rcr.getRequested().getType()).append("\n");
        }
        sb.append(prefix).append("\t").append("]").append("\n");
        sb.append(prefix).append("]");
        return sb.toString();
    }

    public static CloudProvider getProvider(String name) {
        if (providers.containsKey(name)) {
            return providers.get(name);
        }
        return null;
    }

    private static void loadRuntimeConnectorJars() {
        runtimeLogger.debug("Loading runtime connectors to classpath...");
        String itHome = System.getenv("IT_HOME");
        if (itHome == null || itHome.isEmpty()) {
            resourcesLogger.warn(WARN_NO_IT_HOME_RESOURCES);
            runtimeLogger.warn(WARN_NO_IT_HOME);
            return;
        }
        String connPath = itHome + CONNECTORS_REL_PATH;
        try {
            Classpath.loadPath((String)connPath, (Logger)runtimeLogger);
        }
        catch (FileNotFoundException fnfe) {
            ErrorManager.warn((String)("Connector jar " + connPath + " not found."));
            resourcesLogger.warn(WARN_NO_CONNECTORS_FOLDER_RESOURCES);
            runtimeLogger.warn(WARN_NO_CONNECTORS_FOLDER);
        }
    }

    static {
        initialVMs = 0;
        minVMs = 0;
        maxVMs = -1;
        pendingRequests = new LinkedList();
        pendingCoreCount = new int[CoreManager.getCoreCount()];
        runtimeLogger = LogManager.getLogger((String)"integratedtoolkit.Components.CloudManager");
        resourcesLogger = LogManager.getLogger((String)"integratedtoolkit.Resources");
    }
}

