/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.comm.Comm;
import integratedtoolkit.exceptions.ConstructConfigurationException;
import integratedtoolkit.exceptions.NoResourceAvailableException;
import integratedtoolkit.types.CloudImageDescription;
import integratedtoolkit.types.project.ProjectFile;
import integratedtoolkit.types.project.exceptions.ProjectFileValidationException;
import integratedtoolkit.types.project.jaxb.ApplicationType;
import integratedtoolkit.types.project.jaxb.AttachedDiskType;
import integratedtoolkit.types.project.jaxb.AttachedDisksListType;
import integratedtoolkit.types.project.jaxb.CloudPropertiesType;
import integratedtoolkit.types.project.jaxb.CloudPropertyType;
import integratedtoolkit.types.project.jaxb.CloudType;
import integratedtoolkit.types.project.jaxb.ComputeNodeType;
import integratedtoolkit.types.project.jaxb.DataNodeType;
import integratedtoolkit.types.project.jaxb.ImagesType;
import integratedtoolkit.types.project.jaxb.InstanceTypeType;
import integratedtoolkit.types.project.jaxb.InstanceTypesType;
import integratedtoolkit.types.project.jaxb.MasterNodeType;
import integratedtoolkit.types.project.jaxb.PackageType;
import integratedtoolkit.types.project.jaxb.PriceType;
import integratedtoolkit.types.project.jaxb.SoftwareListType;
import integratedtoolkit.types.resources.DataResourceDescription;
import integratedtoolkit.types.resources.MethodResourceDescription;
import integratedtoolkit.types.resources.ResourcesFile;
import integratedtoolkit.types.resources.ServiceResourceDescription;
import integratedtoolkit.types.resources.configuration.MethodConfiguration;
import integratedtoolkit.types.resources.configuration.ServiceConfiguration;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import integratedtoolkit.types.resources.exceptions.ResourcesFileValidationException;
import integratedtoolkit.types.resources.jaxb.CloudProviderType;
import integratedtoolkit.types.resources.jaxb.EndpointType;
import integratedtoolkit.types.resources.jaxb.ImageType;
import integratedtoolkit.types.resources.jaxb.ProcessorPropertyType;
import integratedtoolkit.types.resources.jaxb.ProcessorType;
import integratedtoolkit.types.resources.jaxb.ServiceType;
import integratedtoolkit.types.resources.jaxb.SharedDiskType;
import integratedtoolkit.util.CloudManager;
import integratedtoolkit.util.ErrorManager;
import integratedtoolkit.util.ResourceManager;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public class ResourceLoader {
    private static String resources_XML;
    private static String resources_XSD;
    private static String project_XML;
    private static String project_XSD;
    private static ResourcesFile resources;
    private static ProjectFile project;
    private static final Logger LOGGER;

    public static void load(String resources_XML, String resources_XSD, String project_XML, String project_XSD) throws ResourcesFileValidationException, ProjectFileValidationException, NoResourceAvailableException {
        ResourceLoader.init(resources_XML, resources_XSD, project_XML, project_XSD);
        ResourceLoader.loadFiles();
        ResourceLoader.loadRuntime();
    }

    private static void init(String resources_XML, String resources_XSD, String project_XML, String project_XSD) {
        LOGGER.info("ResourceLoader init");
        ResourceLoader.resources_XML = resources_XML;
        ResourceLoader.resources_XSD = resources_XSD;
        ResourceLoader.project_XML = project_XML;
        ResourceLoader.project_XSD = project_XSD;
    }

    private static void loadFiles() throws ResourcesFileValidationException, ProjectFileValidationException {
        LOGGER.info("ResourceLoader loading files");
        try {
            LOGGER.debug("ResourceLoader loading resources.xml");
            resources = new ResourcesFile(new File(resources_XML), resources_XSD, LOGGER);
        }
        catch (JAXBException | SAXException e) {
            throw new ResourcesFileValidationException((Exception)e);
        }
        try {
            LOGGER.debug("ResourceLoader loading project.xml");
            project = new ProjectFile(new File(project_XML), project_XSD, LOGGER);
        }
        catch (JAXBException | SAXException e) {
            throw new ProjectFileValidationException((Exception)e);
        }
    }

    private static void loadRuntime() throws NoResourceAvailableException {
        CloudType cloud;
        List dataNodes;
        List services;
        LOGGER.info("ResourceLoader loading Runtime");
        boolean computeNodeExist = false;
        boolean serviceExist = false;
        boolean cloudProviderExist = false;
        MasterNodeType master = project.getMasterNode();
        ResourceLoader.loadMaster(master);
        List computeNodes = project.getComputeNodes_list();
        if (computeNodes != null) {
            for (ComputeNodeType cn_project : computeNodes) {
                integratedtoolkit.types.resources.jaxb.ComputeNodeType cn_resources = resources.getComputeNode(cn_project.getName());
                if (cn_resources != null) {
                    boolean exist = ResourceLoader.loadComputeNode(cn_project, cn_resources);
                    computeNodeExist = computeNodeExist || exist;
                    continue;
                }
                ErrorManager.warn((String)("ComputeNode " + cn_project.getName() + " not defined in the resources file"));
            }
        }
        if ((services = project.getServices_list()) != null) {
            for (integratedtoolkit.types.project.jaxb.ServiceType s_project : services) {
                ServiceType s_resources = resources.getService(s_project.getWsdl());
                if (s_resources != null) {
                    boolean exist = ResourceLoader.loadService(s_project, s_resources);
                    serviceExist = serviceExist || exist;
                    continue;
                }
                ErrorManager.warn((String)("Service " + s_project.getWsdl() + " not defined in the resources file"));
            }
        }
        if ((dataNodes = project.getDataNodes_list()) != null) {
            for (DataNodeType dn_project : dataNodes) {
                integratedtoolkit.types.resources.jaxb.DataNodeType dn_resources = resources.getDataNode(dn_project.getName());
                if (dn_resources != null) {
                    ResourceLoader.loadDataNode(dn_project, dn_resources);
                    continue;
                }
                ErrorManager.warn((String)("DataNode " + dn_project.getName() + " not defined in the resources file"));
            }
        }
        if ((cloud = project.getCloud()) != null) {
            cloudProviderExist = ResourceLoader.loadCloud(cloud);
        }
        if (!(computeNodeExist || serviceExist || cloudProviderExist)) {
            throw new NoResourceAvailableException();
        }
    }

    private static void loadMaster(MasterNodeType master) {
        HashMap<String, String> sharedDisks = new HashMap<String, String>();
        List masterInformation = master.getSharedDisksOrPrice();
        if (masterInformation != null) {
            for (Object obj : masterInformation) {
                if (obj instanceof AttachedDisksListType) {
                    List disksList;
                    AttachedDisksListType disks = (AttachedDisksListType)obj;
                    if (disks == null || (disksList = disks.getAttachedDisk()) == null) continue;
                    for (AttachedDiskType disk : disksList) {
                        SharedDiskType disk_resources = resources.getSharedDisk(disk.getName());
                        if (disk_resources != null) {
                            String diskName = disk.getName();
                            String diskMountPoint = disk.getMountPoint();
                            sharedDisks.put(diskName, diskMountPoint);
                            continue;
                        }
                        ErrorManager.warn((String)("SharedDisk " + disk.getName() + " defined in the master node is not defined in the resources.xml. Skipping"));
                    }
                    continue;
                }
                if (obj instanceof PriceType) continue;
                LOGGER.warn("MasterNode has an unrecognized parameter: " + obj.getClass());
            }
        }
        ResourceManager.updateMasterConfiguration(sharedDisks);
    }

    private static boolean loadComputeNode(ComputeNodeType cn_project, integratedtoolkit.types.resources.jaxb.ComputeNodeType cn_resources) {
        HashMap sharedDisks;
        Object p2;
        String name = cn_project.getName();
        MethodResourceDescription mrd = new MethodResourceDescription();
        List processors = resources.getProcessors(cn_resources);
        if (processors != null) {
            for (Object p2 : processors) {
                String procName = p2.getName();
                int computingUnits = resources.getProcessorComputingUnits((ProcessorType)p2);
                String architecture = resources.getProcessorArchitecture((ProcessorType)p2);
                float speed = resources.getProcessorSpeed((ProcessorType)p2);
                Iterator type = resources.getProcessorType((ProcessorType)p2);
                float internalMemory = resources.getProcessorMemorySize((ProcessorType)p2);
                ProcessorPropertyType procProp = resources.getProcessorProperty((ProcessorType)p2);
                String propKey = procProp != null ? procProp.getKey() : "";
                String propValue = procProp != null ? procProp.getValue() : "";
                mrd.addProcessor(procName, computingUnits, architecture, speed, (String)((Object)type), internalMemory, propKey, propValue);
            }
        }
        mrd.setMemorySize(resources.getMemorySize(cn_resources));
        mrd.setMemoryType(resources.getMemoryType(cn_resources));
        mrd.setStorageSize(resources.getStorageSize(cn_resources));
        mrd.setStorageType(resources.getStorageType(cn_resources));
        mrd.setOperatingSystemType(resources.getOperatingSystemType(cn_resources));
        mrd.setOperatingSystemDistribution(resources.getOperatingSystemDistribution(cn_resources));
        mrd.setOperatingSystemVersion(resources.getOperatingSystemVersion(cn_resources));
        List apps = resources.getApplications(cn_resources);
        if (apps != null) {
            p2 = apps.iterator();
            while (p2.hasNext()) {
                String appName = (String)p2.next();
                mrd.addApplication(appName);
            }
        }
        if ((p2 = resources.getPrice(cn_resources)) != null) {
            mrd.setPriceTimeUnit(p2.getTimeUnit());
            mrd.setPricePerUnit(p2.getPricePerUnit());
        }
        if ((sharedDisks = resources.getSharedDisks(cn_resources)) != null) {
            List declaredSharedDisks = resources.getSharedDisks_names();
            for (String diskName : sharedDisks.keySet()) {
                if (declaredSharedDisks != null && declaredSharedDisks.contains(diskName)) continue;
                ErrorManager.warn((String)("SharedDisk " + diskName + " defined in the ComputeNode " + name + " is not defined in the resources.xml. Skipping"));
                sharedDisks.remove(diskName);
            }
        }
        String loadedAdaptor = System.getProperty("it.comm");
        List queues_project = project.getAdaptorQueues(cn_project, loadedAdaptor);
        List queues_resources = resources.getAdaptorQueues(cn_resources, loadedAdaptor);
        if (queues_project == null) {
            for (String queue : queues_resources) {
                mrd.addHostQueue(queue);
            }
        } else {
            for (String queue : queues_resources) {
                if (!queues_project.contains(queue)) continue;
                mrd.addHostQueue(queue);
            }
        }
        Object adaptorProperties_project = project.getAdaptorProperties(cn_project, loadedAdaptor);
        Object adaptorProperties_resources = resources.getAdaptorProperties(cn_resources, loadedAdaptor);
        MethodConfiguration config = null;
        try {
            config = (MethodConfiguration)Comm.constructConfiguration((String)loadedAdaptor, (Object)adaptorProperties_project, (Object)adaptorProperties_resources);
        }
        catch (ConstructConfigurationException cce) {
            ErrorManager.warn((String)("Adaptor " + loadedAdaptor + " configuration constructor failed"), (Exception)((Object)cce));
            return false;
        }
        config.setHost(cn_project.getName());
        config.setUser(project.getUser(cn_project));
        config.setInstallDir(project.getInstallDir(cn_project));
        config.setWorkingDir(project.getWorkingDir(cn_project));
        int limitOfTasks = project.getLimitOfTasks(cn_project);
        if (limitOfTasks >= 0) {
            config.setLimitOfTasks(limitOfTasks);
        } else {
            config.setLimitOfTasks(mrd.getTotalCPUComputingUnits());
        }
        config.setTotalComputingUnits(mrd.getTotalCPUComputingUnits());
        config.setTotalGPUComputingUnits(mrd.getTotalGPUComputingUnits());
        config.setTotalFPGAComputingUnits(mrd.getTotalFPGAComputingUnits());
        config.setTotalOTHERComputingUnits(mrd.getTotalOTHERComputingUnits());
        ApplicationType app = project.getApplication(cn_project);
        if (app != null) {
            config.setAppDir(app.getAppDir());
            config.setLibraryPath(app.getLibraryPath());
            config.setClasspath(app.getClasspath());
            config.setPythonpath(app.getPythonpath());
        }
        LOGGER.debug("Adding method worker " + name);
        ResourceManager.newMethodWorker(name, mrd, sharedDisks, config);
        return true;
    }

    private static boolean loadService(integratedtoolkit.types.project.jaxb.ServiceType s_project, ServiceType s_resources) {
        String serviceAdaptorName = "integratedtoolkit.ws.master.WSAdaptor";
        String wsdl = s_project.getWsdl();
        String serviceName = s_resources.getName();
        String namespace = s_resources.getNamespace();
        String port = s_resources.getPort();
        ServiceResourceDescription srd = new ServiceResourceDescription(serviceName, namespace, port, Integer.MAX_VALUE);
        ServiceConfiguration config = null;
        try {
            config = (ServiceConfiguration)Comm.constructConfiguration((String)serviceAdaptorName, (Object)s_project, (Object)s_resources);
        }
        catch (ConstructConfigurationException cce) {
            ErrorManager.warn((String)"Service configuration constructor failed", (Exception)((Object)cce));
            return false;
        }
        int limitOfTasks = s_project.getLimitOfTasks();
        if (limitOfTasks >= 0) {
            config.setLimitOfTasks(limitOfTasks);
        } else {
            config.setLimitOfTasks(Integer.MAX_VALUE);
        }
        LOGGER.debug("Adding service worker " + wsdl);
        ResourceManager.newServiceWorker(wsdl, srd, config);
        return true;
    }

    private static boolean loadCloud(CloudType cloud) {
        int initialVMs = project.getInitialVMs(cloud);
        int minVMs = project.getMinVMs(cloud);
        int maxVMs = project.getMaxVMs(cloud);
        if (maxVMs != -1 && minVMs != -1 && maxVMs < minVMs) {
            ErrorManager.warn((String)("Cloud: MaxVMs (" + maxVMs + ") is lower than MinVMs (" + minVMs + "). Setting MaxVMs value to MinVMs"));
            maxVMs = minVMs;
        }
        if (initialVMs < minVMs) {
            initialVMs = minVMs;
        }
        if (initialVMs > maxVMs) {
            initialVMs = maxVMs;
        }
        if (initialVMs > 0) {
            CloudManager.setInitialVMs(initialVMs);
        }
        if (minVMs > 0) {
            CloudManager.setMinVMs(minVMs);
        }
        if (maxVMs > 0) {
            CloudManager.setMaxVMs(maxVMs);
        }
        boolean cloudEnabled = false;
        List cp_resources = resources.getCloudProviders_names();
        for (integratedtoolkit.types.project.jaxb.CloudProviderType cp : project.getCloudProviders_list()) {
            if (cp_resources.contains(cp.getName())) {
                boolean isEnabled = ResourceLoader.loadCloudProvider(cp, resources.getCloudProvider(cp.getName()));
                cloudEnabled = cloudEnabled || isEnabled;
                continue;
            }
            ErrorManager.warn((String)("CloudProvider " + cp.getName() + " not defined in resources.xml file. Skipping"));
        }
        CloudManager.setUseCloud(cloudEnabled);
        return cloudEnabled;
    }

    private static boolean loadCloudProvider(integratedtoolkit.types.project.jaxb.CloudProviderType cp_project, CloudProviderType cp_resources) {
        String cpName = cp_project.getName();
        String connectorJarPath = "";
        String connectorMainClass = "";
        HashMap<String, String> properties = new HashMap<String, String>();
        EndpointType endpoint = cp_resources.getEndpoint();
        connectorJarPath = resources.getConnectorJarPath(endpoint);
        connectorMainClass = resources.getConnectorMainClass(endpoint);
        properties.put("Server", resources.getServer(endpoint));
        properties.put("Port", resources.getPort(endpoint));
        List objList = cp_project.getImagesOrInstanceTypesOrLimitOfVMs();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof CloudPropertiesType)) continue;
                CloudPropertiesType cloud_props = (CloudPropertiesType)obj;
                for (CloudPropertyType prop : cloud_props.getProperty()) {
                    properties.put(prop.getName(), prop.getValue());
                }
            }
        }
        String appName = System.getProperty("it.appName");
        appName = appName.toLowerCase();
        appName = appName.replace('.', '-');
        properties.put("app-name", appName);
        int limitOfVMs = -1;
        int maxCreationTime = -1;
        LinkedList<CloudImageDescription> images = new LinkedList<CloudImageDescription>();
        LinkedList<CloudMethodResourceDescription> instanceTypes = new LinkedList<CloudMethodResourceDescription>();
        objList = cp_project.getImagesOrInstanceTypesOrLimitOfVMs();
        if (objList != null) {
            for (Object obj : objList) {
                if (obj instanceof ImagesType) {
                    ImagesType imageList = (ImagesType)obj;
                    for (integratedtoolkit.types.project.jaxb.ImageType im_project : imageList.getImage()) {
                        ImageType im_resources;
                        CloudImageDescription cid = ResourceLoader.createImage(cpName, im_project, im_resources = resources.getImage(cp_resources, im_project.getName()), properties);
                        if (cid == null) continue;
                        images.add(cid);
                        int localCT = cid.getCreationTime();
                        if (localCT <= maxCreationTime) continue;
                        maxCreationTime = localCT;
                    }
                    continue;
                }
                if (obj instanceof InstanceTypesType) {
                    InstanceTypesType instancesList = (InstanceTypesType)obj;
                    for (InstanceTypeType instance_project : instancesList.getInstanceType()) {
                        String instanceName = instance_project.getName();
                        integratedtoolkit.types.resources.jaxb.InstanceTypeType instance_resources = resources.getInstance(cp_resources, instanceName);
                        if (instance_resources != null) {
                            CloudMethodResourceDescription cmrd = ResourceLoader.createInstance(cpName, instance_resources);
                            if (cmrd == null) continue;
                            instanceTypes.add(cmrd);
                            continue;
                        }
                        ErrorManager.warn((String)("Instance " + instanceName + " not defined in resources.xml. Skipping"));
                    }
                    continue;
                }
                if (!(obj instanceof Integer)) continue;
                limitOfVMs = (Integer)obj;
            }
        }
        if (maxCreationTime > 0) {
            properties.put("max-vm-creation-time", Integer.toString(maxCreationTime));
        }
        try {
            CloudManager.newCloudProvider(cpName, limitOfVMs, connectorJarPath, connectorMainClass, properties);
            for (CloudImageDescription cid : images) {
                CloudManager.addImageToProvider(cpName, cid);
            }
            for (CloudMethodResourceDescription instance : instanceTypes) {
                CloudManager.addInstanceTypeToProvider(cpName, instance);
            }
        }
        catch (Exception e) {
            ErrorManager.warn((String)("Exception loading CloudProvider " + cpName), (Exception)e);
            return false;
        }
        return true;
    }

    private static CloudImageDescription createImage(String cp_name, integratedtoolkit.types.project.jaxb.ImageType im_project, ImageType im_resources, HashMap<String, String> properties) {
        integratedtoolkit.types.resources.jaxb.PriceType p;
        String imageName = im_project.getName();
        LOGGER.debug("Loading Image" + imageName);
        CloudImageDescription cid = new CloudImageDescription(cp_name, imageName, properties);
        cid.setOperatingSystemType(resources.getOperatingSystemType(im_resources));
        cid.setOperatingSystemDistribution(resources.getOperatingSystemDistribution(im_resources));
        cid.setOperatingSystemVersion(resources.getOperatingSystemVersion(im_resources));
        List apps = resources.getApplications(im_resources);
        if (apps != null) {
            for (String appName : apps) {
                cid.addApplication(appName);
            }
        }
        if ((p = resources.getPrice(im_resources)) != null) {
            cid.setPriceTimeUnit(p.getTimeUnit());
            cid.setPricePerUnit(p.getPricePerUnit());
        }
        cid.setCreationTime(resources.getCreationTime(im_resources));
        HashMap sharedDisks = resources.getSharedDisks(im_resources);
        if (sharedDisks != null) {
            List declaredSharedDisks = resources.getSharedDisks_names();
            for (String diskName : sharedDisks.keySet()) {
                if (declaredSharedDisks != null && declaredSharedDisks.contains(diskName)) continue;
                ErrorManager.warn((String)("SharedDisk " + diskName + " defined in the Image " + imageName + " is not defined in the resources.xml. Skipping"));
                sharedDisks.remove(diskName);
            }
        }
        cid.setSharedDisks(sharedDisks);
        String loadedAdaptor = System.getProperty("it.comm");
        List queues_project = project.getAdaptorQueues(im_project, loadedAdaptor);
        List queues_resources = resources.getAdaptorQueues(im_resources, loadedAdaptor);
        for (String queue : queues_resources) {
            if (!queues_project.contains(queue)) continue;
            cid.addQueue(queue);
        }
        Object adaptorProperties_project = project.getAdaptorProperties(im_project, loadedAdaptor);
        Object adaptorProperties_resources = resources.getAdaptorProperties(im_resources, loadedAdaptor);
        MethodConfiguration config = null;
        try {
            config = (MethodConfiguration)Comm.constructConfiguration((String)loadedAdaptor, (Object)adaptorProperties_project, (Object)adaptorProperties_resources);
        }
        catch (ConstructConfigurationException cce) {
            ErrorManager.warn((String)"Adaptor configuration constructor failed", (Exception)((Object)cce));
            return null;
        }
        config.setHost(im_project.getName());
        config.setUser(project.getUser(im_project));
        config.setInstallDir(project.getInstallDir(im_project));
        config.setWorkingDir(project.getWorkingDir(im_project));
        config.setLimitOfTasks(project.getLimitOfTasks(im_project));
        ApplicationType app = project.getApplication(im_project);
        if (app != null) {
            config.setAppDir(app.getAppDir());
            config.setLibraryPath(app.getLibraryPath());
            config.setClasspath(app.getClasspath());
            config.setPythonpath(app.getClasspath());
        }
        List packages = project.getPackages(im_project);
        for (PackageType pack : packages) {
            cid.addPackage(pack.getSource(), pack.getTarget());
            SoftwareListType software = pack.getIncludedSoftware();
            if (software == null) continue;
            cid.addAllApplications(software.getApplication());
        }
        cid.setConfig(config);
        return cid;
    }

    private static CloudMethodResourceDescription createInstance(String cpName, integratedtoolkit.types.resources.jaxb.InstanceTypeType instance) {
        String name = instance.getName();
        String type = instance.getName();
        CloudMethodResourceDescription cmrd = new CloudMethodResourceDescription(cpName, name, type);
        List processors = resources.getProcessors(instance);
        if (processors != null) {
            for (ProcessorType p : processors) {
                String procName = p.getName();
                int computingUnits = resources.getProcessorComputingUnits(p);
                String architecture = resources.getProcessorArchitecture(p);
                float speed = resources.getProcessorSpeed(p);
                String procType = resources.getProcessorType(p);
                float internalMemory = resources.getProcessorMemorySize(p);
                ProcessorPropertyType procProp = resources.getProcessorProperty(p);
                String propKey = procProp != null ? procProp.getKey() : "";
                String propValue = procProp != null ? procProp.getValue() : "";
                cmrd.addProcessor(procName, computingUnits, architecture, speed, procType, internalMemory, propKey, propValue);
            }
        }
        cmrd.setMemorySize(resources.getMemorySize(instance));
        cmrd.setMemoryType(resources.getMemoryType(instance));
        cmrd.setStorageSize(resources.getStorageSize(instance));
        cmrd.setStorageType(resources.getStorageType(instance));
        integratedtoolkit.types.resources.jaxb.PriceType p = resources.getPrice(instance);
        if (p != null) {
            cmrd.setPriceTimeUnit(p.getTimeUnit());
            cmrd.setPricePerUnit(p.getPricePerUnit());
        }
        return cmrd;
    }

    private static void loadDataNode(DataNodeType dn_project, integratedtoolkit.types.resources.jaxb.DataNodeType dn_resources) {
        String name = dn_project.getName();
        String host = resources.getHost(dn_resources);
        String path = resources.getPath(dn_resources);
        DataResourceDescription dd = new DataResourceDescription(host, path);
        dd.setStorageSize(resources.getStorageSize(dn_resources));
        dd.setStorageType(resources.getStorageType(dn_resources));
        LOGGER.warn("Cannot load DataNode " + name + ". DataNodes are not supported inside the Runtime");
    }

    static {
        LOGGER = LogManager.getLogger((String)"integratedtoolkit.Components.ResourceManager");
    }
}

