/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.comm.Comm;
import integratedtoolkit.components.ResourceUser;
import integratedtoolkit.connectors.ConnectorException;
import integratedtoolkit.exceptions.InitNodeException;
import integratedtoolkit.exceptions.NoResourceAvailableException;
import integratedtoolkit.types.ResourceCreationRequest;
import integratedtoolkit.types.ResourcesState;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.project.exceptions.ProjectFileValidationException;
import integratedtoolkit.types.resources.CloudMethodWorker;
import integratedtoolkit.types.resources.MethodResourceDescription;
import integratedtoolkit.types.resources.MethodWorker;
import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.types.resources.ServiceResourceDescription;
import integratedtoolkit.types.resources.ServiceWorker;
import integratedtoolkit.types.resources.ShutdownListener;
import integratedtoolkit.types.resources.Worker;
import integratedtoolkit.types.resources.WorkerResourceDescription;
import integratedtoolkit.types.resources.configuration.MethodConfiguration;
import integratedtoolkit.types.resources.configuration.ServiceConfiguration;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import integratedtoolkit.types.resources.exceptions.ResourcesFileValidationException;
import integratedtoolkit.util.CloudManager;
import integratedtoolkit.util.CoreManager;
import integratedtoolkit.util.ErrorManager;
import integratedtoolkit.util.ResourceLoader;
import integratedtoolkit.util.ResourceOptimizer;
import integratedtoolkit.util.WorkerPool;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceManager {
    private static final String RESOURCES_XML = System.getProperty("it.resources.file");
    private static final String RESOURCES_XSD = System.getProperty("it.resources.schema");
    private static final String PROJECT_XML = System.getProperty("it.project.file");
    private static final String PROJECT_XSD = System.getProperty("it.project.schema");
    private static final String ERROR_RESOURCES_XML = "ERROR: Cannot parse resources.xml file";
    private static final String ERROR_PROJECT_XML = "ERROR: Cannot parse project.xml file";
    private static final String ERROR_NO_RES = "ERROR: No computational resource available (ComputeNode, service or CloudProvider)";
    protected static final String ERROR_UNKNOWN_HOST = "ERROR: Cannot determine the IP address of the local host";
    private static final String DEL_VM_ERR = "ERROR: Canot delete VMs";
    private static WorkerPool pool;
    private static int[] poolCoreMaxConcurrentTasks;
    private static ResourceUser resourceUser;
    private static ResourceOptimizer ro;
    static int maxTasks;
    private static final Logger resourcesLogger;
    private static final Logger runtimeLogger;

    public static void load(ResourceUser resUser) {
        resourceUser = resUser;
        pool = new WorkerPool();
        poolCoreMaxConcurrentTasks = new int[CoreManager.getCoreCount()];
        CloudManager.initialize();
        try {
            ResourceLoader.load(RESOURCES_XML, RESOURCES_XSD, PROJECT_XML, PROJECT_XSD);
        }
        catch (ResourcesFileValidationException e) {
            ErrorManager.fatal((String)ERROR_RESOURCES_XML, (Exception)((Object)e));
        }
        catch (ProjectFileValidationException e) {
            ErrorManager.fatal((String)ERROR_PROJECT_XML, (Exception)((Object)e));
        }
        catch (NoResourceAvailableException e) {
            ErrorManager.fatal((String)ERROR_NO_RES, (Exception)e);
        }
        ro = new ResourceOptimizer(resourceUser);
        ro.setName("Resource Optimizer");
        ro.start();
    }

    public static void stopNodes(ResourceUser.WorkloadStatus status) {
        resourcesLogger.info("TIMESTAMP = " + String.valueOf(System.currentTimeMillis()));
        resourcesLogger.info("INFO_MSG = [Stopping all workers]");
        runtimeLogger.info("Stopping all workers");
        if (ro != null) {
            ro.shutdown(status);
        } else {
            runtimeLogger.info("Resource Optimizer was not initialized");
        }
        if (CloudManager.isUseCloud()) {
            resourcesLogger.debug("DEBUG_MSG = [Terminating cloud instances...]");
            try {
                CloudManager.terminateALL();
                resourcesLogger.info("TOTAL_EXEC_COST = " + CloudManager.getTotalCost());
            }
            catch (Exception e) {
                resourcesLogger.error("Task Scheduler: ERROR: Canot delete VMs", (Throwable)e);
            }
            resourcesLogger.info("INFO_MSG = [Cloud instances terminated]");
        }
        if (pool != null && !pool.getStaticResources().isEmpty()) {
            resourcesLogger.debug("DEBUG_MSG = [Resource Manager retrieving data from workers...]");
            for (Worker<?, ?> r : pool.getStaticResources()) {
                r.retrieveData(false);
            }
            Semaphore sem = new Semaphore(0);
            ShutdownListener sl = new ShutdownListener(sem);
            resourcesLogger.debug("DEBUG_MSG = [Resource Manager stopping workers...]");
            for (Worker<?, ?> r : pool.getStaticResources()) {
                r.stop(sl);
            }
            resourcesLogger.debug("DEBUG_MSG = [Waiting for workers to shutdown...]");
            sl.enable();
            try {
                sem.acquire();
            }
            catch (Exception e) {
                resourcesLogger.error("ERROR_MSG= [ERROR: Exception raised on worker shutdown]");
            }
            resourcesLogger.info("INFO_MSG = [Workers stopped]");
        }
    }

    public static Worker<?, ?> getWorker(String name) {
        return pool.getResource(name);
    }

    public static LinkedList<Worker<?, ?>> getAllWorkers() {
        return pool.findAllResources();
    }

    public static int getTotalNumberOfWorkers() {
        return pool.findAllResources().size();
    }

    public static void updateMasterConfiguration(HashMap<String, String> sharedDisks) {
        Comm.getAppHost().updateSharedDisk(sharedDisks);
        try {
            Comm.getAppHost().start();
        }
        catch (InitNodeException e) {
            ErrorManager.error((String)"Error updating master configuration", (Exception)((Object)e));
        }
    }

    public static void newMethodWorker(String name, MethodResourceDescription rd, HashMap<String, String> sharedDisks, MethodConfiguration mc) {
        int limitOfTasks = mc.getLimitOfTasks();
        int computingUnits = rd.getTotalCPUComputingUnits();
        int taskCount = limitOfTasks < 0 && computingUnits < 0 ? 0 : Math.max(limitOfTasks, computingUnits);
        mc.setLimitOfTasks(taskCount);
        limitOfTasks = mc.getLimitOfGPUTasks();
        computingUnits = rd.getTotalGPUComputingUnits();
        taskCount = limitOfTasks < 0 && computingUnits < 0 ? 0 : Math.max(limitOfTasks, computingUnits);
        mc.setLimitOfGPUTasks(taskCount);
        limitOfTasks = mc.getLimitOfFPGATasks();
        computingUnits = rd.getTotalFPGAComputingUnits();
        taskCount = limitOfTasks < 0 && computingUnits < 0 ? 0 : Math.max(limitOfTasks, computingUnits);
        mc.setLimitOfFPGATasks(taskCount);
        limitOfTasks = mc.getLimitOfOTHERSTasks();
        computingUnits = rd.getTotalOTHERComputingUnits();
        taskCount = limitOfTasks < 0 && computingUnits < 0 ? 0 : Math.max(limitOfTasks, computingUnits);
        mc.setLimitOfOTHERSTasks(taskCount);
        MethodWorker newResource = new MethodWorker(name, rd, mc, sharedDisks);
        maxTasks += newResource.getMaxTaskCount();
        ResourceManager.addStaticResource(newResource);
    }

    public static void newServiceWorker(String wsdl, ServiceResourceDescription sd, ServiceConfiguration sc) {
        ServiceWorker newResource = new ServiceWorker(wsdl, sd, sc);
        ResourceManager.addStaticResource(newResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends WorkerResourceDescription, I extends Implementation<T>> void addStaticResource(Worker<T, I> worker) {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            worker.updatedFeatures();
            pool.addStaticResource(worker);
            pool.defineCriticalSet();
            int[] maxTaskCount = worker.getSimultaneousTasks();
            for (int coreId = 0; coreId < maxTaskCount.length; ++coreId) {
                int n = coreId;
                poolCoreMaxConcurrentTasks[n] = poolCoreMaxConcurrentTasks[n] + maxTaskCount[coreId];
            }
        }
        resourcesLogger.info("TIMESTAMP = " + String.valueOf(System.currentTimeMillis()));
        resourcesLogger.info("INFO_MSG = [New resource available in the pool. Name = " + worker.getName() + "]");
        runtimeLogger.info("New " + (worker.getType() == Resource.Type.SERVICE ? "service" : "computeNode") + " available in the pool. Name = " + worker.getName());
    }

    public static void removeWorker(Worker<?, ?> r) {
        pool.delete(r);
        maxTasks -= r.getMaxTaskCount();
        int[] maxTaskCount = r.getSimultaneousTasks();
        for (int coreId = 0; coreId < maxTaskCount.length; ++coreId) {
            int n = coreId;
            poolCoreMaxConcurrentTasks[n] = poolCoreMaxConcurrentTasks[n] - maxTaskCount[coreId];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void coreElementUpdates(List<Integer> updatedCores) {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            pool.coreElementUpdates(updatedCores);
            CloudManager.newCoreElementsDetected(updatedCores);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCloudWorker(ResourceCreationRequest origin, CloudMethodWorker worker) {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            CloudManager.confirmedRequest(origin, worker);
            worker.updatedFeatures();
            maxTasks += worker.getMaxTaskCount();
            pool.addDynamicResource(worker);
            pool.defineCriticalSet();
            int[] maxTaskCount = worker.getSimultaneousTasks();
            for (int coreId = 0; coreId < maxTaskCount.length; ++coreId) {
                int n = coreId;
                poolCoreMaxConcurrentTasks[n] = poolCoreMaxConcurrentTasks[n] + maxTaskCount[coreId];
            }
        }
        resourceUser.updatedResource(worker);
        resourcesLogger.info("TIMESTAMP = " + String.valueOf(System.currentTimeMillis()));
        resourcesLogger.info("INFO_MSG = [New resource available in the pool. Name = " + worker.getName() + "]");
        runtimeLogger.info("New resource available in the pool. Name = " + worker.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void increasedCloudWorker(ResourceCreationRequest origin, CloudMethodWorker worker, CloudMethodResourceDescription extension) {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            int coreId;
            CloudManager.confirmedRequest(origin, worker);
            int[] maxTaskCount = worker.getSimultaneousTasks();
            for (coreId = 0; coreId < maxTaskCount.length; ++coreId) {
                int n = coreId;
                poolCoreMaxConcurrentTasks[n] = poolCoreMaxConcurrentTasks[n] - maxTaskCount[coreId];
            }
            maxTasks -= worker.getMaxTaskCount();
            worker.increaseFeatures(extension);
            maxTasks += worker.getMaxTaskCount();
            maxTaskCount = worker.getSimultaneousTasks();
            for (coreId = 0; coreId < maxTaskCount.length; ++coreId) {
                int n = coreId;
                poolCoreMaxConcurrentTasks[n] = poolCoreMaxConcurrentTasks[n] + maxTaskCount[coreId];
            }
            pool.defineCriticalSet();
        }
        resourceUser.updatedResource(worker);
        resourcesLogger.info("TIMESTAMP = " + String.valueOf(System.currentTimeMillis()));
        resourcesLogger.info("INFO_MSG = [Resource modified. Name = " + worker.getName() + "]");
        runtimeLogger.info("Resource modified. Name = " + worker.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Semaphore reduceCloudWorker(CloudMethodWorker worker, CloudMethodResourceDescription reduction) {
        Semaphore sem;
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            int coreId;
            int[] maxTaskCount = worker.getSimultaneousTasks();
            for (coreId = 0; coreId < maxTaskCount.length; ++coreId) {
                int n = coreId;
                poolCoreMaxConcurrentTasks[n] = poolCoreMaxConcurrentTasks[n] - maxTaskCount[coreId];
            }
            maxTasks -= worker.getMaxTaskCount();
            sem = worker.reduceFeatures(reduction);
            maxTasks += worker.getMaxTaskCount();
            maxTaskCount = worker.getSimultaneousTasks();
            for (coreId = 0; coreId < maxTaskCount.length; ++coreId) {
                int n = coreId;
                poolCoreMaxConcurrentTasks[n] = poolCoreMaxConcurrentTasks[n] + maxTaskCount[coreId];
            }
            pool.defineCriticalSet();
            resourceUser.updatedResource(worker);
        }
        resourcesLogger.info("TIMESTAMP = " + String.valueOf(System.currentTimeMillis()));
        resourcesLogger.info("INFO_MSG = [Resource removed from the pool. Name = " + worker.getName() + "]");
        runtimeLogger.info("Resource removed from the pool. Name = " + worker.getName());
        return sem;
    }

    public static boolean useCloud() {
        return CloudManager.isUseCloud();
    }

    public static Long getCreationTime() throws Exception {
        try {
            return CloudManager.getNextCreationTime();
        }
        catch (ConnectorException e) {
            throw new Exception(e);
        }
    }

    public static float getCurrentCostPerHour() {
        return CloudManager.currentCostPerHour();
    }

    public static float getTotalCost() {
        return CloudManager.getTotalCost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getTotalSlots() {
        int[] counts = new int[CoreManager.getCoreCount()];
        int[] cloudCount = CloudManager.getPendingCoreCounts();
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            for (int i = 0; i < counts.length; ++i) {
                counts[i] = poolCoreMaxConcurrentTasks[i] + cloudCount[i];
            }
        }
        return counts;
    }

    public static int[] getAvailableSlots() {
        return poolCoreMaxConcurrentTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Worker<?, ?>> getStaticResources() {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            return pool.getStaticResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedList<CloudMethodWorker> getDynamicResources() {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            return pool.getDynamicResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<CloudMethodWorker> getCriticalDynamicResources() {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            return pool.getCriticalResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<CloudMethodWorker> getNonCriticalDynamicResources() {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            return pool.getNonCriticalResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloudMethodWorker getDynamicResource(String name) {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            return pool.getDynamicResource(name);
        }
    }

    public static void refuseCloudRequest(ResourceCreationRequest rcr) {
        CloudManager.refusedRequest(rcr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourcesState getResourcesState() {
        ResourcesState state = new ResourcesState();
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            for (Worker worker : pool.findAllResources()) {
                if (worker.getType().equals((Object)Resource.Type.WORKER)) {
                    int cores = ((MethodResourceDescription)worker.getDescription()).getTotalCPUComputingUnits();
                    float memory = ((MethodResourceDescription)worker.getDescription()).getMemorySize();
                    state.addHost(worker.getName(), worker.getType().toString(), cores, memory, worker.getSimultaneousTasks(), true);
                    continue;
                }
                state.addHost(worker.getName(), worker.getType().toString(), 0, 0.0f, worker.getSimultaneousTasks(), true);
            }
        }
        state.setUseCloud(CloudManager.isUseCloud());
        if (state.getUseCloud()) {
            try {
                state.setCreationTime(CloudManager.getNextCreationTime());
            }
            catch (Exception ex) {
                state.setCreationTime(120000L);
            }
            state.setCurrentCloudVMCount(CloudManager.getCurrentVMCount());
            for (ResourceCreationRequest rcr : CloudManager.getPendingRequests()) {
                int[][] nArray = rcr.requestedSimultaneousTaskCount();
                for (int coreId = 0; coreId < nArray.length; ++coreId) {
                    int coreSlots = 0;
                    for (int implId = 0; implId < nArray[coreId].length; ++implId) {
                        coreSlots += Math.max(coreSlots, nArray[coreId][implId]);
                    }
                    state.updateHostInfo(rcr.getRequested().getName(), rcr.getRequested().getType(), rcr.getRequested().getTotalCPUComputingUnits(), rcr.getRequested().getMemorySize(), coreId, coreSlots, false);
                }
            }
        }
        return state;
    }

    public static String getPendingRequestsMonitorData(String prefix) {
        StringBuilder sb = new StringBuilder();
        LinkedList<ResourceCreationRequest> rcr = CloudManager.getPendingRequests();
        for (ResourceCreationRequest r : rcr) {
            sb.append(prefix).append("<Resource id=\"requested new VM\">").append("\n");
            sb.append(prefix + "\t").append("<CPUComputingUnits>").append(0).append("</CPUComputingUnits>").append("\n");
            sb.append(prefix + "\t").append("<GPUComputingUnits>").append(0).append("</GPUComputingUnits>").append("\n");
            sb.append(prefix + "\t").append("<FPGAComputingUnits>").append(0).append("</FPGAComputingUnits>").append("\n");
            sb.append(prefix + "\t").append("<OTHERComputingUnits>").append(0).append("</OTHERComputingUnits>").append("\n");
            sb.append(prefix + "\t").append("<Memory>").append(0).append("</Memory>").append("\n");
            sb.append(prefix + "\t").append("<Disk>").append(0).append("</Disk>").append("\n");
            sb.append(prefix + "\t").append("<Provider>").append(r.getProvider()).append("</Provider>").append("\n");
            sb.append(prefix + "\t").append("<Image>").append(r.getRequested().getImage().getImageName()).append("</Image>").append("\n");
            sb.append(prefix + "\t").append("<Status>").append("Creating").append("</Status>").append("\n");
            sb.append(prefix + "\t").append("<Tasks>").append("</Tasks>").append("\n");
            sb.append(prefix).append("</Resource>").append("\n");
        }
        return sb.toString();
    }

    public static void printLoadInfo() {
        resourcesLogger.info(resourceUser.getWorkload().toString());
    }

    public static void printResourcesState() {
        resourcesLogger.info("TIMESTAMP = " + String.valueOf(System.currentTimeMillis()));
        resourcesLogger.info(ResourceManager.getResourcesState().toString());
    }

    public static String getCurrentState(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("TIMESTAMP = ").append(String.valueOf(System.currentTimeMillis())).append("\n");
        sb.append(pool.getCurrentState(prefix)).append("\n");
        sb.append(CloudManager.getCurrentState(prefix));
        return sb.toString();
    }

    public static long getMaxTasks() {
        return maxTasks;
    }

    static {
        maxTasks = 0;
        resourcesLogger = LogManager.getLogger((String)"integratedtoolkit.Resources");
        runtimeLogger = LogManager.getLogger((String)"integratedtoolkit.Components.ResourceManager");
    }
}

