/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.types.resources.CloudMethodWorker;
import integratedtoolkit.types.resources.Worker;
import integratedtoolkit.util.CoreManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class WorkerPool {
    private final HashMap<String, Worker<?, ?>> staticSet = new HashMap();
    private final HashMap<String, CloudMethodWorker> criticalSet = new HashMap();
    private final HashMap<String, CloudMethodWorker> nonCriticalSet = new HashMap();
    private final TreeSet<CloudMethodWorker> criticalOrder = new TreeSet();

    public void addStaticResource(Worker<?, ?> newResource) {
        this.staticSet.put(newResource.getName(), newResource);
    }

    public void addDynamicResource(CloudMethodWorker newResource) {
        this.criticalSet.put(newResource.getName(), newResource);
        this.criticalOrder.add(newResource);
    }

    public void coreElementUpdates(List<Integer> newCores) {
        for (Worker<?, ?> worker : this.staticSet.values()) {
            worker.updatedCoreElements(newCores);
        }
        for (CloudMethodWorker cloudMethodWorker : this.criticalSet.values()) {
            cloudMethodWorker.updatedCoreElements(newCores);
        }
        for (CloudMethodWorker cloudMethodWorker : this.nonCriticalSet.values()) {
            cloudMethodWorker.updatedCoreElements(newCores);
        }
    }

    public Collection<Worker<?, ?>> getStaticResources() {
        return this.staticSet.values();
    }

    public Worker<?, ?> getStaticResource(String resourceName) {
        return this.staticSet.get(resourceName);
    }

    public CloudMethodWorker getDynamicResource(String resourceName) {
        CloudMethodWorker resource = null;
        resource = this.criticalSet.get(resourceName);
        if (resource == null) {
            resource = this.nonCriticalSet.get(resourceName);
        }
        return resource;
    }

    public LinkedList<CloudMethodWorker> getDynamicResources() {
        LinkedList<CloudMethodWorker> resources = new LinkedList<CloudMethodWorker>();
        resources.addAll(this.criticalSet.values());
        resources.addAll(this.nonCriticalSet.values());
        return resources;
    }

    public Worker<?, ?> getResource(String resourceName) {
        Worker resource = null;
        resource = this.staticSet.get(resourceName);
        if (resource == null) {
            resource = this.criticalSet.get(resourceName);
        }
        if (resource == null) {
            resource = this.nonCriticalSet.get(resourceName);
        }
        return resource;
    }

    public void delete(Worker<?, ?> resource) {
        String resourceName = resource.getName();
        if (this.nonCriticalSet.remove(resourceName) == null && this.criticalSet.remove(resourceName) == null) {
            this.staticSet.remove(resourceName);
        }
    }

    public List<Integer> getExecutableCores(String res) {
        Worker<?, ?> resource = this.getResource(res);
        if (resource == null) {
            return new LinkedList<Integer>();
        }
        return resource.getExecutableCores();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineCriticalSet() {
        WorkerPool workerPool = this;
        synchronized (workerPool) {
            int coreCount = CoreManager.getCoreCount();
            boolean[] runnable = new boolean[coreCount];
            for (int coreId = 0; coreId < coreCount; ++coreId) {
                runnable[coreId] = false;
            }
            for (Worker<?, ?> res : this.staticSet.values()) {
                LinkedList<Integer> cores = res.getExecutableCores();
                for (int i = 0; i < cores.size(); ++i) {
                    runnable[cores.get((int)i).intValue()] = true;
                }
            }
            for (CloudMethodWorker resource : this.criticalOrder) {
                int i;
                String resourceName = resource.getName();
                LinkedList<Integer> executableCores = resource.getExecutableCores();
                boolean needed = false;
                for (i = 0; i < executableCores.size() && !needed; ++i) {
                    needed = needed || !runnable[executableCores.get(i)];
                }
                if (needed) {
                    for (i = 0; i < executableCores.size(); ++i) {
                        runnable[executableCores.get((int)i).intValue()] = true;
                    }
                    continue;
                }
                this.criticalSet.remove(resourceName);
                this.criticalOrder.remove((Object)resource);
                this.nonCriticalSet.put(resourceName, resource);
            }
        }
    }

    public Collection<CloudMethodWorker> getNonCriticalResources() {
        return this.nonCriticalSet.values();
    }

    public Collection<CloudMethodWorker> getCriticalResources() {
        return this.criticalSet.values();
    }

    public LinkedList<Worker<?, ?>> findAllResources() {
        int i;
        LinkedList workers = new LinkedList();
        if (this.staticSet != null && !this.staticSet.isEmpty()) {
            Object[] arrayStaticSet = this.staticSet.values().toArray();
            for (i = 0; i < arrayStaticSet.length; ++i) {
                workers.add((Worker)((Object)arrayStaticSet[i]));
            }
        }
        if (this.criticalSet != null && !this.criticalSet.isEmpty()) {
            Object[] arrayCriticalSet = this.criticalSet.values().toArray();
            for (i = 0; i < arrayCriticalSet.length; ++i) {
                workers.add((Worker)((Object)arrayCriticalSet[i]));
            }
        }
        if (this.nonCriticalSet != null && !this.nonCriticalSet.isEmpty()) {
            Object[] arrayNonCriticalSet = this.nonCriticalSet.values().toArray();
            for (i = 0; i < arrayNonCriticalSet.length; ++i) {
                workers.add((Worker)((Object)arrayNonCriticalSet[i]));
            }
        }
        return workers;
    }

    public boolean isCriticalRemovalSafe(int[][] slotReductionImpls) {
        int coreCount = CoreManager.getCoreCount();
        int[] slotReductionCores = new int[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            for (int implId = 0; implId < CoreManager.getNumberCoreImplementations((int)coreId); ++implId) {
                if (slotReductionImpls[coreId][implId] <= slotReductionCores[coreId]) continue;
                slotReductionCores[coreId] = slotReductionImpls[coreId][implId];
            }
        }
        int[] slots = new int[coreCount];
        for (CloudMethodWorker r : this.criticalSet.values()) {
            int[] resSlots = r.getSimultaneousTasks();
            for (int coreId = 0; coreId < coreCount; ++coreId) {
                int n = coreId;
                slots[n] = slots[n] + resSlots[coreId];
            }
        }
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            if (slotReductionCores[coreId] <= 0 || slotReductionCores[coreId] < slots[coreId]) continue;
            return false;
        }
        return true;
    }

    public String getCurrentState(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("RESOURCES = [").append("\n");
        for (Worker<?, ?> worker : this.staticSet.values()) {
            sb.append(prefix).append("\t").append("RESOURCE = [").append("\n");
            sb.append(worker.getResourceLinks(prefix + "\t\t"));
            sb.append(prefix).append("\t").append("\t").append("SET = Static").append("\n");
            sb.append(prefix).append("\t").append("]").append("\n");
        }
        for (CloudMethodWorker cloudMethodWorker : this.criticalSet.values()) {
            sb.append(prefix).append("\t").append("RESOURCE = [").append("\n");
            sb.append(cloudMethodWorker.getResourceLinks(prefix + "\t\t"));
            sb.append(prefix).append("\t").append("\t").append("SET = Critical").append("\n");
            sb.append(prefix).append("\t").append("]").append("\n");
        }
        for (CloudMethodWorker cloudMethodWorker : this.nonCriticalSet.values()) {
            sb.append(prefix).append("\t").append("RESOURCE = [").append("\n");
            sb.append(cloudMethodWorker.getResourceLinks(prefix + "\t\t"));
            sb.append(prefix).append("\t").append("\t").append("SET = Non-Critical").append("\n");
            sb.append(prefix).append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("]").append("\n");
        return sb.toString();
    }
}

