/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi;

import ibis.util.ThreadPool;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.engine.util.FileWaiter;
import org.gridlab.gat.io.File;
import org.gridlab.gat.io.FileInputStream;
import org.gridlab.gat.monitoring.Metric;
import org.gridlab.gat.monitoring.MetricDefinition;
import org.gridlab.gat.monitoring.MetricEvent;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.WrapperJobDescription;
import org.gridlab.gat.resources.cpi.JobCpi;
import org.gridlab.gat.resources.cpi.WrapperJobCpi;

public class WrappedJobCpi
extends JobCpi
implements Runnable {
    private MetricDefinition statusMetricDefinition;
    private Metric statusMetric;
    private WrapperJobDescription.WrappedJobInfo info;
    private final WrapperJobCpi wrapper;
    Map<String, Object> jobInfo = null;
    FileWaiter waiter = null;

    public WrappedJobCpi(GATContext gatContext, WrapperJobDescription.WrappedJobInfo info, WrapperJobCpi wrapper) {
        super(gatContext, info.getJobDescription(), null);
        this.info = info;
        this.wrapper = wrapper;
        HashMap<String, Class<Job.JobState>> returnDef = new HashMap<String, Class<Job.JobState>>();
        returnDef.put("status", Job.JobState.class);
        this.statusMetricDefinition = new MetricDefinition("job.status", 2, "JobState", null, null, returnDef);
        this.statusMetric = this.statusMetricDefinition.createMetric(null);
        this.registerMetric("getJobStatus", this.statusMetricDefinition);
        try {
            this.addMetricListener(wrapper, this.statusMetric);
        }
        catch (GATInvocationException gATInvocationException) {
            // empty catch block
        }
        ThreadPool.createNew((Runnable)this, (String)("Wrapped Job State Monitor " + this.getJobID()));
    }

    private void fireStateMetric(Job.JobState state) {
        if (logger.isInfoEnabled()) {
            logger.info("WrappedJob firing metric " + state);
        }
        MetricEvent v = new MetricEvent((Object)this, (Object)state, this.statusMetric, System.currentTimeMillis());
        this.fireMetric(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        URI jobState = this.info.getJobStateFileName();
        GATContext context = ((JobCpi)this.wrapper.getWrapperJob()).gatContext;
        if (!jobState.isAbsolute()) {
            String authority = ((JobCpi)this.wrapper.getWrapperJob()).sandbox.getAuthority();
            try {
                jobState = jobState.setScheme("any");
                jobState = jobState.setAuthority(authority);
            }
            catch (Throwable e) {
                logger.debug("Modifying jobState URI gave exception", e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Resulting jobStateFile = " + jobState);
            }
        }
        String s = jobState.toString();
        int index = s.lastIndexOf("/");
        String directory = s.substring(0, index);
        String file = s.substring(index + 1);
        try {
            this.waiter = FileWaiter.createFileWaiter(GAT.createFile((GATContext)context, (String)directory));
        }
        catch (Throwable e) {
            logger.debug("Should not happen: ", e);
            return;
        }
        do {
            this.waiter.waitFor(file);
            Job.JobState newstate = null;
            ObjectInputStream din = null;
            FileInputStream fin = null;
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                try {
                    fin = GAT.createFileInputStream((GATContext)context, (URI)jobState);
                    din = new ObjectInputStream(new BufferedInputStream((InputStream)fin));
                    this.jobInfo = (Map)din.readObject();
                    s = (String)this.jobInfo.get("state");
                    newstate = Job.JobState.valueOf((String)s);
                }
                catch (Throwable e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("", e);
                    }
                }
                finally {
                    if (fin != null) {
                        if (din != null) {
                            try {
                                din.close();
                            }
                            catch (Throwable throwable) {}
                        }
                        try {
                            fin.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            if (newstate == null) continue;
            this.state = newstate;
            this.fireStateMetric(this.state);
            clazz = this.getClass();
            synchronized (clazz) {
                try {
                    File monitorFile = GAT.createFile((GATContext)context, (URI)jobState);
                    if (!monitorFile.delete()) {
                        logger.info("Could not delete job status file!");
                    }
                }
                catch (Throwable e) {
                    logger.info("Could not delete job status file!");
                }
            }
        } while (this.state != Job.JobState.STOPPED && this.state != Job.JobState.SUBMISSION_ERROR);
    }

    @Override
    public Map<String, Object> getInfo() {
        return new HashMap<String, Object>(this.jobInfo);
    }

    @Override
    public String toString() {
        if (this.info == null) {
            return super.toString();
        }
        return "Wrapped job, index " + this.info.getWrappedJobIndex() + ", wrapper job index " + this.info.getWrapperJobIndex() + ", id is " + this.jobID;
    }
}

