/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.scheduler.fullGraphScheduler;

import integratedtoolkit.components.impl.ResourceScheduler;
import integratedtoolkit.scheduler.exceptions.BlockedActionException;
import integratedtoolkit.scheduler.exceptions.InvalidSchedulingException;
import integratedtoolkit.scheduler.exceptions.UnassignedActionException;
import integratedtoolkit.scheduler.fullGraphScheduler.FullGraphSchedulingInformation;
import integratedtoolkit.scheduler.types.ActionOrchestrator;
import integratedtoolkit.scheduler.types.AllocatableAction;
import integratedtoolkit.scheduler.types.FullGraphScore;
import integratedtoolkit.scheduler.types.Gap;
import integratedtoolkit.scheduler.types.LocalOptimizationState;
import integratedtoolkit.scheduler.types.OptimizationAction;
import integratedtoolkit.scheduler.types.PriorityActionSet;
import integratedtoolkit.scheduler.types.Profile;
import integratedtoolkit.scheduler.types.SchedulingEvent;
import integratedtoolkit.scheduler.types.Score;
import integratedtoolkit.types.TaskDescription;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.ResourceDescription;
import integratedtoolkit.types.resources.Worker;
import integratedtoolkit.types.resources.WorkerResourceDescription;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Set;

public class FullGraphResourceScheduler<P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>>
extends ResourceScheduler<P, T, I> {
    public static final long DATA_TRANSFER_DELAY = 200L;
    private final ActionOrchestrator<P, T, I> orchestrator;
    private final LinkedList<Gap<P, T, I>> gaps;
    private OptimizationAction<P, T, I> opAction;
    private Set<AllocatableAction<P, T, I>> pendingUnschedulings = new HashSet<AllocatableAction<P, T, I>>();

    public FullGraphResourceScheduler(Worker<T, I> w, ActionOrchestrator<P, T, I> orchestrator) {
        super(w);
        this.orchestrator = orchestrator;
        this.gaps = new LinkedList();
        this.addGap(new Gap(Long.MIN_VALUE, Long.MAX_VALUE, null, this.myWorker.getDescription().copy(), 0));
    }

    public Score generateResourceScore(AllocatableAction<P, T, I> action, TaskDescription params, Score actionScore) {
        LOGGER.debug("[FullGraphScheduler] Generate resource score for action " + action.getId());
        double resScore = actionScore.calculateResourceScore(params, this.myWorker);
        for (AllocatableAction pred : action.getDataPredecessors()) {
            if (!pred.isPending() || pred.getAssignedResource() != this) continue;
            resScore += 1.0;
        }
        resScore = (double)params.getParameters().length - resScore;
        long lessTimeStamp = Long.MAX_VALUE;
        Gap<P, T, I> g = this.gaps.peekFirst();
        if (g != null && (lessTimeStamp = g.getInitialTime()) < 0L) {
            lessTimeStamp = 0L;
        }
        return new FullGraphScore((FullGraphScore)actionScore, resScore * 200.0, 0.0, (double)lessTimeStamp, 0.0);
    }

    public Score generateImplementationScore(AllocatableAction<P, T, I> action, TaskDescription params, I impl, Score resourceScore) {
        Profile p;
        LOGGER.debug("[FullGraphScheduler] Generate implementation score for action " + action.getId());
        ResourceDescription rd = impl.getRequirements().copy();
        long resourceFreeTime = 0L;
        try {
            for (Gap gap : this.gaps) {
                rd.reduceDynamic(gap.getResources());
                if (!rd.isDynamicUseless()) continue;
                resourceFreeTime = gap.getInitialTime();
                break;
            }
        }
        catch (ConcurrentModificationException cme) {
            resourceFreeTime = 0L;
        }
        if (resourceFreeTime < 0L) {
            resourceFreeTime = 0L;
        }
        long implScore = (p = this.getProfile((Implementation)impl)) != null ? p.getAverageExecutionTime() : 0L;
        return new FullGraphScore((FullGraphScore)resourceScore, 0.0, 0.0, (double)resourceFreeTime, (double)implScore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAction(AllocatableAction<P, T, I> action) {
        try {
            LinkedList<Gap<P, T, I>> linkedList = this.gaps;
            synchronized (linkedList) {
                if (this.opAction != null) {
                    ((FullGraphSchedulingInformation)this.opAction.getSchedulingInfo()).addSuccessor(action);
                    ((FullGraphSchedulingInformation)action.getSchedulingInfo()).addPredecessor(this.opAction);
                } else {
                    this.scheduleUsingGaps(action, this.gaps);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception on initial schedule", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<AllocatableAction<P, T, I>> unscheduleAction(AllocatableAction<P, T, I> action) {
        FullGraphSchedulingInformation successorDSI;
        FullGraphSchedulingInformation predDSI;
        LinkedList<AllocatableAction<P, T, I>> freeTasks = new LinkedList<AllocatableAction<P, T, I>>();
        FullGraphSchedulingInformation actionDSI = (FullGraphSchedulingInformation)action.getSchedulingInfo();
        LinkedList<AllocatableAction> successors = new LinkedList<AllocatableAction>();
        for (AllocatableAction allocatableAction : actionDSI.getPredecessors()) {
            predDSI = (FullGraphSchedulingInformation)allocatableAction.getSchedulingInfo();
            predDSI.lock();
        }
        actionDSI.lock();
        for (AllocatableAction allocatableAction : actionDSI.getPredecessors()) {
            predDSI = (FullGraphSchedulingInformation)allocatableAction.getSchedulingInfo();
            predDSI.removeSuccessor(action);
        }
        for (AllocatableAction allocatableAction : actionDSI.getSuccessors()) {
            FullGraphSchedulingInformation succDSI = (FullGraphSchedulingInformation)allocatableAction.getSchedulingInfo();
            succDSI.lock();
            successors.add(allocatableAction);
        }
        for (AllocatableAction allocatableAction : actionDSI.getSuccessors()) {
            successorDSI = (FullGraphSchedulingInformation)allocatableAction.getSchedulingInfo();
            successorDSI.removePredecessor(action);
            for (AllocatableAction allocatableAction2 : actionDSI.getPredecessors()) {
                FullGraphSchedulingInformation predDSI2 = (FullGraphSchedulingInformation)allocatableAction2.getSchedulingInfo();
                if (!predDSI2.isScheduled()) continue;
                successorDSI.addPredecessor(allocatableAction2);
                predDSI2.addSuccessor(allocatableAction);
            }
            if (!successorDSI.isExecutable()) continue;
            freeTasks.add(allocatableAction);
        }
        for (AllocatableAction allocatableAction : actionDSI.getPredecessors()) {
            predDSI = (FullGraphSchedulingInformation)allocatableAction.getSchedulingInfo();
            predDSI.unlock();
        }
        actionDSI.unscheduled();
        if (actionDSI.isOnOptimization()) {
            Iterator iterator = this.gaps;
            synchronized (iterator) {
                this.pendingUnschedulings.add(action);
            }
        }
        actionDSI.unlock();
        for (AllocatableAction allocatableAction : successors) {
            successorDSI = (FullGraphSchedulingInformation)allocatableAction.getSchedulingInfo();
            successorDSI.unlock();
        }
        return freeTasks;
    }

    public void clear() {
        super.clear();
        this.gaps.clear();
        this.addGap(new Gap(Long.MIN_VALUE, Long.MAX_VALUE, null, this.myWorker.getDescription().copy(), 0));
    }

    private void scheduleUsingGaps(AllocatableAction<P, T, I> action, LinkedList<Gap<P, T, I>> gaps) {
        ResourceDescription gapResource;
        FullGraphSchedulingInformation predDSI;
        Gap<P, T, I> gap;
        long expectedStart = 0L;
        for (AllocatableAction predecessor2 : action.getDataPredecessors()) {
            FullGraphSchedulingInformation predDSI2 = (FullGraphSchedulingInformation)predecessor2.getSchedulingInfo();
            if (!predDSI2.isScheduled()) continue;
            long predEnd = predDSI2.getExpectedEnd();
            expectedStart = Math.max(expectedStart, predEnd);
        }
        FullGraphSchedulingInformation schedInfo = (FullGraphSchedulingInformation)action.getSchedulingInfo();
        Implementation impl = action.getAssignedImplementation();
        Profile p = this.getProfile(impl);
        ResourceDescription constraints = impl.getRequirements().copy();
        LinkedList<AllocatableAction<P, T, I>> predecessors = new LinkedList<AllocatableAction<P, T, I>>();
        Iterator<Gap<P, T, I>> gapIt = gaps.descendingIterator();
        boolean fullyCoveredReqs = false;
        while (gapIt.hasNext() && !fullyCoveredReqs) {
            gap = gapIt.next();
            if (gap.getInitialTime() > expectedStart) continue;
            AllocatableAction<P, T, I> allocatableAction = gap.getOrigin();
            if (allocatableAction != null) {
                predDSI = (FullGraphSchedulingInformation)allocatableAction.getSchedulingInfo();
                predDSI.lock();
                predecessors.add(allocatableAction);
            }
            gapResource = gap.getResources();
            ResourceDescription.reduceCommonDynamics((ResourceDescription)gapResource, (ResourceDescription)constraints);
            if (gapResource.isDynamicUseless()) {
                gapIt.remove();
            }
            if (!constraints.isDynamicUseless()) continue;
            fullyCoveredReqs = true;
        }
        gapIt = gaps.iterator();
        while (gapIt.hasNext() && !fullyCoveredReqs) {
            gap = gapIt.next();
            AllocatableAction<P, T, I> allocatableAction = gap.getOrigin();
            if (allocatableAction != null) {
                predDSI = (FullGraphSchedulingInformation)allocatableAction.getSchedulingInfo();
                predDSI.lock();
                predecessors.add(allocatableAction);
            }
            gapResource = gap.getResources();
            ResourceDescription.reduceCommonDynamics((ResourceDescription)gapResource, (ResourceDescription)constraints);
            if (gapResource.isDynamicUseless()) {
                gapIt.remove();
            }
            if (!constraints.isDynamicUseless()) continue;
            fullyCoveredReqs = true;
        }
        schedInfo.lock();
        schedInfo.scheduled();
        for (AllocatableAction allocatableAction : predecessors) {
            predDSI = (FullGraphSchedulingInformation)allocatableAction.getSchedulingInfo();
            if (predDSI.isScheduled()) {
                long predEnd = predDSI.getExpectedEnd();
                expectedStart = Math.max(expectedStart, predEnd);
                schedInfo.addPredecessor(allocatableAction);
                predDSI.addSuccessor(action);
            }
            predDSI.unlock();
        }
        schedInfo.setExpectedStart(expectedStart);
        long expectedEnd = expectedStart;
        if (p != null) {
            expectedEnd += p.getAverageExecutionTime();
        }
        schedInfo.setExpectedEnd(expectedEnd);
        schedInfo.unlock();
        this.addGap(new Gap<P, T, I>(expectedEnd, Long.MAX_VALUE, action, impl.getRequirements().copy(), 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PriorityQueue<AllocatableAction<P, T, I>> localOptimization(long updateId, Comparator<AllocatableAction<P, T, I>> selectionComparator, Comparator<AllocatableAction<P, T, I>> donorComparator) {
        LinkedList pendingSchedulings;
        PriorityQueue<AllocatableAction<P, T, I>> actions = new PriorityQueue<AllocatableAction<P, T, I>>(1, donorComparator);
        PriorityQueue<AllocatableAction<P, T, I>> readyActions = new PriorityQueue<AllocatableAction<P, T, I>>(1, FullGraphResourceScheduler.getReadyComparator());
        PriorityActionSet<P, T, I> selectableActions = new PriorityActionSet<P, T, I>(selectionComparator);
        LinkedList<Gap<P, T, I>> linkedList = this.gaps;
        synchronized (linkedList) {
            this.opAction = new OptimizationAction<P, T, I>(this.orchestrator);
        }
        LinkedList<AllocatableAction<P, T, I>> runningActions = this.scanActions(readyActions, selectableActions);
        LinkedList newPendingSchedulings = new LinkedList();
        LinkedList<Gap<P, T, I>> linkedList2 = this.gaps;
        synchronized (linkedList2) {
            FullGraphSchedulingInformation opDSI = (FullGraphSchedulingInformation)this.opAction.getSchedulingInfo();
            pendingSchedulings = opDSI.replaceSuccessors(newPendingSchedulings);
        }
        this.classifyPendingSchedulings(pendingSchedulings, readyActions, selectableActions, runningActions);
        this.classifyPendingSchedulings(readyActions, selectableActions, runningActions);
        LinkedList<Gap<P, T, I>> newGaps = this.rescheduleTasks(updateId, readyActions, selectableActions, runningActions, actions);
        LinkedList<Gap<P, T, I>> linkedList3 = this.gaps;
        synchronized (linkedList3) {
            this.gaps.clear();
            this.gaps.addAll(newGaps);
            FullGraphSchedulingInformation opDSI = (FullGraphSchedulingInformation)this.opAction.getSchedulingInfo();
            LinkedList successors = opDSI.getSuccessors();
            for (AllocatableAction allocatableAction : successors) {
                actions.add(allocatableAction);
                FullGraphSchedulingInformation actionDSI = (FullGraphSchedulingInformation)allocatableAction.getSchedulingInfo();
                actionDSI.lock();
                actionDSI.removePredecessor(this.opAction);
                if (allocatableAction != null) {
                    this.scheduleUsingGaps(allocatableAction, this.gaps);
                }
                actionDSI.unlock();
            }
            opDSI.clearSuccessors();
            this.opAction = null;
        }
        return actions;
    }

    public LinkedList<AllocatableAction<P, T, I>> scanActions(PriorityQueue<AllocatableAction<P, T, I>> readyActions, PriorityActionSet<P, T, I> selectableActions) {
        AllocatableAction<P, T, I> action;
        LinkedList<AllocatableAction<P, T, I>> runningActions = new LinkedList<AllocatableAction<P, T, I>>();
        PriorityQueue<AllocatableAction<P, T, I>> actions = new PriorityQueue<AllocatableAction<P, T, I>>(1, FullGraphResourceScheduler.getScanComparator());
        for (Gap gap : this.gaps) {
            AllocatableAction gapAction = gap.getOrigin();
            if (gapAction == null) continue;
            FullGraphSchedulingInformation dsi = (FullGraphSchedulingInformation)gapAction.getSchedulingInfo();
            dsi.lock();
            dsi.setOnOptimization(true);
            actions.add(gapAction);
        }
        while ((action = actions.poll()) != null) {
            FullGraphSchedulingInformation fullGraphSchedulingInformation = (FullGraphSchedulingInformation)action.getSchedulingInfo();
            if (!fullGraphSchedulingInformation.isScheduled()) {
                fullGraphSchedulingInformation.unlock();
                continue;
            }
            boolean hasInternal = false;
            boolean hasExternal = false;
            long startTime = 0L;
            try {
                LinkedList dPreds = action.getDataPredecessors();
                for (AllocatableAction dPred : dPreds) {
                    FullGraphSchedulingInformation fullGraphSchedulingInformation2 = (FullGraphSchedulingInformation)dPred.getSchedulingInfo();
                    if (dPred.getAssignedResource() == this) {
                        if (!fullGraphSchedulingInformation2.tryToLock()) continue;
                        if (fullGraphSchedulingInformation2.isScheduled()) {
                            hasInternal = true;
                            fullGraphSchedulingInformation2.optimizingSuccessor(action);
                        }
                        fullGraphSchedulingInformation2.unlock();
                        continue;
                    }
                    hasExternal = true;
                    startTime = Math.max(startTime, fullGraphSchedulingInformation2.getExpectedEnd());
                }
            }
            catch (ConcurrentModificationException cme) {
                hasInternal = false;
                hasExternal = false;
                startTime = 0L;
            }
            boolean hasResourcePredecessors = false;
            LinkedList rPreds = fullGraphSchedulingInformation.getPredecessors();
            for (AllocatableAction allocatableAction : rPreds) {
                FullGraphSchedulingInformation rPredDSI = (FullGraphSchedulingInformation)allocatableAction.getSchedulingInfo();
                if (!rPredDSI.tryToLock()) continue;
                if (rPredDSI.isScheduled()) {
                    hasResourcePredecessors = true;
                    if (!rPredDSI.isOnOptimization()) {
                        rPredDSI.setOnOptimization(true);
                        actions.add(allocatableAction);
                        continue;
                    }
                    rPredDSI.unlock();
                    continue;
                }
                rPredDSI.unlock();
            }
            fullGraphSchedulingInformation.setExpectedStart(startTime);
            fullGraphSchedulingInformation.setToReschedule(true);
            this.classifyAction(action, hasInternal, hasExternal, hasResourcePredecessors, startTime, readyActions, selectableActions, runningActions);
            if (!hasResourcePredecessors && !hasInternal) continue;
            fullGraphSchedulingInformation.unlock();
        }
        return runningActions;
    }

    public void classifyPendingSchedulings(LinkedList<AllocatableAction<P, T, I>> pendingSchedulings, PriorityQueue<AllocatableAction<P, T, I>> readyActions, PriorityActionSet<P, T, I> selectableActions, LinkedList<AllocatableAction<P, T, I>> runningActions) {
        for (AllocatableAction allocatableAction : pendingSchedulings) {
            FullGraphSchedulingInformation actionDSI = (FullGraphSchedulingInformation)allocatableAction.getSchedulingInfo();
            actionDSI.scheduled();
            actionDSI.setOnOptimization(true);
            actionDSI.setToReschedule(true);
            boolean hasInternal = false;
            boolean hasExternal = false;
            long startTime = 0L;
            try {
                LinkedList dPreds = allocatableAction.getDataPredecessors();
                for (AllocatableAction dPred : dPreds) {
                    FullGraphSchedulingInformation dPredDSI = (FullGraphSchedulingInformation)dPred.getSchedulingInfo();
                    if (dPred.getAssignedResource() == this) {
                        if (!dPredDSI.tryToLock()) continue;
                        if (dPredDSI.isScheduled()) {
                            hasInternal = true;
                            dPredDSI.optimizingSuccessor(allocatableAction);
                        }
                        dPredDSI.unlock();
                        continue;
                    }
                    hasExternal = true;
                    startTime = Math.max(startTime, dPredDSI.getExpectedEnd());
                }
            }
            catch (ConcurrentModificationException cme) {
                hasInternal = false;
                hasExternal = false;
                startTime = 0L;
            }
            actionDSI.setExpectedStart(startTime);
            this.classifyAction(allocatableAction, hasInternal, hasExternal, true, startTime, readyActions, selectableActions, runningActions);
        }
    }

    public void classifyPendingSchedulings(PriorityQueue<AllocatableAction<P, T, I>> readyActions, PriorityActionSet<P, T, I> selectableActions, LinkedList<AllocatableAction<P, T, I>> runningActions) {
        for (AllocatableAction<P, T, I> unscheduledAction : this.pendingUnschedulings) {
            FullGraphSchedulingInformation actionDSI = (FullGraphSchedulingInformation)unscheduledAction.getSchedulingInfo();
            LinkedList successors = actionDSI.getOptimizingSuccessors();
            for (AllocatableAction allocatableAction : successors) {
                boolean hasInternal = false;
                boolean hasExternal = false;
                long startTime = 0L;
                try {
                    LinkedList dPreds = allocatableAction.getDataPredecessors();
                    for (AllocatableAction dPred : dPreds) {
                        FullGraphSchedulingInformation dPredDSI = (FullGraphSchedulingInformation)dPred.getSchedulingInfo();
                        if (dPred.getAssignedResource() == this) {
                            if (!dPredDSI.tryToLock()) continue;
                            if (dPredDSI.isScheduled()) {
                                hasInternal = true;
                                dPredDSI.optimizingSuccessor(allocatableAction);
                            }
                            dPredDSI.unlock();
                            continue;
                        }
                        hasExternal = true;
                        startTime = Math.max(startTime, dPredDSI.getExpectedEnd());
                    }
                }
                catch (ConcurrentModificationException cme) {
                    hasInternal = false;
                    hasExternal = false;
                    startTime = 0L;
                }
                actionDSI.setExpectedStart(startTime);
                this.classifyAction(allocatableAction, hasInternal, hasExternal, true, startTime, readyActions, selectableActions, runningActions);
            }
        }
        this.pendingUnschedulings.clear();
    }

    public LinkedList<Gap<P, T, I>> rescheduleTasks(long updateId, PriorityQueue<AllocatableAction<P, T, I>> readyActions, PriorityActionSet<P, T, I> selectableActions, LinkedList<AllocatableAction<P, T, I>> runningActions, PriorityQueue<AllocatableAction<P, T, I>> rescheduledActions) {
        LocalOptimizationState<P, T, I> state = new LocalOptimizationState<P, T, I>(updateId, (ResourceDescription)this.myWorker.getDescription());
        Gap gap = state.peekFirstGap();
        ResourceDescription gapResource = gap.getResources();
        PriorityQueue<SchedulingEvent> schedulingQueue = new PriorityQueue<SchedulingEvent>();
        for (AllocatableAction allocatableAction : runningActions) {
            this.manageRunningAction(allocatableAction, state);
            FullGraphSchedulingInformation actionDSI = (FullGraphSchedulingInformation)allocatableAction.getSchedulingInfo();
            schedulingQueue.offer(new SchedulingEvent.End(actionDSI.getExpectedEnd(), allocatableAction));
        }
        while (!selectableActions.isEmpty() && !gapResource.isDynamicUseless()) {
            AllocatableAction<P, T, I> top = selectableActions.peek();
            state.replaceAction(top);
            if (!state.canActionRun()) break;
            selectableActions.poll();
            FullGraphSchedulingInformation fullGraphSchedulingInformation = (FullGraphSchedulingInformation)top.getSchedulingInfo();
            fullGraphSchedulingInformation.lock();
            fullGraphSchedulingInformation.clearPredecessors();
            this.manageRunningAction(top, state);
            if (!this.tryToLaunch(top)) continue;
            schedulingQueue.offer(new SchedulingEvent.End<P, T, I>(fullGraphSchedulingInformation.getExpectedEnd(), top));
        }
        while (!schedulingQueue.isEmpty() || !readyActions.isEmpty()) {
            while (!schedulingQueue.isEmpty()) {
                SchedulingEvent e = (SchedulingEvent)schedulingQueue.poll();
                LinkedList linkedList = e.process(state, this, readyActions, selectableActions, rescheduledActions);
                for (SchedulingEvent schedulingEvent : linkedList) {
                    schedulingQueue.offer(schedulingEvent);
                }
            }
            if (readyActions.isEmpty()) continue;
            AllocatableAction<P, T, I> topAction = readyActions.poll();
            FullGraphSchedulingInformation fullGraphSchedulingInformation = (FullGraphSchedulingInformation)topAction.getSchedulingInfo();
            fullGraphSchedulingInformation.lock();
            fullGraphSchedulingInformation.setToReschedule(false);
            schedulingQueue.offer(new SchedulingEvent.Start<P, T, I>(fullGraphSchedulingInformation.getExpectedStart(), topAction));
        }
        for (Gap gap2 : state.getGaps()) {
            state.removeTmpGap(gap2);
        }
        return state.getGaps();
    }

    private void classifyAction(AllocatableAction<P, T, I> action, boolean hasInternal, boolean hasExternal, boolean hasResourcePredecessors, long startTime, PriorityQueue<AllocatableAction<P, T, I>> readyActions, PriorityActionSet<P, T, I> selectableActions, LinkedList<AllocatableAction<P, T, I>> runningActions) {
        if (!hasInternal) {
            if (hasExternal) {
                if (startTime == 0L) {
                    selectableActions.offer(action);
                } else {
                    readyActions.add(action);
                }
            } else if (hasResourcePredecessors) {
                selectableActions.offer(action);
            } else {
                runningActions.add(action);
            }
        }
    }

    private void manageRunningAction(AllocatableAction<P, T, I> action, LocalOptimizationState<P, T, I> state) {
        Implementation impl = action.getAssignedImplementation();
        FullGraphSchedulingInformation actionDSI = (FullGraphSchedulingInformation)action.getSchedulingInfo();
        Long startTime = action.getStartTime();
        long start = startTime != null ? startTime - state.getId() : 0L;
        actionDSI.setExpectedStart(start);
        Profile p = this.getProfile(impl);
        long endTime = start;
        if (p != null) {
            endTime += p.getAverageExecutionTime();
        }
        if (endTime < 0L) {
            endTime = 0L;
        }
        actionDSI.setExpectedEnd(endTime);
        actionDSI.clearPredecessors();
        actionDSI.clearSuccessors();
        actionDSI.setToReschedule(false);
        state.reserveResources((ResourceDescription)impl.getRequirements(), 0L);
    }

    private boolean tryToLaunch(AllocatableAction<P, T, I> action) {
        try {
            action.tryToLaunch();
            return true;
        }
        catch (InvalidSchedulingException ise) {
            LOGGER.error("Exception on tryToLaunch", (Throwable)ise);
            try {
                double actionScore = FullGraphScore.getActionScore(action);
                double dataTime = new FullGraphScore(0.0, 0.0, 0.0, 0.0, 0.0).getDataPredecessorTime(action.getDataPredecessors());
                FullGraphScore aScore = new FullGraphScore(actionScore, dataTime, 0.0, 0.0, 0.0);
                boolean keepTrying = true;
                for (int i = 0; i < action.getConstrainingPredecessors().size() && keepTrying; ++i) {
                    AllocatableAction pre = (AllocatableAction)action.getConstrainingPredecessors().get(i);
                    action.schedule(pre.getAssignedResource(), aScore);
                    try {
                        action.tryToLaunch();
                        keepTrying = false;
                        continue;
                    }
                    catch (InvalidSchedulingException ise2) {
                        keepTrying = true;
                    }
                }
            }
            catch (BlockedActionException | UnassignedActionException be) {
                LOGGER.error("Blocked or unassigned action", (Throwable)ise);
            }
            return false;
        }
    }

    public static <P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>> Comparator<AllocatableAction<P, T, I>> getScanComparator() {
        return new Comparator<AllocatableAction<P, T, I>>(){

            @Override
            public int compare(AllocatableAction<P, T, I> action1, AllocatableAction<P, T, I> action2) {
                FullGraphSchedulingInformation action1DSI = (FullGraphSchedulingInformation)action1.getSchedulingInfo();
                FullGraphSchedulingInformation action2DSI = (FullGraphSchedulingInformation)action2.getSchedulingInfo();
                int compare = Long.compare(action2DSI.getExpectedStart(), action1DSI.getExpectedStart());
                if (compare == 0) {
                    return Long.compare(action2.getId(), action1.getId());
                }
                return compare;
            }
        };
    }

    public static <P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>> Comparator<AllocatableAction<P, T, I>> getReadyComparator() {
        return new Comparator<AllocatableAction<P, T, I>>(){

            @Override
            public int compare(AllocatableAction<P, T, I> action1, AllocatableAction<P, T, I> action2) {
                FullGraphSchedulingInformation action1DSI = (FullGraphSchedulingInformation)action1.getSchedulingInfo();
                FullGraphSchedulingInformation action2DSI = (FullGraphSchedulingInformation)action2.getSchedulingInfo();
                int compare = Long.compare(action1DSI.getExpectedStart(), action2DSI.getExpectedStart());
                if (compare == 0) {
                    return Long.compare(action1.getId(), action2.getId());
                }
                return compare;
            }
        };
    }

    private void addGap(Gap<P, T, I> g) {
        Gap gap;
        Iterator gapIt = this.gaps.iterator();
        int index = 0;
        while (gapIt.hasNext() && (gap = (Gap)gapIt.next()) != null && gap.getInitialTime() <= g.getInitialTime()) {
            ++index;
        }
        this.gaps.add(index, g);
    }

    public long getLastGapExpectedStart() {
        return this.gaps.peekFirst().getInitialTime();
    }
}

