/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.scheduler.fullGraphScheduler;

import integratedtoolkit.components.impl.ResourceScheduler;
import integratedtoolkit.components.impl.TaskScheduler;
import integratedtoolkit.scheduler.fullGraphScheduler.FullGraphResourceScheduler;
import integratedtoolkit.scheduler.fullGraphScheduler.FullGraphSchedulingInformation;
import integratedtoolkit.scheduler.fullGraphScheduler.ScheduleOptimizer;
import integratedtoolkit.scheduler.types.AllocatableAction;
import integratedtoolkit.scheduler.types.FullGraphScore;
import integratedtoolkit.scheduler.types.Profile;
import integratedtoolkit.scheduler.types.SchedulingInformation;
import integratedtoolkit.scheduler.types.Score;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.Worker;
import integratedtoolkit.types.resources.WorkerResourceDescription;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FullGraphScheduler<P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>>
extends TaskScheduler<P, T, I> {
    private static final Logger LOGGER = LogManager.getLogger((String)"integratedtoolkit.Components.TaskDispatcher.TaskScheduler");
    private final FullGraphScore<P, T, I> dummyScore = new FullGraphScore(0.0, 0.0, 0.0, 0.0, 0.0);
    private final ScheduleOptimizer<P, T, I> optimizer = new ScheduleOptimizer(this);

    public FullGraphScheduler() {
        this.optimizer.start();
    }

    public void shutdown() {
        try {
            this.optimizer.shutdown();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    public SchedulingInformation<P, T, I> generateSchedulingInformation() {
        LOGGER.info("[FGScheduler] Generate empty scheduling information");
        return new FullGraphSchedulingInformation();
    }

    public ResourceScheduler<P, T, I> generateSchedulerForResource(Worker<T, I> w) {
        LOGGER.info("[FGScheduler] Generate scheduler for resource " + w.getName());
        return new FullGraphResourceScheduler(w, this.getOrchestrator());
    }

    public Score generateActionScore(AllocatableAction<P, T, I> action) {
        LOGGER.info("[FGScheduler] Generate Action Score for " + action);
        long actionScore = FullGraphScore.getActionScore(action);
        long dataTime = this.dummyScore.getDataPredecessorTime(action.getDataPredecessors());
        return new FullGraphScore(actionScore, (double)dataTime, 0.0, 0.0, 0.0);
    }
}

