/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.scheduler.fullGraphScheduler;

import integratedtoolkit.scheduler.types.AllocatableAction;
import integratedtoolkit.scheduler.types.Profile;
import integratedtoolkit.scheduler.types.SchedulingInformation;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.WorkerResourceDescription;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class FullGraphSchedulingInformation<P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>>
extends SchedulingInformation<P, T, I> {
    private final ReentrantLock l = new ReentrantLock();
    private boolean scheduled = false;
    private long lastUpdate;
    private long expectedStart = 0L;
    private long expectedEnd = 0L;
    private int openGaps = 0;
    private final LinkedList<AllocatableAction<P, T, I>> resourcePredecessors = new LinkedList();
    private LinkedList<AllocatableAction<P, T, I>> resourceSuccessors = new LinkedList();
    private boolean onOptimization = false;
    private boolean toReschedule = false;
    private final LinkedList<AllocatableAction<P, T, I>> optimizingSuccessors;

    public FullGraphSchedulingInformation() {
        this.lastUpdate = System.currentTimeMillis();
        this.optimizingSuccessors = new LinkedList();
    }

    public void addPredecessor(AllocatableAction<P, T, I> predecessor) {
        this.resourcePredecessors.add(predecessor);
    }

    public boolean hasPredecessors() {
        return !this.resourcePredecessors.isEmpty();
    }

    public final boolean isExecutable() {
        this.lock();
        boolean b = this.resourcePredecessors.isEmpty();
        this.unlock();
        return b;
    }

    public LinkedList<AllocatableAction<P, T, I>> getPredecessors() {
        return this.resourcePredecessors;
    }

    public void removePredecessor(AllocatableAction<P, T, I> successor) {
        this.resourcePredecessors.remove(successor);
    }

    public void clearPredecessors() {
        this.resourcePredecessors.clear();
    }

    public void addSuccessor(AllocatableAction<P, T, I> successor) {
        this.resourceSuccessors.add(successor);
    }

    public LinkedList<AllocatableAction<P, T, I>> getSuccessors() {
        return this.resourceSuccessors;
    }

    public void removeSuccessor(AllocatableAction<P, T, I> successor) {
        this.resourceSuccessors.remove(successor);
    }

    public void clearSuccessors() {
        this.resourceSuccessors.clear();
    }

    public LinkedList<AllocatableAction<P, T, I>> replaceSuccessors(LinkedList<AllocatableAction<P, T, I>> newSuccessors) {
        LinkedList<AllocatableAction<P, T, I>> oldSuccessors = this.resourceSuccessors;
        this.resourceSuccessors = newSuccessors;
        return oldSuccessors;
    }

    public void setExpectedStart(long expectedStart) {
        this.expectedStart = expectedStart;
    }

    public long getExpectedStart() {
        return this.expectedStart;
    }

    public void setExpectedEnd(long expectedEnd) {
        this.expectedEnd = expectedEnd;
    }

    public long getExpectedEnd() {
        return this.expectedEnd;
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\tlastUpdate: " + this.lastUpdate + "\n" + "\texpectedStart: " + this.expectedStart + "\n" + "\texpectedEnd:" + this.expectedEnd + "\n");
        sb.append("\t").append("schedPredecessors: ");
        for (AllocatableAction allocatableAction : this.getPredecessors()) {
            sb.append(" ").append(allocatableAction);
        }
        sb.append("\n");
        sb.append("\t").append("schedSuccessors: ");
        for (AllocatableAction allocatableAction : this.getSuccessors()) {
            sb.append(" ").append(allocatableAction);
        }
        sb.append("\n");
        sb.append("\tOptimization Successors").append(this.optimizingSuccessors);
        return sb.toString();
    }

    public boolean tryToLock() {
        try {
            return this.l.tryLock(1L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    public void lock() {
        this.l.lock();
    }

    public void unlock() {
        this.l.unlock();
    }

    public void unlockCompletely() {
        while (this.l.getHoldCount() > 1) {
            this.l.unlock();
        }
    }

    public void scheduled() {
        this.scheduled = true;
    }

    public void unscheduled() {
        this.scheduled = false;
        this.resourcePredecessors.clear();
        this.resourceSuccessors.clear();
    }

    boolean isScheduled() {
        return this.scheduled;
    }

    public void setOnOptimization(boolean b) {
        this.onOptimization = b;
    }

    public boolean isOnOptimization() {
        return this.onOptimization;
    }

    public void setToReschedule(boolean b) {
        this.toReschedule = b;
    }

    public boolean isToReschedule() {
        return this.toReschedule;
    }

    public void optimizingSuccessor(AllocatableAction<P, T, I> action) {
        this.optimizingSuccessors.add(action);
    }

    public LinkedList<AllocatableAction<P, T, I>> getOptimizingSuccessors() {
        return this.optimizingSuccessors;
    }

    public void clearOptimizingSuccessors() {
        this.optimizingSuccessors.clear();
    }

    public void addGap() {
        ++this.openGaps;
    }

    public void removeGap() {
        --this.openGaps;
    }

    public void clearGaps() {
        this.openGaps = 0;
    }

    public boolean hasGaps() {
        return this.openGaps > 0;
    }

    public int getLockCount() {
        return this.l.getHoldCount();
    }

    public int getGapCount() {
        return this.openGaps;
    }
}

