/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.scheduler.types;

import integratedtoolkit.scheduler.fullGraphScheduler.FullGraphSchedulingInformation;
import integratedtoolkit.scheduler.types.AllocatableAction;
import integratedtoolkit.scheduler.types.Profile;
import integratedtoolkit.scheduler.types.Score;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.WorkerResourceDescription;
import java.util.LinkedList;

public class FullGraphScore<P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>>
extends Score {
    private final double expectedDataAvailable;
    private double expectedStart;

    public FullGraphScore(double actionScore, double dataAvailability, double waiting, double res, double impl) {
        super(actionScore, res, waiting, impl);
        this.expectedDataAvailable = dataAvailability;
        this.expectedStart = Math.max(this.resourceScore, this.expectedDataAvailable);
    }

    public FullGraphScore(FullGraphScore<P, T, I> actionScore, double transferTime, double waiting, double resourceTime, double impl) {
        super(actionScore.getActionScore(), resourceTime, waiting, impl);
        this.expectedDataAvailable = actionScore.expectedDataAvailable + transferTime;
        this.expectedStart = Math.max(this.resourceScore, this.expectedDataAvailable);
    }

    public boolean isBetter(Score other) {
        FullGraphScore otherDS = (FullGraphScore)other;
        if (this.actionScore != other.actionScore) {
            return this.actionScore > other.actionScore;
        }
        double ownEnd = this.expectedStart + this.implementationScore;
        double otherEnd = otherDS.expectedStart + other.implementationScore;
        return ownEnd < otherEnd;
    }

    public static <P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>> long getActionScore(AllocatableAction<P, T, I> action) {
        return action.getPriority();
    }

    public long getDataPredecessorTime(LinkedList<AllocatableAction<P, T, I>> predecessors) {
        long dataTime = 0L;
        for (AllocatableAction allocatableAction : predecessors) {
            dataTime = Math.max(dataTime, ((FullGraphSchedulingInformation)allocatableAction.getSchedulingInfo()).getExpectedEnd());
        }
        return dataTime;
    }

    public double getExpectedDataAvailable() {
        return this.expectedDataAvailable;
    }

    public double getExpectedStart() {
        return this.expectedStart;
    }

    public String toString() {
        return "[FGScore = [action: " + this.actionScore + ", availableData: " + this.expectedDataAvailable + ", resource: " + this.resourceScore + ", expectedStart: " + this.expectedStart + ", implementation:" + this.implementationScore + "]";
    }
}

