/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.scheduler.types;

import integratedtoolkit.scheduler.types.AllocatableAction;
import integratedtoolkit.scheduler.types.Profile;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.ResourceDescription;
import integratedtoolkit.types.resources.WorkerResourceDescription;

public class Gap<P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>> {
    private final long initialTime;
    private long endTime;
    private final AllocatableAction<P, T, I> origin;
    private final ResourceDescription resources;
    private final int capacity;

    public Gap(long start, AllocatableAction<P, T, I> origin, ResourceDescription resources, int capacity) {
        this.initialTime = start;
        this.origin = origin;
        this.resources = resources.copy();
        this.capacity = capacity;
    }

    public Gap(long start, long endTime, AllocatableAction<P, T, I> origin, ResourceDescription resources, int capacity) {
        this.initialTime = start;
        this.endTime = endTime;
        this.origin = origin;
        this.resources = resources.copy();
        this.capacity = capacity;
    }

    public long getInitialTime() {
        return this.initialTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public AllocatableAction<P, T, I> getOrigin() {
        return this.origin;
    }

    public ResourceDescription getResources() {
        return this.resources;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public String toString() {
        return "<" + this.initialTime + "->" + this.endTime + ", " + this.origin + ", " + this.resources + ", amb " + this.capacity + " slots >";
    }
}

