/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.scheduler.types;

import integratedtoolkit.scheduler.fullGraphScheduler.FullGraphSchedulingInformation;
import integratedtoolkit.scheduler.types.AllocatableAction;
import integratedtoolkit.scheduler.types.Profile;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.WorkerResourceDescription;
import java.util.Comparator;
import java.util.PriorityQueue;

public class PriorityActionSet<P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>> {
    private PriorityQueue<AllocatableAction<P, T, I>> noCoreActions;
    private PriorityQueue<AllocatableAction<P, T, I>>[] coreActions;
    private PriorityQueue<AllocatableAction<P, T, I>> priority;
    public final Comparator<AllocatableAction<P, T, I>> comparator;

    public PriorityActionSet(Comparator<AllocatableAction<P, T, I>> comparator) {
        this.comparator = comparator;
        this.noCoreActions = new PriorityQueue<AllocatableAction<P, AllocatableAction<P, T, I>, I>>(1, comparator);
        this.priority = new PriorityQueue<AllocatableAction<P, AllocatableAction<P, T, I>, I>>(1, comparator);
        this.coreActions = new PriorityQueue[0];
    }

    public PriorityActionSet(PriorityActionSet<P, T, I> clone) {
        this.comparator = clone.comparator;
        this.noCoreActions = new PriorityQueue<AllocatableAction<P, T, I>>(clone.noCoreActions);
        this.coreActions = new PriorityQueue[clone.coreActions.length];
        for (int idx = 0; idx < this.coreActions.length; ++idx) {
            this.coreActions[idx] = new PriorityQueue<AllocatableAction<P, T, I>>(clone.coreActions[idx]);
        }
        this.priority = new PriorityQueue<AllocatableAction<P, T, I>>(clone.priority);
    }

    public void offer(AllocatableAction<P, T, I> action) {
        if (((FullGraphSchedulingInformation)action.getSchedulingInfo()).isToReschedule()) {
            Integer coreId = action.getCoreId();
            AllocatableAction<P, T, I> currentPeek = null;
            if (coreId == null) {
                currentPeek = this.noCoreActions.peek();
                this.noCoreActions.offer(action);
            } else {
                if (coreId < this.coreActions.length) {
                    currentPeek = this.coreActions[coreId].peek();
                } else {
                    int originalSize = this.coreActions.length;
                    PriorityQueue[] coreActions = new PriorityQueue[coreId + 1];
                    System.arraycopy(this.coreActions, 0, coreActions, 0, originalSize);
                    for (int coreIdx = originalSize; coreIdx < coreId + 1; ++coreIdx) {
                        coreActions[coreIdx] = new PriorityQueue<AllocatableAction<P, T, I>>(1, this.comparator);
                    }
                    this.coreActions = coreActions;
                }
                this.coreActions[coreId].offer(action);
            }
            if (currentPeek != action) {
                this.rebuildPriorityQueue();
            }
        }
    }

    public AllocatableAction<P, T, I> poll() {
        AllocatableAction<P, T, I> currentPeek;
        while ((currentPeek = this.priority.poll()) != null) {
            FullGraphSchedulingInformation dsi;
            AllocatableAction<P, T, I> nextPeek;
            Integer coreId = currentPeek.getCoreId();
            if (coreId == null) {
                this.noCoreActions.poll();
                nextPeek = this.noCoreActions.peek();
            } else {
                this.coreActions[coreId].poll();
                nextPeek = this.coreActions[coreId].peek();
            }
            if (nextPeek != null) {
                this.priority.offer(nextPeek);
            }
            if (!(dsi = (FullGraphSchedulingInformation)currentPeek.getSchedulingInfo()).isToReschedule()) continue;
            break;
        }
        return currentPeek;
    }

    public void removeFirst(Integer coreId) {
        if (coreId == null) {
            this.noCoreActions.poll();
        } else {
            this.coreActions[coreId].poll();
        }
        this.rebuildPriorityQueue();
    }

    public AllocatableAction<P, T, I> peek() {
        AllocatableAction<P, T, I> currentPeek = this.priority.peek();
        while (currentPeek != null && !((FullGraphSchedulingInformation)currentPeek.getSchedulingInfo()).isToReschedule()) {
            this.removeFirst(currentPeek.getCoreId());
            currentPeek = this.priority.peek();
        }
        return currentPeek;
    }

    public PriorityQueue<AllocatableAction<P, T, I>> peekAll() {
        PriorityQueue<AllocatableAction<P, T, I>> peeks = new PriorityQueue<AllocatableAction<P, T, I>>(this.coreActions.length + 1, this.comparator);
        AllocatableAction<P, T, I> currentCore = this.noCoreActions.peek();
        if (currentCore != null && !((FullGraphSchedulingInformation)currentCore.getSchedulingInfo()).isToReschedule()) {
            this.noCoreActions.poll();
            currentCore = this.noCoreActions.peek();
        }
        if (currentCore != null) {
            peeks.offer(currentCore);
        }
        for (PriorityQueue<AllocatableAction<P, T, I>> core : this.coreActions) {
            currentCore = core.peek();
            if (currentCore != null && !((FullGraphSchedulingInformation)currentCore.getSchedulingInfo()).isToReschedule()) {
                core.poll();
                currentCore = core.peek();
            }
            if (currentCore == null) continue;
            peeks.offer(currentCore);
        }
        return peeks;
    }

    private void rebuildPriorityQueue() {
        this.priority.clear();
        AllocatableAction<P, T, I> action = this.noCoreActions.peek();
        if (action != null) {
            this.priority.offer(action);
        }
        for (PriorityQueue<AllocatableAction<P, T, I>> coreAction : this.coreActions) {
            action = coreAction.peek();
            if (action == null) continue;
            this.priority.offer(action);
        }
    }

    public int size() {
        int size = 0;
        size += this.noCoreActions.size();
        for (PriorityQueue<AllocatableAction<P, T, I>> pq : this.coreActions) {
            size += pq.size();
        }
        return size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void remove(AllocatableAction<P, T, I> action) {
        if (action.getCoreId() == null) {
            this.noCoreActions.remove(action);
        } else {
            this.coreActions[action.getCoreId()].remove(action);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("noCore -> ").append(this.noCoreActions).append("\n");
        for (int i = 0; i < this.coreActions.length; ++i) {
            sb.append("Core ").append(i).append(" -> ").append(this.coreActions[i]).append("\n");
        }
        return sb.toString();
    }
}

