/*
 * Decompiled with CFR 0.152.
 */
package benchmarks;

import benchmarks.AdaptorTestResult;
import benchmarks.AdaptorTestResultEntry;
import java.io.IOException;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.io.RandomAccessFile;

public class RandomAccessFileAdaptorTest {
    public static void main(String[] args) {
        RandomAccessFileAdaptorTest a = new RandomAccessFileAdaptorTest();
        a.test(args[0], args[1]).print();
        GAT.end();
    }

    public AdaptorTestResult test(String adaptor, String host) {
        AdaptorTestResult adaptorTestResult = new AdaptorTestResult(adaptor, host);
        GATContext gatContext = new GATContext();
        Preferences preferences = new Preferences();
        preferences.put("randomaccessfile.adaptor.name", (Object)adaptor);
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = GAT.createRandomAccessFile((GATContext)gatContext, (Preferences)preferences, (String)("any://" + host + "/JavaGAT-random-accessfile"), (String)"rw");
        }
        catch (GATObjectCreationException e) {
            e.printStackTrace();
            GAT.end();
            System.exit(1);
        }
        adaptorTestResult.put("length             ", this.lengthTest(gatContext, preferences, randomAccessFile, 0L));
        adaptorTestResult.put("write 'lorem ipsum'", this.writeTest(gatContext, preferences, randomAccessFile, "lorem ipsum"));
        adaptorTestResult.put("length after write", this.lengthTest(gatContext, preferences, randomAccessFile, 13L));
        adaptorTestResult.put("seek              ", this.seekTest(gatContext, preferences, randomAccessFile, 0L));
        adaptorTestResult.put("read              ", this.readTest(gatContext, preferences, randomAccessFile, "lorem ipsum"));
        adaptorTestResult.put("write 'lorem ipsum' 2", this.writeTest(gatContext, preferences, randomAccessFile, "lorem ipsum"));
        adaptorTestResult.put("length after write 2", this.lengthTest(gatContext, preferences, randomAccessFile, 26L));
        adaptorTestResult.put("seek 2              ", this.seekTest(gatContext, preferences, randomAccessFile, 0L));
        adaptorTestResult.put("read 2              ", this.readTest(gatContext, preferences, randomAccessFile, "lorem ipsum"));
        adaptorTestResult.put("read 3              ", this.readTest(gatContext, preferences, randomAccessFile, "lorem ipsum"));
        return adaptorTestResult;
    }

    private AdaptorTestResultEntry lengthTest(GATContext gatContext, Preferences preferences, RandomAccessFile randomAccessFile, long correctValue) {
        long length;
        long start = System.currentTimeMillis();
        try {
            length = randomAccessFile.length();
            System.out.println("lenght: " + length);
        }
        catch (IOException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(length == correctValue, stop - start, null);
    }

    private AdaptorTestResultEntry writeTest(GATContext gatContext, Preferences preferences, RandomAccessFile randomAccessFile, String text) {
        long start = System.currentTimeMillis();
        try {
            randomAccessFile.writeUTF(text);
        }
        catch (IOException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(true, stop - start, null);
    }

    private AdaptorTestResultEntry seekTest(GATContext gatContext, Preferences preferences, RandomAccessFile randomAccessFile, long seek) {
        long start = System.currentTimeMillis();
        try {
            randomAccessFile.seek(seek);
        }
        catch (IOException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(true, stop - start, null);
    }

    private AdaptorTestResultEntry readTest(GATContext gatContext, Preferences preferences, RandomAccessFile randomAccessFile, String text) {
        boolean result;
        long start = System.currentTimeMillis();
        try {
            result = randomAccessFile.readUTF().equals(text);
        }
        catch (IOException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(result, stop - start, null);
    }
}

