/*
 * Decompiled with CFR 0.152.
 */
package examples20;

import java.io.IOException;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.io.RandomAccessFile;

public class RandomAccessFileExample {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("\tUsage: bin/run_gat_app examples20.RandomAccessFileExample <source> <target> (where source and target are valid JavaGAT URIs)\n");
            System.exit(1);
        }
        new RandomAccessFileExample().start(args[0], args[1]);
        GAT.end();
    }

    public void start(String source, String target) {
        RandomAccessFile sourceFile = null;
        try {
            sourceFile = GAT.createRandomAccessFile((String)source, (String)"r");
        }
        catch (GATObjectCreationException e) {
            System.err.println("Failed to create random access file '" + source + "': " + (Object)((Object)e));
            return;
        }
        RandomAccessFile targetFile = null;
        try {
            targetFile = GAT.createRandomAccessFile((String)target, (String)"rw");
        }
        catch (GATObjectCreationException e) {
            System.err.println("Failed to create random access file '" + target + "': " + (Object)((Object)e));
            return;
        }
        try {
            targetFile.setLength(sourceFile.length());
        }
        catch (IOException e) {
            System.err.println("Failed to set/get the length: " + e);
            return;
        }
        try {
            int i = 0;
            while ((long)i < sourceFile.length()) {
                targetFile.seek(targetFile.length() - 1L - (long)i);
                sourceFile.seek((long)i);
                targetFile.writeByte((int)sourceFile.readByte());
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println("Failed to seek/read/write: " + e);
            return;
        }
    }
}

