/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.security.SecurityContext;

public class GATContext
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Preferences preferences = new Preferences();
    private Vector<SecurityContext> securityContexts = new Vector();

    public void addSecurityContext(SecurityContext securityContext) {
        this.securityContexts.add(securityContext);
    }

    public void removeSecurityContext(SecurityContext securityContext) {
        this.securityContexts.remove(securityContext);
    }

    public List<SecurityContext> getSecurityContexts() {
        return this.securityContexts;
    }

    public List<SecurityContext> getSecurityContextsByType(String type) {
        Vector<SecurityContext> typedSecurityContexts = new Vector<SecurityContext>();
        Enumeration<SecurityContext> enumeration = this.securityContexts.elements();
        while (enumeration.hasMoreElements()) {
            SecurityContext nextSecurityContext = enumeration.nextElement();
            if (!type.equals(nextSecurityContext.getClass().getName())) continue;
            typedSecurityContexts.add(nextSecurityContext);
        }
        return typedSecurityContexts;
    }

    public void removeSecurityContexts() {
        this.securityContexts = new Vector();
    }

    public void addPreferences(Preferences newPreferences) {
        if (newPreferences != null) {
            this.preferences.putAll(newPreferences);
        }
    }

    public void addPreference(String key, Object value) {
        this.preferences.put(key, value);
    }

    public void removePreferences() {
        this.preferences = new Preferences();
    }

    public Preferences getPreferences() {
        return (Preferences)this.preferences.clone();
    }

    public Object clone() {
        GATContext c = new GATContext();
        c.preferences = (Preferences)this.preferences.clone();
        c.securityContexts = new Vector<SecurityContext>(this.securityContexts);
        return c;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.preferences = (Preferences)stream.readObject();
        this.securityContexts = new Vector();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.preferences);
    }

    public int hashCode() {
        return this.preferences.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof GATContext)) {
            return false;
        }
        GATContext c = (GATContext)o;
        return c.preferences.equals(this.preferences) && c.securityContexts.equals(this.securityContexts);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("{");
        if (this.preferences != null) {
            b.append(this.preferences.toString());
            b.append(", ");
        }
        boolean first = true;
        for (SecurityContext c : this.securityContexts) {
            if (!first) {
                b.append(", ");
            }
            b.append(c.toString());
            first = false;
        }
        b.append("}");
        return b.toString();
    }
}

