/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.connectors;

import es.bsc.compss.connectors.Connector;
import es.bsc.compss.connectors.ConnectorException;
import es.bsc.compss.connectors.Cost;
import es.bsc.compss.connectors.VM;
import es.bsc.compss.connectors.utils.CreationThread;
import es.bsc.compss.connectors.utils.DeletionThread;
import es.bsc.compss.connectors.utils.Operations;
import es.bsc.compss.types.CloudProvider;
import es.bsc.compss.types.ResourceCreationRequest;
import es.bsc.compss.types.resources.CloudMethodWorker;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.resources.description.CloudMethodResourceDescription;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractConnector
implements Connector,
Operations,
Cost {
    public static final String PROP_ESTIMATED_CREATION_TIME = "estimated-creation-time";
    public static final String PROP_MAX_VM_CREATION_TIME = "max-vm-creation-time";
    public static final String PROP_SERVER = "Server";
    public static final String PROP_PORT = "Port";
    public static final String PROPERTY_PASSW_NAME = "Password";
    public static final String PROP_APP_NAME = "app-name";
    public static final String ADAPTOR_MAX_PORT_PROPERTY_NAME = "adaptor-max-port";
    public static final String ADAPTOR_MIN_PORT_PROPERTY_NAME = "adaptor-min-port";
    protected static final long MIN_TO_S = 60L;
    protected static final long S_TO_MS = 1000L;
    protected static final long ONE_HOUR = 3600000L;
    protected static final long TWO_MIN = 120000L;
    protected static final long ONE_MIN = 60000L;
    protected static final long HALF_MIN = 30000L;
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Connectors");
    private static final long INITIAL_CREATION_TIME = 60000L;
    private static final long MINIM_DEADLINE_INTERVAL = 10000L;
    private static final long DELETE_SAFETY_INTERVAL = 30000L;
    private static final long MAX_DEADLINE_INTERVAL = 60000L;
    private float currentCostPerHour;
    private final float deletedMachinesCost;
    private long meanCreationTime;
    private int createdVMs;
    private final CloudProvider provider;
    private final ConcurrentHashMap<String, VM> IPToVM;
    private final ConcurrentHashMap<Object, Long> powerOnVMTimestamp;
    private boolean terminate = false;
    private boolean check = false;
    private final DeadlineThread dead;
    private final TreeSet<VM> vmsToDelete;
    private final LinkedList<VM> vmsAlive;

    public AbstractConnector(CloudProvider provider, Map<String, String> props) {
        String maxCreationTimeStr;
        this.provider = provider;
        this.IPToVM = new ConcurrentHashMap();
        this.powerOnVMTimestamp = new ConcurrentHashMap();
        this.vmsToDelete = new TreeSet();
        this.vmsAlive = new LinkedList();
        String estCreationTimeStr = props.get(PROP_ESTIMATED_CREATION_TIME);
        this.meanCreationTime = estCreationTimeStr != null ? (long)Integer.parseInt(estCreationTimeStr) * 1000L : ((maxCreationTimeStr = props.get(PROP_MAX_VM_CREATION_TIME)) != null ? (long)Integer.parseInt(maxCreationTimeStr) * 1000L : 60000L);
        LOGGER.debug("[Abstract Connector] Initial mean creation time is" + this.meanCreationTime);
        this.createdVMs = 0;
        this.currentCostPerHour = 0.0f;
        this.deletedMachinesCost = 0.0f;
        this.terminate = false;
        this.check = false;
        this.dead = new DeadlineThread();
        this.dead.start();
        Runtime.getRuntime().addShutdownHook(new Ender(this));
    }

    @Override
    public boolean turnON(String name, ResourceCreationRequest rR) {
        if (this.terminate) {
            return false;
        }
        LOGGER.info("[Abstract Connector]Requesting a resource creation " + name + " : " + rR.getRequested().toString());
        VM vmInfo = this.tryToReuseVM(rR.getRequested());
        if (vmInfo != null) {
            LOGGER.info("[Abstract Connector] Reusing VM: " + vmInfo);
            CreationThread ct = new CreationThread(this, vmInfo.getName(), rR.getProvider(), rR, vmInfo);
            ct.start();
            return true;
        }
        try {
            CreationThread ct = new CreationThread(this, name, rR.getProvider(), rR, null);
            ct.start();
        }
        catch (Exception e) {
            LOGGER.info("[Abstract Connector] ResourceRequest failed", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized VM tryToReuseVM(CloudMethodResourceDescription requested) {
        String imageReq = requested.getImage().getImageName();
        VM reusedVM = null;
        TreeSet<VM> treeSet = this.vmsToDelete;
        synchronized (treeSet) {
            for (VM vm : this.vmsToDelete) {
                if (!vm.getDescription().getImage().getImageName().equals(imageReq) || !vm.getDescription().contains(requested)) continue;
                reusedVM = vm;
                reusedVM.setToDelete(false);
                this.vmsToDelete.remove(reusedVM);
                break;
            }
        }
        return reusedVM;
    }

    @Override
    public void stopReached() {
        this.check = true;
    }

    @Override
    public Long getNextCreationTime() throws ConnectorException {
        return this.meanCreationTime;
    }

    @Override
    public void terminate(CloudMethodWorker worker, CloudMethodResourceDescription reduction) {
        new DeletionThread(this, worker, reduction).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateAll() {
        this.terminate = true;
        this.dead.terminate();
        Serializable serializable = this.IPToVM;
        synchronized (serializable) {
            for (VM vm : this.IPToVM.values()) {
                LOGGER.info("[Abstract Connector] Retrieving data from VM " + vm.getName());
                vm.getWorker().retrieveData(false);
                LOGGER.info("[Abstract Connector] Destroying VM " + vm.getName());
                Semaphore sem = new Semaphore(0);
                ShutdownListener sl = new ShutdownListener(sem);
                vm.getWorker().stop(sl);
                sl.enable();
                try {
                    sem.acquire();
                }
                catch (Exception e) {
                    LOGGER.error("ERROR: Exception raised on worker shutdown");
                }
                try {
                    this.destroy(vm.getEnvId());
                }
                catch (Exception e) {
                    LOGGER.error("ERROR: Exception while trying to destroy the virtual machine " + vm.getName(), (Throwable)e);
                }
            }
        }
        serializable = this.IPToVM;
        synchronized (serializable) {
            this.IPToVM.clear();
        }
        serializable = this.vmsToDelete;
        synchronized (serializable) {
            this.vmsToDelete.clear();
        }
        serializable = this.vmsAlive;
        synchronized (serializable) {
            this.vmsAlive.clear();
        }
        this.close();
    }

    protected abstract void close();

    @Override
    public Object poweron(String name, CloudMethodResourceDescription rd) throws ConnectorException {
        long requestTime = System.currentTimeMillis();
        Object vmId = this.create(name, rd);
        this.powerOnVMTimestamp.put(vmId, new Long(requestTime));
        return vmId;
    }

    public abstract Object create(String var1, CloudMethodResourceDescription var2) throws ConnectorException;

    @Override
    public VM waitCreation(Object envId, CloudMethodResourceDescription requested) throws ConnectorException {
        CloudMethodResourceDescription granted = this.waitUntilCreation(envId, requested);
        VM vm = new VM(envId, granted);
        vm.setRequestTime(this.powerOnVMTimestamp.remove(envId));
        LOGGER.info("[Abstract Connector] Virtual machine created: " + vm);
        float oneHourCost = this.getMachineCostPerHour(granted).floatValue();
        this.currentCostPerHour += oneHourCost;
        this.addMachine(vm);
        return vm;
    }

    public abstract CloudMethodResourceDescription waitUntilCreation(Object var1, CloudMethodResourceDescription var2) throws ConnectorException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void vmReady(VM vmInfo) throws ConnectorException {
        AbstractConnector abstractConnector = this;
        synchronized (abstractConnector) {
            vmInfo.setStartTime(System.currentTimeMillis());
            vmInfo.computeCreationTime();
            long totaltime = this.meanCreationTime * (long)this.createdVMs;
            ++this.createdVMs;
            this.meanCreationTime = (totaltime += vmInfo.getCreationTime()) / (long)this.createdVMs;
            LOGGER.debug("[Abstract Connector] New mean creation time :" + this.meanCreationTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VM pause(CloudMethodWorker worker) {
        String ip = worker.getName();
        ConcurrentHashMap<String, VM> concurrentHashMap = this.IPToVM;
        synchronized (concurrentHashMap) {
            VM vmInfo = this.IPToVM.get(ip);
            if (vmInfo != null && this.canBeSaved(vmInfo)) {
                LOGGER.info("[Abstract Connector] Virtual machine saved: " + vmInfo);
                vmInfo.setToDelete(true);
                TreeSet<VM> treeSet = this.vmsToDelete;
                synchronized (treeSet) {
                    this.vmsToDelete.add(vmInfo);
                }
                return null;
            }
            return vmInfo;
        }
    }

    @Override
    public void poweroff(VM vm) throws ConnectorException {
        this.destroy(vm.getEnvId());
        this.removeMachine(vm);
    }

    private long getNumSlots(long time1, long time2) {
        long dif = time1 - time2;
        long slotTime = this.getTimeSlot();
        if (slotTime <= 0L) {
            return time1 - time2;
        }
        long numSlots = dif / slotTime;
        if (dif % slotTime > 0L) {
            ++numSlots;
        }
        return numSlots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addMachine(VM vmInfo) {
        String ip = vmInfo.getName();
        Serializable serializable = this.IPToVM;
        synchronized (serializable) {
            this.IPToVM.put(ip, vmInfo);
        }
        serializable = this.vmsAlive;
        synchronized (serializable) {
            this.vmsAlive.add(vmInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void removeMachine(VM vmInfo) {
        Serializable serializable = this.IPToVM;
        synchronized (serializable) {
            this.IPToVM.remove(vmInfo.getName());
        }
        serializable = this.vmsAlive;
        synchronized (serializable) {
            this.vmsAlive.remove(vmInfo);
        }
        LOGGER.debug("[Abstract Connector] VM removed in the connector");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Float getTotalCost() {
        float aliveMachinesCost = 0.0f;
        LinkedList<VM> linkedList = this.vmsAlive;
        synchronized (linkedList) {
            long now = System.currentTimeMillis();
            for (VM vm : this.vmsAlive) {
                long numSlots = this.getNumSlots(now, vm.getStartTime());
                float pricePerSlot = this.getMachineCostPerTimeSlot(vm.getDescription());
                aliveMachinesCost += (float)numSlots * pricePerSlot;
            }
        }
        float totalCost = aliveMachinesCost + this.deletedMachinesCost;
        return Float.valueOf(totalCost);
    }

    public abstract float getMachineCostPerTimeSlot(CloudMethodResourceDescription var1);

    @Override
    public abstract long getTimeSlot();

    @Override
    public Float currentCostPerHour() {
        return Float.valueOf(this.currentCostPerHour);
    }

    @Override
    public Float getMachineCostPerHour(CloudMethodResourceDescription rc) {
        if (this.getTimeSlot() > 0L) {
            return Float.valueOf(this.getMachineCostPerTimeSlot(rc) * 3600000.0f / (float)this.getTimeSlot());
        }
        return Float.valueOf(this.getMachineCostPerTimeSlot(rc));
    }

    @Override
    public boolean getTerminate() {
        return this.terminate;
    }

    @Override
    public boolean getCheck() {
        return this.check;
    }

    private boolean canBeSaved(VM vmInfo) {
        long now = System.currentTimeMillis();
        long vmStart = vmInfo.getStartTime();
        long limit = this.getTimeSlot();
        if (limit <= 0L) {
            return false;
        }
        long dif = now - vmStart;
        long mod = dif % limit;
        return mod < limit - 30000L;
    }

    private class Ender
    extends Thread {
        private final AbstractConnector ac;

        public Ender(AbstractConnector ac) {
            this.ac = ac;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (VM vm : AbstractConnector.this.IPToVM.values()) {
                try {
                    LOGGER.info("[Abstract Connector] Destroying VM " + vm.getName());
                    this.ac.destroy(vm.getEnvId());
                }
                catch (ConnectorException e) {
                    LOGGER.info("[Abstract Connector] Error while trying to  the virtual machine " + vm.getName());
                }
                finally {
                    this.ac.close();
                }
            }
        }
    }

    private class DeadlineThread
    extends Thread {
        private boolean keepGoing = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setName("[Abstract Connector] Connector " + AbstractConnector.this.provider.getName() + " deadline");
            long sleepTime = 1000L;
            while (this.keepGoing) {
                try {
                    LOGGER.debug("[Abstract Connector] Deadline thread sleeps " + sleepTime + " ms.");
                    Thread.sleep(sleepTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LinkedList linkedList = AbstractConnector.this.vmsAlive;
                synchronized (linkedList) {
                    if (AbstractConnector.this.vmsAlive.isEmpty()) {
                        sleepTime = this.getSleepTime();
                        LOGGER.debug("[Abstract Connector] No VMs alive deadline sleep set to " + sleepTime + " ms.");
                        continue;
                    }
                    sleepTime = this.getSleepTime();
                    LOGGER.debug("[Abstract Connector] VMs alive initial sleep set to " + sleepTime + " ms.");
                    try {
                        for (VM vmInfo : AbstractConnector.this.vmsAlive) {
                            long timeLeft = this.timeLeft(vmInfo.getStartTime());
                            if (timeLeft <= 30000L) {
                                if (!vmInfo.isToDelete()) continue;
                                LOGGER.info("[Abstract Connector] Deleting vm " + vmInfo.getName() + " because is marked to delete and it is on the safety delete interval");
                                AbstractConnector.this.vmsAlive.pollFirst();
                                TreeSet treeSet = AbstractConnector.this.vmsToDelete;
                                synchronized (treeSet) {
                                    AbstractConnector.this.vmsToDelete.remove(vmInfo);
                                }
                                DeletionThread dt = new DeletionThread(AbstractConnector.this, vmInfo);
                                dt.start();
                                continue;
                            }
                            if (sleepTime <= timeLeft - 30000L) continue;
                            sleepTime = timeLeft - 30000L;
                            LOGGER.debug("[Abstract Connector] Evaluating sleep time for " + vmInfo.getName() + " because an interval near to finish " + sleepTime + " ms.");
                        }
                    }
                    catch (ConcurrentModificationException e) {
                        LOGGER.debug("[Abstract Connector] Concurrent modification in deadline thread. Ignoring", (Throwable)e);
                        sleepTime = 1000L;
                    }
                }
            }
        }

        private long getSleepTime() {
            long time = AbstractConnector.this.getTimeSlot();
            if (time <= 0L) {
                return 10000L;
            }
            if ((time -= 30000L) > 60000L) {
                return 60000L;
            }
            return time;
        }

        public void terminate() {
            this.keepGoing = false;
            this.interrupt();
        }

        private long timeLeft(long time) {
            long now = System.currentTimeMillis();
            long limit = AbstractConnector.this.getTimeSlot();
            if (limit <= 0L) {
                return 0L;
            }
            long result = limit - (now - time) % limit;
            LOGGER.debug("Calculating sleep time at " + time + " now is " + now + ": remaining --> " + limit + " - " + (now - time) + " % " + limit + " = " + result + " ms to deadline");
            return result;
        }
    }
}

