/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.aws.ec2.functions.SpotInstanceRequestToAWSRunningInstance;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.ec2.compute.strategy.EC2ListNodesStrategy;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.location.Region;

@Singleton
public class AWSEC2ListNodesStrategy
extends EC2ListNodesStrategy {
    protected final AWSEC2Api client;
    protected final SpotInstanceRequestToAWSRunningInstance spotConverter;

    @Inject
    protected AWSEC2ListNodesStrategy(AWSEC2Api client, @Region Supplier<Set<String>> regions, Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, SpotInstanceRequestToAWSRunningInstance spotConverter) {
        super(client, regions, runningInstanceToNodeMetadata, userExecutor);
        this.client = Preconditions.checkNotNull(client, "client");
        this.spotConverter = Preconditions.checkNotNull(spotConverter, "spotConverter");
    }

    @Override
    protected Iterable<? extends RunningInstance> pollRunningInstances() {
        Iterable<AWSRunningInstance> spots = Iterables.filter(Iterables.transform(Iterables.concat(Iterables.transform((Iterable)this.regions.get(), this.allSpotInstancesInRegion())), this.spotConverter), Predicates.notNull());
        return Iterables.concat(super.pollRunningInstances(), spots);
    }

    @Override
    protected Iterable<? extends RunningInstance> pollRunningInstancesByRegionsAndIds(Multimap<String, String> idsByRegions) {
        Iterable<AWSRunningInstance> spots = Iterables.filter(Iterables.transform(Iterables.concat(Iterables.transform(idsByRegions.keySet(), this.spotInstancesByIdInRegion(idsByRegions))), this.spotConverter), Predicates.notNull());
        Iterable<? extends RunningInstance> superInsts = super.pollRunningInstancesByRegionsAndIds(idsByRegions);
        return Iterables.concat(superInsts, spots);
    }

    protected Function<String, Set<SpotInstanceRequest>> allSpotInstancesInRegion() {
        return new Function<String, Set<SpotInstanceRequest>>(){

            @Override
            public Set<SpotInstanceRequest> apply(String from) {
                return AWSEC2ListNodesStrategy.this.client.getSpotInstanceApi().get().describeSpotInstanceRequestsInRegion(from, new String[0]);
            }
        };
    }

    protected Function<String, Set<SpotInstanceRequest>> spotInstancesByIdInRegion(final Multimap<String, String> idsByRegions) {
        return new Function<String, Set<SpotInstanceRequest>>(){

            @Override
            public Set<SpotInstanceRequest> apply(String from) {
                return AWSEC2ListNodesStrategy.this.client.getSpotInstanceApi().get().describeSpotInstanceRequestsInRegion(from, Iterables.toArray(idsByRegions.get(from), String.class));
            }
        };
    }
}

