/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.aws.ec2.domain.LaunchSpecification;
import org.jclouds.ec2.domain.BlockDeviceMapping;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.rest.annotations.SinceApiVersion;

public class AWSRunInstancesOptions
extends RunInstancesOptions {
    private LaunchSpecification.Builder launchSpecificationBuilder = LaunchSpecification.builder();
    public static final AWSRunInstancesOptions NONE = new AWSRunInstancesOptions();

    public AWSRunInstancesOptions inPlacementGroup(String placementGroup) {
        this.formParameters.put("Placement.GroupName", Preconditions.checkNotNull(placementGroup, "placementGroup"));
        return this;
    }

    public AWSRunInstancesOptions enableMonitoring() {
        this.formParameters.put("Monitoring.Enabled", "true");
        this.launchSpecificationBuilder.monitoringEnabled(true);
        return this;
    }

    public AWSRunInstancesOptions withSubnetId(String subnetId) {
        this.formParameters.put("SubnetId", Preconditions.checkNotNull(subnetId, "subnetId"));
        return this;
    }

    public AWSRunInstancesOptions withSecurityGroupId(String securityGroup) {
        return this.withSecurityGroupIds(securityGroup);
    }

    public AWSRunInstancesOptions withSecurityGroupIds(Iterable<String> securityGroupIds) {
        this.launchSpecificationBuilder.securityGroupIds(securityGroupIds);
        this.indexFormValuesWithPrefix("SecurityGroupId", securityGroupIds);
        return this;
    }

    public AWSRunInstancesOptions withSecurityGroupIds(String ... securityGroupIds) {
        return this.withSecurityGroupIds(ImmutableSet.copyOf(securityGroupIds));
    }

    @SinceApiVersion(value="2012-06-01")
    public AWSRunInstancesOptions withIAMInstanceProfileArn(String arn) {
        this.formParameters.put("IamInstanceProfile.Arn", Preconditions.checkNotNull(arn, "arn"));
        return this;
    }

    @SinceApiVersion(value="2012-06-01")
    public AWSRunInstancesOptions withIAMInstanceProfileName(String name) {
        this.formParameters.put("IamInstanceProfile.Name", Preconditions.checkNotNull(name, "name"));
        return this;
    }

    public AWSRunInstancesOptions withPrivateIpAddress(String address) {
        this.formParameters.put("PrivateIpAddress", Preconditions.checkNotNull(address, "address"));
        return this;
    }

    @Override
    public AWSRunInstancesOptions withBlockDeviceMappings(Set<? extends BlockDeviceMapping> mappings) {
        this.launchSpecificationBuilder.blockDeviceMappings(mappings);
        return (AWSRunInstancesOptions)AWSRunInstancesOptions.class.cast(super.withBlockDeviceMappings(mappings));
    }

    @Override
    public AWSRunInstancesOptions withKernelId(String kernelId) {
        this.launchSpecificationBuilder.kernelId(kernelId);
        return (AWSRunInstancesOptions)AWSRunInstancesOptions.class.cast(super.withKernelId(kernelId));
    }

    @Override
    public AWSRunInstancesOptions withKeyName(String keyName) {
        this.launchSpecificationBuilder.keyName(keyName);
        return (AWSRunInstancesOptions)AWSRunInstancesOptions.class.cast(super.withKeyName(keyName));
    }

    @Override
    public AWSRunInstancesOptions withRamdisk(String ramDiskId) {
        this.launchSpecificationBuilder.ramdiskId(ramDiskId);
        return (AWSRunInstancesOptions)AWSRunInstancesOptions.class.cast(super.withRamdisk(ramDiskId));
    }

    @Override
    public AWSRunInstancesOptions withSecurityGroup(String securityGroup) {
        this.launchSpecificationBuilder.securityGroupName(securityGroup);
        return (AWSRunInstancesOptions)AWSRunInstancesOptions.class.cast(super.withSecurityGroup(securityGroup));
    }

    @Override
    public AWSRunInstancesOptions withSecurityGroups(Iterable<String> securityGroups) {
        this.launchSpecificationBuilder.securityGroupNames(securityGroups);
        return (AWSRunInstancesOptions)AWSRunInstancesOptions.class.cast(super.withSecurityGroups(securityGroups));
    }

    @Override
    public AWSRunInstancesOptions withSecurityGroups(String ... securityGroups) {
        this.launchSpecificationBuilder.securityGroupNames(ImmutableSet.copyOf(securityGroups));
        return (AWSRunInstancesOptions)AWSRunInstancesOptions.class.cast(super.withSecurityGroups(securityGroups));
    }

    @Override
    public AWSRunInstancesOptions withUserData(byte[] unencodedData) {
        this.launchSpecificationBuilder.userData(unencodedData);
        return (AWSRunInstancesOptions)AWSRunInstancesOptions.class.cast(super.withUserData(unencodedData));
    }

    @Override
    public AWSRunInstancesOptions asType(String type) {
        this.launchSpecificationBuilder.instanceType(type);
        return (AWSRunInstancesOptions)AWSRunInstancesOptions.class.cast(super.asType(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized LaunchSpecification.Builder getLaunchSpecificationBuilder() {
        try {
            LaunchSpecification.Builder builder = this.launchSpecificationBuilder.imageId("fake").build().toBuilder().imageId(null);
            return builder;
        }
        finally {
            this.launchSpecificationBuilder.imageId(null);
        }
    }

    public static class Builder
    extends RunInstancesOptions.Builder {
        public static AWSRunInstancesOptions withSecurityGroupId(String securityGroup) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.withSecurityGroupId(securityGroup);
        }

        public static AWSRunInstancesOptions inPlacementGroup(String placementGroup) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.inPlacementGroup(placementGroup);
        }

        public static AWSRunInstancesOptions enableMonitoring() {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.enableMonitoring();
        }

        public static AWSRunInstancesOptions withSubnetId(String subnetId) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.withSubnetId(subnetId);
        }

        public static AWSRunInstancesOptions withIAMInstanceProfileArn(String arn) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.withIAMInstanceProfileArn(arn);
        }

        public static AWSRunInstancesOptions withIAMInstanceProfileName(String id) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.withIAMInstanceProfileName(id);
        }

        public static AWSRunInstancesOptions withKeyName(String keyName) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.withKeyName(keyName);
        }

        public static AWSRunInstancesOptions withSecurityGroup(String securityGroup) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.withSecurityGroup(securityGroup);
        }

        public static AWSRunInstancesOptions withUserData(byte[] unencodedData) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.withUserData(unencodedData);
        }

        public static AWSRunInstancesOptions asType(String instanceType) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.asType(instanceType);
        }

        public static AWSRunInstancesOptions withKernelId(String kernelId) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.withKernelId(kernelId);
        }

        public static AWSRunInstancesOptions withRamdisk(String ramdiskId) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.withRamdisk(ramdiskId);
        }

        public static AWSRunInstancesOptions withBlockDeviceMappings(Set<? extends BlockDeviceMapping> mappings) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.withBlockDeviceMappings((Set)mappings);
        }

        public static AWSRunInstancesOptions withPrivateIpAdress(String address) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.withPrivateIpAddress(address);
        }
    }
}

