/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.ec2.compute.domain.RegionAndName;

@Singleton
public class AddElasticIpsToNodemetadata
implements Function<NodeMetadata, NodeMetadata> {
    private final LoadingCache<RegionAndName, String> cache;

    @Inject
    protected AddElasticIpsToNodemetadata(@Named(value="ELASTICIP") LoadingCache<RegionAndName, String> cache) {
        this.cache = Preconditions.checkNotNull(cache, "cache");
    }

    @Override
    public NodeMetadata apply(NodeMetadata arg0) {
        String[] parts = AWSUtils.parseHandle(arg0.getId());
        String region = parts[0];
        String instanceId = parts[1];
        try {
            String publicIp = this.cache.get(new RegionAndName(region, instanceId));
            return NodeMetadataBuilder.fromNodeMetadata(arg0).publicAddresses(((ImmutableSet.Builder)ImmutableSet.builder().add(publicIp)).build()).build();
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            return arg0;
        }
        catch (ExecutionException e) {
            throw Throwables.propagate(e);
        }
    }
}

