/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.jclouds.aws.ec2.domain.MonitoringState;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.Hypervisor;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.SinceApiVersion;

public class AWSRunningInstance
extends RunningInstance {
    private final MonitoringState monitoringState;
    @Nullable
    private final String placementGroup;
    private final Set<String> productCodes;
    @Nullable
    private final String subnetId;
    @Nullable
    private final String spotInstanceRequestId;
    @Nullable
    private final String vpcId;
    private final Hypervisor hypervisor;
    private final Map<String, String> securityGroupIdToNames;
    private final Optional<IAMInstanceProfile> iamInstanceProfile;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromRunningInstance(this);
    }

    protected AWSRunningInstance(String region, Map<String, String> securityGroupIdToNames, String amiLaunchIndex, String dnsName, String imageId, String instanceId, InstanceState instanceState, String rawState, String instanceType, String ipAddress, String kernelId, String keyName, Date launchTime, String availabilityZone, String virtualizationType, String platform, String privateDnsName, String privateIpAddress, String ramdiskId, String reason, RootDeviceType rootDeviceType, String rootDeviceName, Map<String, BlockDevice> ebsBlockDevices, MonitoringState monitoringState, String placementGroup, Iterable<String> productCodes, String subnetId, String spotInstanceRequestId, String vpcId, Hypervisor hypervisor, Map<String, String> tags, Optional<IAMInstanceProfile> iamInstanceProfile) {
        super(region, securityGroupIdToNames.values(), amiLaunchIndex, dnsName, imageId, instanceId, instanceState, rawState, instanceType, ipAddress, kernelId, keyName, launchTime, availabilityZone, virtualizationType, platform, privateDnsName, privateIpAddress, ramdiskId, reason, rootDeviceType, rootDeviceName, ebsBlockDevices, tags);
        this.monitoringState = Preconditions.checkNotNull(monitoringState, "monitoringState");
        this.placementGroup = placementGroup;
        this.productCodes = ImmutableSet.copyOf(Preconditions.checkNotNull(productCodes, "productCodes"));
        this.subnetId = subnetId;
        this.spotInstanceRequestId = spotInstanceRequestId;
        this.vpcId = vpcId;
        this.hypervisor = Preconditions.checkNotNull(hypervisor, "hypervisor");
        this.securityGroupIdToNames = ImmutableMap.copyOf(Preconditions.checkNotNull(securityGroupIdToNames, "securityGroupIdToNames"));
        this.iamInstanceProfile = Preconditions.checkNotNull(iamInstanceProfile, "iamInstanceProfile of %s", instanceId);
    }

    public Map<String, String> getSecurityGroupIdToNames() {
        return this.securityGroupIdToNames;
    }

    public MonitoringState getMonitoringState() {
        return this.monitoringState;
    }

    public String getPlacementGroup() {
        return this.placementGroup;
    }

    public Set<String> getProductCodes() {
        return this.productCodes;
    }

    public String getSpotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public Hypervisor getHypervisor() {
        return this.hypervisor;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    @SinceApiVersion(value="2012-06-01")
    public Optional<IAMInstanceProfile> getIAMInstanceProfile() {
        return this.iamInstanceProfile;
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("monitoringState", (Object)this.monitoringState).add("placementGroup", this.placementGroup).add("subnetId", this.subnetId).add("spotInstanceRequestId", this.spotInstanceRequestId).add("vpcId", this.vpcId).add("hypervisor", (Object)this.hypervisor).add("iamInstanceProfile", this.iamInstanceProfile.orNull());
    }

    public static class IAMInstanceProfile {
        private final String arn;
        private final String id;

        public static IAMInstanceProfile forArnAndId(String arn, String id) {
            return new IAMInstanceProfile(arn, id);
        }

        private IAMInstanceProfile(String arn, String id) {
            this.arn = Preconditions.checkNotNull(arn, "arn");
            this.id = Preconditions.checkNotNull(id, "id for %s", arn);
        }

        public String getArn() {
            return this.arn;
        }

        public String getId() {
            return this.id;
        }

        public int hashCode() {
            return Objects.hashCode(this.arn, this.id);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            IAMInstanceProfile that = (IAMInstanceProfile)IAMInstanceProfile.class.cast(obj);
            return Objects.equal(this.arn, that.arn) && Objects.equal(this.id, that.id);
        }

        public String toString() {
            return Objects.toStringHelper("").add("arn", this.arn).add("id", this.id).toString();
        }
    }

    public static class Builder
    extends RunningInstance.Builder<Builder> {
        private MonitoringState monitoringState;
        private String placementGroup;
        private Set<String> productCodes = Sets.newLinkedHashSet();
        private String subnetId;
        private String spotInstanceRequestId;
        private String vpcId;
        private Hypervisor hypervisor;
        private Map<String, String> securityGroupIdToNames = Maps.newLinkedHashMap();
        private String iamInstanceProfileArn;
        private String iamInstanceProfileId;

        public Builder securityGroupIdToNames(Map<String, String> securityGroupIdToNames) {
            this.securityGroupIdToNames = ImmutableMap.copyOf(Preconditions.checkNotNull(securityGroupIdToNames, "securityGroupIdToNames"));
            return this;
        }

        public Builder securityGroupIdToName(String key, String value) {
            if (key != null && value != null) {
                this.securityGroupIdToNames.put(key, value);
            }
            return this;
        }

        public Builder monitoringState(MonitoringState monitoringState) {
            this.monitoringState = monitoringState;
            return this;
        }

        public Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public Builder productCodes(Iterable<String> productCodes) {
            this.productCodes = ImmutableSet.copyOf(Preconditions.checkNotNull(productCodes, "productCodes"));
            return this;
        }

        public Builder productCode(String productCode) {
            if (productCode != null) {
                this.productCodes.add(productCode);
            }
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public Builder hypervisor(Hypervisor hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public Builder iamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
            return this;
        }

        public Builder iamInstanceProfileId(String iamInstanceProfileId) {
            this.iamInstanceProfileId = iamInstanceProfileId;
            return this;
        }

        @Override
        public AWSRunningInstance build() {
            Optional<IAMInstanceProfile> iamInstanceProfile = Optional.absent();
            if (this.iamInstanceProfileArn != null && this.iamInstanceProfileId != null) {
                iamInstanceProfile = Optional.of(IAMInstanceProfile.forArnAndId(this.iamInstanceProfileArn, this.iamInstanceProfileId));
            }
            return new AWSRunningInstance(this.region, this.securityGroupIdToNames, this.amiLaunchIndex, this.dnsName, this.imageId, this.instanceId, this.instanceState, this.rawState, this.instanceType, this.ipAddress, this.kernelId, this.keyName, this.launchTime, this.availabilityZone, this.virtualizationType, this.platform, this.privateDnsName, this.privateIpAddress, this.ramdiskId, this.reason, this.rootDeviceType, this.rootDeviceName, this.ebsBlockDevices, this.monitoringState, this.placementGroup, this.productCodes, this.subnetId, this.spotInstanceRequestId, this.vpcId, this.hypervisor, this.tags, iamInstanceProfile);
        }

        @Override
        public Builder fromRunningInstance(RunningInstance in) {
            super.fromRunningInstance(in);
            if (in instanceof AWSRunningInstance) {
                AWSRunningInstance awsIn = (AWSRunningInstance)AWSRunningInstance.class.cast(in);
                this.monitoringState(awsIn.monitoringState).placementGroup(awsIn.placementGroup).productCodes(awsIn.productCodes).subnetId(awsIn.subnetId).spotInstanceRequestId(awsIn.spotInstanceRequestId).vpcId(awsIn.vpcId).hypervisor(awsIn.hypervisor).securityGroupIdToNames(awsIn.securityGroupIdToNames);
                if (awsIn.getIAMInstanceProfile().isPresent()) {
                    this.iamInstanceProfileArn(awsIn.getIAMInstanceProfile().get().getArn());
                    this.iamInstanceProfileId(awsIn.getIAMInstanceProfile().get().getId());
                }
            }
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

