/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.domain;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.jclouds.domain.Credentials;
import org.jclouds.javax.annotation.Nullable;

public class LoginCredentials
extends Credentials {
    private final boolean authenticateSudo;
    private final Optional<String> password;
    private final Optional<String> privateKey;

    private static boolean isPrivateKeyCredential(String credential) {
        return credential != null && (credential.startsWith("-----BEGIN RSA PRIVATE KEY-----") || credential.startsWith("-----BEGIN PRIVATE KEY-----"));
    }

    public static LoginCredentials fromCredentials(Credentials creds) {
        if (creds == null) {
            return null;
        }
        if (creds instanceof LoginCredentials) {
            return (LoginCredentials)LoginCredentials.class.cast(creds);
        }
        return LoginCredentials.builder(creds).build();
    }

    public static Builder builder(Credentials creds) {
        if (creds == null) {
            return LoginCredentials.builder();
        }
        if (creds instanceof LoginCredentials) {
            return ((LoginCredentials)LoginCredentials.class.cast(creds)).toBuilder();
        }
        return LoginCredentials.builder().identity(creds.identity).credential(creds.credential);
    }

    public static Builder builder() {
        return new Builder();
    }

    private LoginCredentials(String username, Optional<String> password, Optional<String> privateKey, boolean authenticateSudo) {
        super(username, privateKey.isPresent() && LoginCredentials.isPrivateKeyCredential(privateKey.get()) ? privateKey.get() : password.orNull());
        this.authenticateSudo = authenticateSudo;
        this.password = Preconditions.checkNotNull(password, "password");
        this.privateKey = Preconditions.checkNotNull(privateKey, "privateKey");
    }

    public String getUser() {
        return this.identity;
    }

    @Nullable
    @Deprecated
    public String getPassword() {
        return this.password.orNull();
    }

    public Optional<String> getOptionalPassword() {
        return this.password;
    }

    @Nullable
    @Deprecated
    public String getPrivateKey() {
        return this.privateKey.orNull();
    }

    public boolean hasUnencryptedPrivateKey() {
        return this.getOptionalPrivateKey().isPresent() && !this.getOptionalPrivateKey().get().isEmpty() && !this.getOptionalPrivateKey().get().contains("Proc-Type: 4,ENCRYPTED");
    }

    public Optional<String> getOptionalPrivateKey() {
        return this.privateKey;
    }

    public boolean shouldAuthenticateSudo() {
        return this.authenticateSudo;
    }

    public Builder toBuilder() {
        Builder builder = new Builder().user(this.identity).authenticateSudo(this.authenticateSudo);
        if (this.password != null) {
            builder = this.password.isPresent() ? builder.password(this.password.get()) : builder.noPassword();
        }
        if (this.privateKey != null) {
            builder = this.privateKey.isPresent() ? builder.privateKey(this.privateKey.get()) : builder.noPrivateKey();
        }
        return builder;
    }

    @Override
    public String toString() {
        return "[user=" + this.getUser() + ", passwordPresent=" + this.password.isPresent() + ", privateKeyPresent=" + this.privateKey.isPresent() + ", shouldAuthenticateSudo=" + this.authenticateSudo + "]";
    }

    public static class Builder
    extends Credentials.Builder<LoginCredentials> {
        private boolean authenticateSudo;
        private Optional<String> password = Optional.absent();
        private Optional<String> privateKey = Optional.absent();

        public Builder identity(String identity) {
            return (Builder)Builder.class.cast(super.identity(identity));
        }

        public Builder user(String user) {
            return this.identity(user);
        }

        public Builder password(String password) {
            this.password = Optional.fromNullable(password);
            return this;
        }

        public Builder noPassword() {
            this.password = Optional.absent();
            return this;
        }

        public Builder privateKey(String privateKey) {
            this.privateKey = Optional.fromNullable(privateKey);
            return this;
        }

        public Builder noPrivateKey() {
            this.privateKey = Optional.absent();
            return this;
        }

        public Builder credential(String credential) {
            if (LoginCredentials.isPrivateKeyCredential(credential)) {
                return this.noPassword().privateKey(credential);
            }
            if (credential != null) {
                return this.password(credential).noPrivateKey();
            }
            return this;
        }

        public Builder authenticateSudo(boolean authenticateSudo) {
            this.authenticateSudo = authenticateSudo;
            return this;
        }

        @Override
        public LoginCredentials build() {
            if (!(this.identity != null || this.password.isPresent() || this.privateKey.isPresent() || this.authenticateSudo)) {
                return null;
            }
            return new LoginCredentials(this.identity, this.password, this.privateKey, this.authenticateSudo);
        }
    }
}

