/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Longs;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.gogrid.domain.IpPortPair;
import org.jclouds.gogrid.domain.LoadBalancerOs;
import org.jclouds.gogrid.domain.LoadBalancerPersistenceType;
import org.jclouds.gogrid.domain.LoadBalancerState;
import org.jclouds.gogrid.domain.LoadBalancerType;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.javax.annotation.Nullable;

public class LoadBalancer
implements Comparable<LoadBalancer> {
    private final long id;
    private final String name;
    private final String description;
    private final IpPortPair virtualIp;
    private final Set<IpPortPair> realIpList;
    private final LoadBalancerType type;
    private final LoadBalancerPersistenceType persistence;
    private final LoadBalancerOs os;
    private final LoadBalancerState state;
    private final Option datacenter;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromLoadBalancer(this);
    }

    @ConstructorProperties(value={"id", "name", "description", "virtualip", "realiplist", "type", "persistence", "os", "state", "datacenter"})
    protected LoadBalancer(long id, String name, @Nullable String description, IpPortPair virtualIp, Set<IpPortPair> realIpList, LoadBalancerType type, LoadBalancerPersistenceType persistence, LoadBalancerOs os, LoadBalancerState state, Option datacenter) {
        this.id = id;
        this.name = Preconditions.checkNotNull(name, "name");
        this.description = description;
        this.virtualIp = Preconditions.checkNotNull(virtualIp, "virtualIp");
        this.realIpList = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(realIpList, "realIpList"));
        this.type = Preconditions.checkNotNull(type, "type");
        this.persistence = Preconditions.checkNotNull(persistence, "persistence");
        this.os = Preconditions.checkNotNull(os, "os");
        this.state = Preconditions.checkNotNull(state, "state");
        this.datacenter = Preconditions.checkNotNull(datacenter, "datacenter");
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public IpPortPair getVirtualIp() {
        return this.virtualIp;
    }

    public Set<IpPortPair> getRealIpList() {
        return this.realIpList;
    }

    public LoadBalancerType getType() {
        return this.type;
    }

    public LoadBalancerPersistenceType getPersistence() {
        return this.persistence;
    }

    public LoadBalancerOs getOs() {
        return this.os;
    }

    public LoadBalancerState getState() {
        return this.state;
    }

    public Option getDatacenter() {
        return this.datacenter;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.name, this.description, this.virtualIp, this.realIpList, this.type, this.persistence, this.os, this.state, this.datacenter});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LoadBalancer that = (LoadBalancer)LoadBalancer.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.name, that.name) && Objects.equal(this.description, that.description) && Objects.equal(this.virtualIp, that.virtualIp) && Objects.equal(this.realIpList, that.realIpList) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.persistence, (Object)that.persistence) && Objects.equal((Object)this.os, (Object)that.os) && Objects.equal((Object)this.state, (Object)that.state) && Objects.equal(this.datacenter, that.datacenter);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("id", this.id).add("name", this.name).add("description", this.description).add("virtualIp", this.virtualIp).add("realIpList", this.realIpList).add("type", (Object)this.type).add("persistence", (Object)this.persistence).add("os", (Object)this.os).add("state", (Object)this.state).add("datacenter", this.datacenter);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(LoadBalancer o) {
        return Longs.compare(this.id, o.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected long id;
        protected String name;
        protected String description;
        protected IpPortPair virtualIp;
        protected Set<IpPortPair> realIpList = ImmutableSet.of();
        protected LoadBalancerType type;
        protected LoadBalancerPersistenceType persistence;
        protected LoadBalancerOs os;
        protected LoadBalancerState state;
        protected Option datacenter;

        protected abstract T self();

        public T id(long id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T virtualIp(IpPortPair virtualIp) {
            this.virtualIp = virtualIp;
            return this.self();
        }

        public T realIpList(Set<IpPortPair> realIpList) {
            this.realIpList = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(realIpList, "realIpList"));
            return this.self();
        }

        public T realIpList(IpPortPair ... in) {
            return this.realIpList(ImmutableSet.copyOf(in));
        }

        public T type(LoadBalancerType type) {
            this.type = type;
            return this.self();
        }

        public T persistence(LoadBalancerPersistenceType persistence) {
            this.persistence = persistence;
            return this.self();
        }

        public T os(LoadBalancerOs os) {
            this.os = os;
            return this.self();
        }

        public T state(LoadBalancerState state) {
            this.state = state;
            return this.self();
        }

        public T datacenter(Option datacenter) {
            this.datacenter = datacenter;
            return this.self();
        }

        public LoadBalancer build() {
            return new LoadBalancer(this.id, this.name, this.description, this.virtualIp, this.realIpList, this.type, this.persistence, this.os, this.state, this.datacenter);
        }

        public T fromLoadBalancer(LoadBalancer in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).description(in.getDescription())).virtualIp(in.getVirtualIp())).realIpList(in.getRealIpList())).type(in.getType())).persistence(in.getPersistence())).os(in.getOs())).state(in.getState())).datacenter(in.getDatacenter());
        }
    }
}

