/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;

public class DatacenterAndId {
    protected final String datacenterId;
    protected final String id;

    public static DatacenterAndId fromSlashEncoded(String id) {
        Iterable<String> parts = Splitter.on('/').split(Preconditions.checkNotNull(id, "id"));
        Preconditions.checkArgument(Iterables.size(parts) == 2, "id must be in format datacenterId/id");
        return new DatacenterAndId(Iterables.get(parts, 0), Iterables.get(parts, 1));
    }

    public static DatacenterAndId fromDatacenterAndId(String datacenterId, String id) {
        return new DatacenterAndId(datacenterId, id);
    }

    private static String slashEncodeDatacenterAndId(String datacenterId, String id) {
        return Preconditions.checkNotNull(datacenterId, "datacenterId") + "/" + Preconditions.checkNotNull(id, "id");
    }

    public String slashEncode() {
        return DatacenterAndId.slashEncodeDatacenterAndId(this.datacenterId, this.id);
    }

    protected DatacenterAndId(String datacenterId, String id) {
        this.datacenterId = Preconditions.checkNotNull(datacenterId, "datacenterId");
        this.id = Preconditions.checkNotNull(id, "id");
    }

    public int hashCode() {
        return Objects.hashCode(this.datacenterId, this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatacenterAndId other = (DatacenterAndId)obj;
        return Objects.equal(this.datacenterId, other.datacenterId) && Objects.equal(this.id, other.id);
    }

    public String getDatacenter() {
        return this.datacenterId;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "[datacenterId=" + this.datacenterId + ", id=" + this.id + "]";
    }
}

