/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.location.Provider;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;
import org.jclouds.location.suppliers.LocationsSupplier;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.location.suppliers.RegionIdsSupplier;
import org.jclouds.location.suppliers.ZoneIdToURISupplier;
import org.jclouds.location.suppliers.ZoneIdsSupplier;
import org.jclouds.location.suppliers.all.RegionToProvider;
import org.jclouds.location.suppliers.all.ZoneToProvider;
import org.jclouds.location.suppliers.derived.RegionIdsFromRegionIdToURIKeySet;
import org.jclouds.location.suppliers.derived.ZoneIdsFromZoneIdToURIKeySet;
import org.jclouds.location.suppliers.implicit.FirstRegion;
import org.jclouds.location.suppliers.implicit.FirstZone;
import org.jclouds.openstack.keystone.v2_0.config.Authentication;
import org.jclouds.openstack.keystone.v2_0.config.CredentialTypes;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.domain.Endpoint;
import org.jclouds.openstack.keystone.v2_0.functions.AuthenticateApiAccessKeyCredentials;
import org.jclouds.openstack.keystone.v2_0.functions.AuthenticatePasswordCredentials;
import org.jclouds.openstack.keystone.v2_0.handlers.RetryOnRenew;
import org.jclouds.openstack.keystone.v2_0.suppliers.LocationIdToURIFromAccessForTypeAndVersion;
import org.jclouds.openstack.keystone.v2_0.suppliers.RegionIdToAdminURIFromAccessForTypeAndVersion;
import org.jclouds.openstack.keystone.v2_0.suppliers.RegionIdToAdminURISupplier;
import org.jclouds.openstack.keystone.v2_0.suppliers.RegionIdToURIFromAccessForTypeAndVersion;
import org.jclouds.openstack.keystone.v2_0.suppliers.ZoneIdToURIFromAccessForTypeAndVersion;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.util.Suppliers2;

public class KeystoneAuthenticationModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(RetryOnRenew.class);
    }

    @Provides
    @Singleton
    @Authentication
    protected Supplier<String> provideAuthenticationTokenCache(final Supplier<Access> supplier) throws InterruptedException, ExecutionException, TimeoutException {
        return new Supplier<String>(){

            @Override
            public String get() {
                return ((Access)supplier.get()).getToken().getId();
            }
        };
    }

    @Provides
    @Singleton
    protected Map<String, Function<Credentials, Access>> authenticationMethods(Injector i) {
        ImmutableSet.Builder fns = ImmutableSet.builder();
        fns.add(i.getInstance(AuthenticatePasswordCredentials.class));
        fns.add(i.getInstance(AuthenticateApiAccessKeyCredentials.class));
        return CredentialTypes.indexByCredentialType(fns.build());
    }

    @Provides
    @Singleton
    protected Function<Credentials, Access> authenticationMethodForCredentialType(@Named(value="jclouds.keystone.credential-type") String credentialType, Map<String, Function<Credentials, Access>> authenticationMethods) {
        Preconditions.checkArgument(authenticationMethods.containsKey(credentialType), "credential type %s not in supported list: %s", credentialType, authenticationMethods.keySet());
        return authenticationMethods.get(credentialType);
    }

    @Provides
    @Singleton
    public LoadingCache<Credentials, Access> provideAccessCache(Function<Credentials, Access> getAccess) {
        return CacheBuilder.newBuilder().expireAfterWrite(11L, TimeUnit.HOURS).build(CacheLoader.from(getAccess));
    }

    @Provides
    @Singleton
    protected Supplier<Access> provideAccessSupplier(final LoadingCache<Credentials, Access> cache, final @Provider Supplier<Credentials> creds) {
        return new Supplier<Access>(){

            @Override
            public Access get() {
                return (Access)cache.getUnchecked(creds.get());
            }
        };
    }

    @Deprecated
    public static class ZoneModule
    extends AbstractModule {
        @Override
        protected void configure() {
            this.install(new FactoryModuleBuilder().implement(ZoneIdToURISupplier.class, ZoneIdToURIFromAccessForTypeAndVersion.class).build(ZoneIdToURISupplier.Factory.class));
            this.bind(ZoneIdsSupplier.class).to(ZoneIdsFromZoneIdToURIKeySet.class);
            this.bind(ImplicitLocationSupplier.class).to(FirstZone.class).in(Scopes.SINGLETON);
            this.bind(LocationsSupplier.class).to(ZoneToProvider.class).in(Scopes.SINGLETON);
        }

        @Provides
        @Singleton
        protected ZoneIdToURISupplier provideZoneIdToURISupplierForApiVersion(@Named(value="jclouds.keystone.service-type") String serviceType, @ApiVersion String apiVersion, ZoneIdToURISupplier.Factory factory) {
            return factory.createForApiTypeAndVersion(serviceType, apiVersion);
        }
    }

    public static class RegionModule
    extends AbstractModule {
        @Override
        protected void configure() {
            this.install(new FactoryModuleBuilder().implement(RegionIdToURISupplier.class, RegionIdToURIFromAccessForTypeAndVersion.class).build(RegionIdToURISupplier.Factory.class));
            this.install(new FactoryModuleBuilder().implement(RegionIdToAdminURISupplier.class, RegionIdToAdminURIFromAccessForTypeAndVersion.class).build(RegionIdToAdminURISupplier.Factory.class));
            this.bind(RegionIdsSupplier.class).to(RegionIdsFromRegionIdToURIKeySet.class);
            this.bind(ImplicitLocationSupplier.class).to(FirstRegion.class).in(Scopes.SINGLETON);
            this.bind(LocationsSupplier.class).to(RegionToProvider.class).in(Scopes.SINGLETON);
        }

        @Provides
        @Singleton
        protected RegionIdToURISupplier provideRegionIdToURISupplierForApiVersion(@Named(value="jclouds.keystone.service-type") String serviceType, @ApiVersion String apiVersion, RegionIdToURISupplier.Factory factory) {
            return factory.createForApiTypeAndVersion(serviceType, apiVersion);
        }

        @Provides
        @Singleton
        protected RegionIdToAdminURISupplier provideRegionIdToAdminURISupplierForApiVersion(@Named(value="jclouds.keystone.service-type") String serviceType, @ApiVersion String apiVersion, RegionIdToAdminURISupplier.Factory factory) {
            return factory.createForApiTypeAndVersion(serviceType, apiVersion);
        }
    }

    public static class ProviderModule
    extends AbstractModule {
        @Override
        protected void configure() {
            this.install(new FactoryModuleBuilder().build(LocationIdToURIFromAccessForTypeAndVersion.Factory.class));
        }

        @Provides
        @Singleton
        protected Supplier<URI> provideZoneIdToURISupplierForApiVersion(@Named(value="jclouds.keystone.service-type") String serviceType, @ApiVersion String apiVersion, LocationIdToURIFromAccessForTypeAndVersion.Factory factory) {
            return Suppliers2.getLastValueInMap(factory.createForApiTypeAndVersion(serviceType, apiVersion));
        }

        @Provides
        @Singleton
        Function<Endpoint, String> provideProvider(final @Provider String provider) {
            return new Function<Endpoint, String>(){

                @Override
                public String apply(Endpoint in) {
                    return provider;
                }
            };
        }
    }
}

