/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.engine;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gridlab.gat.engine.Adaptor;
import org.gridlab.gat.engine.AdaptorOrderPolicy;

public class DefaultAdaptorOrderPolicy
implements AdaptorOrderPolicy {
    @Override
    public void order(Map<String, List<Adaptor>> adaptors) {
        Set<String> adaptorTypes = adaptors.keySet();
        for (String adaptorType : adaptorTypes) {
            if (adaptorType.equalsIgnoreCase("file")) {
                this.orderFileList(adaptors.get(adaptorType));
                continue;
            }
            if (adaptorType.equalsIgnoreCase("fileinputstream")) {
                this.orderFileInputStreamList(adaptors.get(adaptorType));
                continue;
            }
            if (adaptorType.equalsIgnoreCase("fileoutputstream")) {
                this.orderFileOutputStreamList(adaptors.get(adaptorType));
                continue;
            }
            if (adaptorType.equalsIgnoreCase("randomaccessfile") || adaptorType.equalsIgnoreCase("logicalfile") || adaptorType.equalsIgnoreCase("endpoint")) continue;
            if (adaptorType.equalsIgnoreCase("resourcebroker")) {
                this.orderResourceList(adaptors.get(adaptorType));
                continue;
            }
            if (adaptorType.equalsIgnoreCase("advertservice") || adaptorType.equalsIgnoreCase("monitorable")) continue;
            System.err.println("WARNING, unknown GAT type in DefaultAdaptorOrderPolicy");
        }
    }

    private void orderFileList(List<Adaptor> l) {
        int pos = 0;
        pos = this.placeAdaptor(pos, "local", "file", l);
        pos = this.placeAdaptor(pos, "gridftp", "file", l);
        pos = this.placeAdaptor(pos, "sftptrilead", "file", l);
        pos = this.placeAdaptor(pos, "commandlinessh", "file", l);
        pos = this.placeAdaptor(pos, "sshtrilead", "file", l);
        pos = this.placeAdaptor(pos, "ftp", "file", l);
    }

    private void orderFileInputStreamList(List<Adaptor> l) {
        int pos = 0;
        pos = this.placeAdaptor(pos, "local", "fileinputstream", l);
        pos = this.placeAdaptor(pos, "gridftp", "fileinputstream", l);
        pos = this.placeAdaptor(pos, "sftptrilead", "fileinputstream", l);
        pos = this.placeAdaptor(pos, "ftp", "fileinputstream", l);
        pos = this.placeAdaptor(pos, "copying", "fileinputstream", l);
    }

    private void orderFileOutputStreamList(List<Adaptor> l) {
        int pos = 0;
        pos = this.placeAdaptor(pos, "local", "fileoutputstream", l);
        pos = this.placeAdaptor(pos, "gridftp", "fileoutputstream", l);
        pos = this.placeAdaptor(pos, "sftptrilead", "fileoutputstream", l);
        pos = this.placeAdaptor(pos, "ftp", "fileoutputstream", l);
    }

    private void orderResourceList(List<Adaptor> l) {
        int pos = 0;
        pos = this.placeAdaptor(pos, "local", "resourcebroker", l);
        pos = this.placeAdaptor(pos, "globus", "resourcebroker", l);
        pos = this.placeAdaptor(pos, "wsgt4new", "resourcebroker", l);
        pos = this.placeAdaptor(pos, "sshtrilead", "resourcebroker", l);
    }

    private int placeAdaptor(int position, String adaptorName, String cpiName, List<Adaptor> l) {
        int currentPosition = l.indexOf(this.getAdaptor(adaptorName, cpiName, l));
        if (currentPosition < 0) {
            return position;
        }
        l.add(position, l.remove(currentPosition));
        return ++position;
    }

    private Adaptor getAdaptor(String shortName, String cpiName, List<Adaptor> adaptors) {
        for (Adaptor adaptor : adaptors) {
            if (!adaptor.getShortAdaptorClassName().equalsIgnoreCase(shortName + cpiName + "Adaptor")) continue;
            return adaptor;
        }
        return null;
    }
}

