/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.engine;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.gridlab.gat.AdaptorInfo;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.advert.Advertisable;
import org.gridlab.gat.advert.cpi.SerializedBase;
import org.gridlab.gat.engine.Adaptor;
import org.gridlab.gat.engine.AdaptorInvocationHandler;
import org.gridlab.gat.engine.AdaptorOrderPolicy;
import org.gridlab.gat.engine.DefaultAdaptorOrderPolicy;
import org.gridlab.gat.engine.util.FileWaiter;
import org.gridlab.gat.engine.util.ScheduledExecutor;
import org.gridlab.gat.resources.cpi.JobCpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GATEngine {
    protected static Logger logger = LoggerFactory.getLogger(GATEngine.class);
    public static final boolean TIMING = GATEngine.propertySet("gat.timing");
    private static GATEngine gatEngine = null;
    private static Vector<Class<?>> unmarshallers = new Vector();
    private static final ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
    private boolean ended = false;
    private HashMap<String, List<Adaptor>> adaptorLists = new HashMap();
    private ClassLoader parentLoader;
    private boolean unmarshallersAdded;
    private static Class<?>[] unmarshalParams = new Class[]{GATContext.class, String.class};

    protected GATEngine() {
        if (logger.isDebugEnabled()) {
            logger.debug("creating the GAT engine START");
        }
        ClassLoader superparentLoader = this.getParentClassLoader();
        String adaptorPath = System.getProperty("gat.adaptor.path");
        if (logger.isTraceEnabled()) {
            logger.trace("loading adaptors from adaptor path: " + adaptorPath);
        }
        if (adaptorPath == null) {
            throw new Error("gat.adaptor.path not set!");
        }
        StringTokenizer st = new StringTokenizer(adaptorPath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            ClassLoader sharedLoader;
            String dir = st.nextToken();
            logger.debug("readJarFiles: dir = " + dir);
            File adaptorRoot = new File(dir);
            if (!adaptorRoot.isDirectory()) {
                logger.warn("Specified gat.adaptor.path entry " + dir + " is not a directory");
                continue;
            }
            try {
                sharedLoader = this.loadDirectory(new File(adaptorRoot, "shared"), superparentLoader, false);
            }
            catch (Throwable e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Got exception when loading shared directory", e);
                }
                sharedLoader = superparentLoader;
            }
            this.parentLoader = sharedLoader;
            this.readJarFiles(adaptorRoot);
        }
        if (this.adaptorLists.size() == 0) {
            throw new Error("GAT: No adaptors could be loaded");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("creating the GAT engine: adaptors loaded");
        }
        this.orderAdaptorLists();
        if (logger.isDebugEnabled()) {
            logger.debug("creating the GAT engine: adaptors ordered");
            logger.debug(this.getAdaptorListString());
        }
        if (logger.isInfoEnabled()) {
            logger.info("creating the GAT engine DONE");
        }
    }

    private ClassLoader getParentClassLoader() {
        Class<?>[] callers = new CallerResolver().getClassContext();
        Class callerClass = null;
        for (Class<?> c : callers) {
            String name = c.getCanonicalName();
            if (name != null && name.startsWith("org.gridlab.gat")) continue;
            callerClass = c;
            break;
        }
        if (callerClass == null) {
            callerClass = GATEngine.class;
        }
        ClassLoader callerLoader = callerClass.getClassLoader();
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader result = GATEngine.isChild(contextLoader, callerLoader) ? callerLoader : (GATEngine.isChild(callerLoader, contextLoader) ? contextLoader : contextLoader);
        if (GATEngine.isChild(result, systemLoader)) {
            result = systemLoader;
        }
        return result;
    }

    private static boolean isChild(ClassLoader l1, ClassLoader l2) {
        if (l1 == null) {
            return true;
        }
        while (l2 != null) {
            if (l1 == l2) {
                return true;
            }
            l2 = l2.getParent();
        }
        return false;
    }

    private void orderAdaptorLists() {
        AdaptorOrderPolicy adaptorOrderPolicy;
        String policy = System.getProperty("adaptor.order.policy");
        if (logger.isTraceEnabled()) {
            if (policy != null) {
                logger.trace("custom adaptor order policy specified: " + policy);
            } else {
                logger.trace("no custom adaptor order policy specified");
            }
        }
        if (policy != null) {
            Class<?> c;
            try {
                c = Class.forName(policy);
            }
            catch (ClassNotFoundException e) {
                throw new Error("adaptor policy " + policy + " not found: " + e);
            }
            try {
                adaptorOrderPolicy = (AdaptorOrderPolicy)c.newInstance();
            }
            catch (Exception e) {
                throw new Error("adaptor policy " + policy + " could not be instantiated: " + e);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("using adaptor ordering policy: " + policy);
            }
        } else {
            adaptorOrderPolicy = new DefaultAdaptorOrderPolicy();
        }
        adaptorOrderPolicy.order(this.adaptorLists);
    }

    private String getAdaptorListString() {
        String output = "Adaptor Lists:";
        Set<String> keys = this.adaptorLists.keySet();
        for (String key : keys) {
            output = output + "\n" + key;
            for (Adaptor adaptor : this.adaptorLists.get(key)) {
                output = output + "\n  " + adaptor;
            }
        }
        return output;
    }

    static boolean propertySet(String name) {
        String s;
        Properties p = System.getProperties();
        return p != null && (s = p.getProperty(name)) != null && !s.equals("false");
    }

    public static synchronized GATEngine getGATEngine() {
        if (gatEngine == null) {
            gatEngine = new GATEngine();
        }
        return gatEngine;
    }

    public static String[] getAdaptorTypes() {
        GATEngine gatEngine = GATEngine.getGATEngine();
        return gatEngine.adaptorLists.keySet().toArray(new String[gatEngine.adaptorLists.keySet().size()]);
    }

    public static AdaptorInfo[] getAdaptorInfos(String cpiName) {
        GATEngine gatEngine = GATEngine.getGATEngine();
        List<Adaptor> adaptors = gatEngine.adaptorLists.get(cpiName);
        if (adaptors == null) {
            return null;
        }
        AdaptorInfo[] result = new AdaptorInfo[adaptors.size()];
        int i = 0;
        for (Adaptor adaptor : adaptors) {
            Map capabilities = null;
            try {
                Class<?> adaptorClass = adaptor.getAdaptorClass();
                Method infoMethod = adaptorClass.getMethod("getSupportedCapabilities", null);
                capabilities = (Map)infoMethod.invoke(null, (Object[])null);
            }
            catch (Exception adaptorClass) {
                // empty catch block
            }
            Preferences preferences = null;
            try {
                Class<?> adaptorClass = adaptor.getAdaptorClass();
                Method infoMethod = adaptorClass.getMethod("getSupportedPreferences", null);
                preferences = (Preferences)infoMethod.invoke(null, (Object[])null);
            }
            catch (Exception adaptorClass) {
                // empty catch block
            }
            String description = "not available";
            try {
                Class<?> adaptorClass = adaptor.getAdaptorClass();
                Method infoMethod = adaptorClass.getMethod("getDescription", null);
                description = (String)infoMethod.invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result[i++] = new AdaptorInfo(adaptor.getName(), adaptor.getAdaptorClass().getSimpleName(), cpiName, preferences, capabilities, description);
        }
        return result;
    }

    protected void readJarFiles(File adaptorRoot) {
        File[] adaptorDirs = adaptorRoot.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && file.getName().endsWith("Adaptor");
            }
        });
        if (adaptorDirs.length == 0) {
            logger.warn("gat.adaptor.path contains '" + adaptorRoot + "', but it doesn't contain any adaptor");
        }
        Arrays.sort(adaptorDirs, new FileComparator());
        HashMap<String, ClassLoader> adaptorClassLoaders = new HashMap<String, ClassLoader>();
        for (File adaptorDir : adaptorDirs) {
            try {
                adaptorClassLoaders.put(adaptorDir.getName(), this.loadDirectory(adaptorDir, this.parentLoader, true));
                if (!logger.isDebugEnabled()) continue;
                logger.debug("loading adaptor SUCCESS: " + adaptorDir);
            }
            catch (Throwable e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("loading adaptor FAILED: " + adaptorDir + " (" + e + ")");
            }
        }
    }

    private ClassLoader loadDirectory(File adaptorDir, ClassLoader parentForDir, boolean mustContainAdaptorJar) throws Exception {
        Attributes attributes;
        ArrayList<URL> adaptorPathURLs = new ArrayList<URL>();
        if (mustContainAdaptorJar) {
            File adaptorJarFile = new File(adaptorDir.getPath() + File.separator + adaptorDir.getName() + ".jar");
            if (!adaptorJarFile.exists()) {
                throw new Exception("found adaptor dir '" + adaptorDir.getPath() + "' that doesn't contain an adaptor named '" + adaptorJarFile.getPath() + "'");
            }
            JarFile adaptorJar = new JarFile(adaptorJarFile, true);
            attributes = adaptorJar.getManifest().getMainAttributes();
            adaptorJar.close();
            adaptorPathURLs.add(adaptorJarFile.toURI().toURL());
        } else {
            attributes = new Attributes();
        }
        Object[] externalJars = adaptorDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith(".jar");
            }
        });
        Arrays.sort(externalJars);
        if (logger.isTraceEnabled()) {
            if (externalJars != null) {
                logger.trace(adaptorDir + " contains external jar files: ");
                for (Object externalJar : externalJars) {
                    logger.trace("\t" + (String)externalJar);
                }
            } else {
                logger.trace(adaptorDir + " doesn't contain external jar files");
            }
        }
        if (externalJars != null) {
            for (Object externalJar : externalJars) {
                adaptorPathURLs.add(new File(adaptorDir, (String)externalJar).toURI().toURL());
            }
        }
        URL[] urls = adaptorPathURLs.toArray(new URL[adaptorPathURLs.size()]);
        if (logger.isTraceEnabled()) {
            logger.trace("URLs used for the URL class loader constructed from: " + adaptorDir);
            if (urls != null) {
                for (URL url : urls) {
                    logger.trace("\t" + url);
                }
            } else {
                logger.trace("\tno URLs");
            }
        }
        URLClassLoader adaptorLoader = new URLClassLoader(urls, parentForDir);
        Set<Object> keys = attributes.keySet();
        for (Object key : keys) {
            if (!((Attributes.Name)key).toString().endsWith("Cpi-class")) continue;
            String cpiName = ((Attributes.Name)key).toString().replace("Cpi-class", "");
            String[] adaptorClasses = attributes.getValue((Attributes.Name)key).split(",");
            if (logger.isTraceEnabled()) {
                logger.trace("found " + adaptorClasses.length + " adaptors implementing cpi: " + cpiName);
            }
            for (String adaptorClass : adaptorClasses) {
                try {
                    if (logger.isTraceEnabled()) {
                        logger.trace("\tloading adaptor: " + adaptorClass);
                    }
                    Thread.currentThread().setContextClassLoader(adaptorLoader);
                    Class<?> clazz = adaptorLoader.loadClass(adaptorClass);
                    GATEngine.callInitializer(clazz);
                    String[] schemes = GATEngine.callGetSupportedSchemes(clazz);
                    if (!this.adaptorLists.containsKey(cpiName)) {
                        this.adaptorLists.put(cpiName, new ArrayList());
                    }
                    this.adaptorLists.get(cpiName).add(new Adaptor(cpiName, clazz, schemes));
                }
                catch (Exception e) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("\t\tfailed loading adaptor: " + adaptorClass + " (" + e + ")");
                }
            }
        }
        return adaptorLoader;
    }

    protected String getJarsAsString(URL[] urls) {
        String result = "";
        for (int i = 0; i < urls.length; ++i) {
            result = result + "    " + urls[i].getFile();
        }
        return result;
    }

    protected List<File> getFiles(File f) {
        Vector<File> vector = new Vector<File>();
        File[] files = f.listFiles();
        Arrays.sort(files, new FileComparator());
        if (files == null) {
            return vector;
        }
        for (int count = 0; count < files.length; ++count) {
            vector.add(files[count]);
        }
        return vector;
    }

    public static void registerUnmarshaller(Class<?> clazz) {
        if (logger.isTraceEnabled()) {
            logger.trace("\t\tregister marshaller for: " + clazz);
        }
        unmarshallers.add(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Advertisable unmarshalAdvertisable(GATContext gatContext, String input) throws GATInvocationException {
        if (input == null) {
            throw new NullPointerException("cannot unmarshal null String");
        }
        GATEngine gATEngine = this;
        synchronized (gATEngine) {
            if (!this.unmarshallersAdded) {
                this.unmarshallersAdded = true;
                for (List<Adaptor> adaptorList : this.adaptorLists.values()) {
                    for (Adaptor adaptor : adaptorList) {
                        Class<?> c = adaptor.adaptorClass;
                        if (!GATEngine.containsUnmarshaller(c)) continue;
                        unmarshallers.add(c);
                    }
                }
            }
        }
        for (int i = 0; i < unmarshallers.size(); ++i) {
            Class<?> c = unmarshallers.get(i);
            try {
                Method m = c.getMethod("unmarshal", unmarshalParams);
                Advertisable res = (Advertisable)m.invoke(null, gatContext, input);
                if (res == null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("unmarshalAdvert: returning: " + res);
                }
                return res;
            }
            catch (InvocationTargetException e1) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("unmarshaller for " + c.getName() + " failed:", e1.getTargetException());
                continue;
            }
            catch (Throwable e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("unmarshaller for " + c.getName() + " failed:", e);
            }
        }
        throw new GATInvocationException("could not find suitable unmarshaller");
    }

    public String marshalAdvertisable(Advertisable advert) {
        if (advert == null) {
            throw new NullPointerException("cannot marshal null Advertisable");
        }
        String res = advert.marshal();
        return res;
    }

    private static boolean containsUnmarshaller(Class<?> clazz) {
        try {
            clazz.getMethod("unmarshal", unmarshalParams);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static void callInitializer(Class<?> clazz) {
        block4: {
            Method m;
            try {
                m = clazz.getMethod("init", null);
            }
            catch (Throwable e) {
                return;
            }
            try {
                m.invoke(null, (Object[])null);
            }
            catch (Throwable t) {
                if (!logger.isInfoEnabled()) break block4;
                logger.info("initialization of " + clazz + " failed: " + t);
            }
        }
    }

    private static String[] callGetSupportedSchemes(Class<?> clazz) {
        Method m;
        try {
            m = clazz.getMethod("getSupportedSchemes", null);
        }
        catch (Throwable e) {
            return null;
        }
        try {
            Object[] result = (String[])m.invoke(null, (Object[])null);
            if (logger.isInfoEnabled()) {
                logger.info("Supported schemes of class " + clazz.getName() + ": " + Arrays.toString(result));
            }
            return result;
        }
        catch (Throwable t) {
            if (logger.isInfoEnabled()) {
                logger.info("getSupportedSchemes of " + clazz + " failed: " + t);
            }
            return null;
        }
    }

    public static String defaultMarshal(Object o) {
        if (o == null) {
            throw new Error("cannot marshal a null object");
        }
        StringWriter sw = new StringWriter();
        try {
            Marshaller.marshal((Object)o, (Writer)sw);
        }
        catch (Throwable e) {
            throw new Error("could not marshal object: ", e);
        }
        return sw.toString();
    }

    public static Advertisable defaultUnmarshal(Class<?> type, String s) {
        if (s == null) {
            throw new Error("cannot unmarshal a null object");
        }
        StringReader sr = new StringReader(s);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("default unmarshaller start, type = " + type + " string = " + s);
            }
            Unmarshaller unmarshaller = new Unmarshaller(type);
            unmarshaller.setIgnoreExtraAttributes(false);
            unmarshaller.setIgnoreExtraElements(false);
            unmarshaller.setValidation(true);
            Advertisable res = (Advertisable)unmarshaller.unmarshal((Reader)sr);
            if (res == null) {
                throw new Error("cannot unmarshal this object");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("default unmarshaller returning " + res);
            }
            return res;
        }
        catch (Exception e) {
            throw new Error("could not unmarshal object: " + e);
        }
    }

    public static Advertisable defaultUnmarshal(Class<?> type, String s, String expectedClass) {
        Advertisable a = GATEngine.defaultUnmarshal(type, s);
        if (!(a instanceof SerializedBase)) {
            throw new Error("could not unmarshal object: not a SerializedBase.");
        }
        if (!((SerializedBase)a).checkClassname(expectedClass)) {
            throw new Error("could not unmarshal object: found " + ((SerializedBase)a).getClassname() + " instead of " + expectedClass);
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void end() {
        GATEngine engine = GATEngine.getGATEngine();
        GATEngine gATEngine = engine;
        synchronized (gATEngine) {
            if (engine.ended) {
                return;
            }
            engine.ended = true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("shutting down the GAT engine START");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("shutting down the GAT engine: shutting down adaptors");
        }
        try {
            JobCpi.end();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        FileWaiter.end();
        for (List list : engine.adaptorLists.values()) {
            for (Adaptor adaptor : list) {
                Class<?> c = adaptor.adaptorClass;
                try {
                    Method m = c.getMethod("end", null);
                    m.invoke(null, (Object[])null);
                }
                catch (Throwable throwable) {}
            }
        }
        ScheduledExecutor.end();
        if (logger.isInfoEnabled()) {
            logger.info("shutting down the GAT engine DONE");
        }
    }

    public static Object createAdaptorProxy(String cpiName, Class<?> interfaceClass, GATContext gatContext, Class<?>[] parameterTypes, Object[] tmpParams) throws GATObjectCreationException {
        GATEngine gatEngine = GATEngine.getGATEngine();
        List<Adaptor> adaptors = gatEngine.adaptorLists.get(cpiName);
        if (adaptors == null) {
            throw new GATObjectCreationException("could not find any adaptors");
        }
        if (gatContext.getPreferences().containsKey(cpiName + ".adaptor.name")) {
            if (logger.isDebugEnabled()) {
                logger.debug("old adaptor order: \n" + adaptors.toString());
            }
            adaptors = GATEngine.reorderAdaptorList(adaptors, cpiName, gatContext.getPreferences());
            if (logger.isDebugEnabled()) {
                logger.debug("new adaptor order: \n" + adaptors.toString());
            }
        }
        boolean singleAdaptorPerProxy = false;
        Class<?>[] implementedInterfaces = interfaceClass.getInterfaces();
        if (implementedInterfaces != null) {
            for (Class<?> implementedInterface : implementedInterfaces) {
                if (!implementedInterface.getName().equals("org.gridlab.gat.SingleAdaptorPerProxy")) continue;
                singleAdaptorPerProxy = true;
                break;
            }
        }
        AdaptorInvocationHandler handler = new AdaptorInvocationHandler(adaptors, gatContext, parameterTypes, tmpParams, singleAdaptorPerProxy);
        Object proxy = Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)handler);
        return proxy;
    }

    private static List<Adaptor> reorderAdaptorList(List<Adaptor> adaptors, String cpiName, Preferences preferences) throws GATObjectCreationException {
        String nameString;
        int removed = 0;
        logger.debug("reordering, cpiname: " + cpiName + ", preferences: " + preferences);
        int insertPosition = 0;
        ArrayList<Adaptor> result = new ArrayList<Adaptor>();
        for (int i = 0; i < adaptors.size(); ++i) {
            result.add(i, adaptors.get(i));
        }
        String local = (String)preferences.get("adaptors.local");
        if (local != null && local.equalsIgnoreCase("true")) {
            logger.debug("setting to local!");
            nameString = "local";
        } else {
            nameString = (String)preferences.get(cpiName + ".adaptor.name");
        }
        String[] names = nameString.split(",");
        for (int i = 0; i < names.length; ++i) {
            names[i] = names[i].trim();
            if (names[i].startsWith("!")) {
                ++removed;
                names[i] = names[i].substring(1);
                int pos = result.indexOf(GATEngine.getAdaptor(names[i], cpiName, adaptors));
                if (pos >= 0) {
                    result.remove(pos);
                    if (pos >= insertPosition) continue;
                    --insertPosition;
                    continue;
                }
                if (!logger.isInfoEnabled()) continue;
                logger.info("Found non existing adaptor in " + cpiName + ".adaptor.name preference: " + names[i]);
                continue;
            }
            if (names[i].equals("")) {
                return result;
            }
            int currentPosition = result.indexOf(GATEngine.getAdaptor(names[i], cpiName, adaptors));
            if (currentPosition >= insertPosition) {
                result.add(insertPosition, (Adaptor)result.remove(currentPosition));
                ++insertPosition;
                continue;
            }
            if (currentPosition >= 0 || !logger.isInfoEnabled()) continue;
            logger.info("Found non existing adaptor in " + cpiName + ".adaptor.name preference: " + names[i]);
        }
        if (insertPosition > 0 && !nameString.trim().endsWith(",")) {
            int endPosition = result.size();
            for (int i = insertPosition; i < endPosition; ++i) {
                result.remove(insertPosition);
            }
        } else if (insertPosition == 0 && removed < names.length) {
            throw new GATObjectCreationException("no adaptors available for preference: \"" + cpiName + ".adaptor.name\", \"" + nameString + "\"");
        }
        return result;
    }

    private static Adaptor getAdaptor(String shortName, String cpiName, List<Adaptor> adaptors) {
        for (Adaptor adaptor : adaptors) {
            if (!adaptor.getShortAdaptorClassName().equalsIgnoreCase(shortName + cpiName + "Adaptor")) continue;
            return adaptor;
        }
        return null;
    }

    public static String getLocalHostName() {
        try {
            InetAddress a = InetAddress.getLocalHost();
            if (a != null) {
                return a.getCanonicalHostName();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "localhost";
    }

    public static InetAddress getLocalHostAddress() {
        try {
            InetAddress a = InetAddress.getLocalHost();
            return a;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static final class CallerResolver
    extends SecurityManager {
        private CallerResolver() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }

    private static class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            return f1.getName().compareTo(f2.getName());
        }
    }
}

