/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.engine.util;

import ibis.util.ThreadPool;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.gridlab.gat.engine.util.ProcessRunner;
import org.gridlab.gat.engine.util.StreamForwarder;

public class ProcessBundle
implements Runnable {
    private ProcessRunner[] processes;
    private OutputStream stdin = null;
    private InputStream stdout = null;
    private InputStream stderr = null;
    private boolean done = false;
    private int processID;

    public ProcessBundle(int count, String exe, String[] args, File dir, Map<String, Object> env) {
        this.processes = new ProcessRunner[count];
        for (int i = 0; i < count; ++i) {
            this.processes[i] = new ProcessRunner(exe, args, dir, env);
        }
    }

    public void startBundle() throws IOException {
        for (int i = 0; i < this.processes.length; ++i) {
            try {
                this.processes[i].startProcess();
                continue;
            }
            catch (IOException e) {
                if (i > 0) {
                    for (int j = 0; j < i; ++j) {
                        this.processes[j].kill();
                    }
                }
                throw e;
            }
        }
        this.processID = this.processes[0].getProcessID();
        ThreadPool.createNew((Runnable)this, (String)"ProcessBundleWaiter");
    }

    public void closeInput() {
        if (this.stdin != null) {
            try {
                this.stdin.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public OutputStream getStdin() {
        if (this.stdin == null) {
            this.stdin = this.processes.length == 1 ? this.processes[0].getStdin() : new OutputStreamSplitter(this.processes);
        }
        return this.stdin;
    }

    public void setStdin(String name, InputStream in) {
        new StreamForwarder(in, this.getStdin(), name + " [stdin]");
    }

    public InputStream getStdout() {
        if (this.stdout == null) {
            if (this.processes.length == 1) {
                this.stdout = this.processes[0].getStdout();
            } else {
                InputStream[] streams = new InputStream[this.processes.length];
                for (int i = 0; i < streams.length; ++i) {
                    streams[i] = this.processes[i].getStdout();
                }
                this.stdout = new MergingInputStream(streams);
            }
        }
        return this.stdout;
    }

    public InputStream getStderr() {
        if (this.stderr == null) {
            if (this.processes.length == 1) {
                this.stderr = this.processes[0].getStderr();
            } else {
                InputStream[] streams = new InputStream[this.processes.length];
                for (int i = 0; i < streams.length; ++i) {
                    streams[i] = this.processes[i].getStderr();
                }
                this.stderr = new MergingInputStream(streams);
            }
        }
        return this.stderr;
    }

    public int getExitStatus() {
        this.waitFor();
        return this.processes[0].getExitStatus();
    }

    public int getProcessID() {
        return this.processID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (ProcessRunner r : this.processes) {
            r.waitFor();
        }
        ProcessBundle processBundle = this;
        synchronized (processBundle) {
            this.done = true;
            this.notifyAll();
        }
    }

    public void kill() {
        for (ProcessRunner r : this.processes) {
            r.kill();
        }
    }

    public synchronized void waitFor() {
        while (!this.done) {
            try {
                this.wait();
            }
            catch (Throwable throwable) {}
        }
    }

    private static class Reader
    implements Runnable {
        private int available = 0;
        private int pos = 0;
        private final byte[] buffer = new byte[4096];
        private final InputStream stream;
        private IOException exception = null;
        private final MergingInputStream merger;

        Reader(MergingInputStream merger, InputStream stream) {
            this.stream = stream;
            this.merger = merger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            while (true) {
                int len;
                try {
                    len = this.stream.read(this.buffer);
                }
                catch (IOException ex) {
                    this.exception = ex;
                    len = -1;
                }
                this.available = len;
                this.pos = 0;
                MergingInputStream mergingInputStream = this.merger;
                synchronized (mergingInputStream) {
                    this.merger.notify();
                    if (len < 0) {
                        try {
                            this.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.merger.closedStreams++;
                        break;
                    }
                }
                do {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (this.available != 0);
            }
        }

        synchronized int read() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
            int ch = this.buffer[this.pos] & 0xFF;
            if (++this.pos == this.available) {
                this.available = 0;
                this.notify();
            }
            return ch;
        }

        synchronized int read(byte[] b, int off, int len) throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.available - this.pos <= len) {
                len = this.available - this.pos;
                this.available = 0;
                this.notify();
            }
            System.arraycopy(this.buffer, this.pos, b, off, len);
            this.pos += len;
            return len;
        }

        synchronized void close() throws IOException {
            this.stream.close();
            this.available = 0;
            this.notify();
        }
    }

    private static class MergingInputStream
    extends InputStream {
        private Reader[] readerThreads;
        private int index;
        private int closedStreams = 0;

        public MergingInputStream(InputStream ... streams) {
            this.readerThreads = new Reader[streams.length];
            for (int i = 0; i < streams.length; ++i) {
                this.readerThreads[i] = new Reader(this, streams[i]);
                ThreadPool.createNew((Runnable)this.readerThreads[i], (String)"MergingInputStreamReader");
            }
            this.index = 0;
        }

        @Override
        public synchronized int read() throws IOException {
            while (this.closedStreams != this.readerThreads.length) {
                for (int i = 0; i < this.readerThreads.length; ++i) {
                    Reader rd = this.readerThreads[this.index];
                    if (rd.available > 0) {
                        return rd.read();
                    }
                    ++this.index;
                    if (this.index != this.readerThreads.length) continue;
                    this.index = 0;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return -1;
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            while (this.closedStreams != this.readerThreads.length) {
                for (int i = 0; i < this.readerThreads.length; ++i) {
                    Reader rd = this.readerThreads[this.index];
                    if (rd.available > 0) {
                        return rd.read(b, off, len);
                    }
                    ++this.index;
                    if (this.index != this.readerThreads.length) continue;
                    this.index = 0;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return -1;
        }

        @Override
        public synchronized void close() throws IOException {
            for (Reader r : this.readerThreads) {
                if (r.available < 0) continue;
                r.close();
            }
            this.closedStreams = this.readerThreads.length;
        }
    }

    private static class OutputStreamSplitter
    extends OutputStream {
        private OutputStream[] streams;

        public OutputStreamSplitter(ProcessRunner[] bundle) {
            this.streams = new OutputStream[bundle.length];
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i] = bundle[i].getStdin();
            }
        }

        @Override
        public void close() throws IOException {
            IOException ex = null;
            for (OutputStream s : this.streams) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    if (ex != null) continue;
                    ex = e;
                }
            }
            if (ex != null) {
                throw ex;
            }
        }

        @Override
        public void flush() throws IOException {
            IOException ex = null;
            for (OutputStream s : this.streams) {
                try {
                    s.flush();
                }
                catch (IOException e) {
                    if (ex != null) continue;
                    ex = e;
                }
            }
            if (ex != null) {
                throw ex;
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            IOException ex = null;
            for (OutputStream s : this.streams) {
                try {
                    s.write(b, off, len);
                }
                catch (IOException e) {
                    if (ex != null) continue;
                    ex = e;
                }
            }
            if (ex != null) {
                throw ex;
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(int arg0) throws IOException {
            IOException ex = null;
            for (OutputStream s : this.streams) {
                try {
                    s.write(arg0);
                }
                catch (IOException e) {
                    if (ex != null) continue;
                    ex = e;
                }
            }
            if (ex != null) {
                throw ex;
            }
        }
    }
}

