/*
 * Decompiled with CFR 0.152.
 */
package benchmarks;

import benchmarks.AdaptorTestResultEntry;
import java.util.HashMap;
import java.util.Map;

public class AdaptorTestResult {
    private String adaptor;
    private String host;
    private Map<String, AdaptorTestResultEntry> testResultEntries = new HashMap<String, AdaptorTestResultEntry>();

    public AdaptorTestResult(String adaptor, String host) {
        this.adaptor = adaptor;
        this.host = host;
    }

    public void put(String key, AdaptorTestResultEntry testResultEntry) {
        this.testResultEntries.put(key, testResultEntry);
    }

    public void print() {
        System.out.println("*** general results ***");
        System.out.println("adaptor:    " + this.adaptor);
        System.out.println("host:       " + this.host);
        System.out.println("total time: " + this.getTotalRunTime() + " msec");
        System.out.println("avg time  : " + this.getAverageRunTime() + " msec");
        System.out.println("*** method results  ***");
        for (String key : this.testResultEntries.keySet()) {
            System.out.print(key);
            AdaptorTestResultEntry result = this.testResultEntries.get(key);
            if (result.getResult()) {
                System.out.print("\t SUCCESS \t" + this.testResultEntries.get(key).getTime() + " msec");
                if (result.getException() != null) {
                    System.out.println("\t" + result.getException());
                    continue;
                }
                System.out.println();
                continue;
            }
            System.out.println("\t FAILURE \t");
            if (result.getException() == null) continue;
            result.getException().printStackTrace();
        }
    }

    public long getTotalRunTime() {
        long result = 0L;
        for (AdaptorTestResultEntry testResultEntry : this.testResultEntries.values()) {
            if (!testResultEntry.getResult()) continue;
            result += testResultEntry.getTime();
        }
        return result;
    }

    public long getAverageRunTime() {
        long result = 0L;
        int i = 0;
        for (AdaptorTestResultEntry testResultEntry : this.testResultEntries.values()) {
            if (!testResultEntry.getResult()) continue;
            result += testResultEntry.getTime();
            ++i;
        }
        if (i == 0) {
            return 0L;
        }
        return result / (long)i;
    }

    public String getAdaptor() {
        return this.adaptor;
    }

    public Map<String, AdaptorTestResultEntry> getTestResultEntries() {
        return this.testResultEntries;
    }
}

