/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.connectors.utils;

import es.bsc.compss.components.ResourceUser;
import es.bsc.compss.connectors.ConnectorException;
import es.bsc.compss.connectors.VM;
import es.bsc.compss.connectors.utils.Operations;
import es.bsc.compss.types.CloudProvider;
import es.bsc.compss.types.ResourceCreationRequest;
import es.bsc.compss.types.resources.CloudMethodWorker;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.resources.configuration.MethodConfiguration;
import es.bsc.compss.types.resources.description.CloudImageDescription;
import es.bsc.compss.types.resources.description.CloudMethodResourceDescription;
import es.bsc.compss.util.ResourceManager;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreationThread
extends Thread {
    private static final Logger RESOURCE_LOGGER = LogManager.getLogger((String)"es.bsc.compss.ConnectorsUtils");
    private static final Logger RUNTIME_LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.ResourceManager");
    private static final boolean DEBUG = RESOURCE_LOGGER.isDebugEnabled();
    private static final String ERROR_ASKING_NEW_RESOURCE = "Error asking a new Resource to ";
    private static final String ERROR_WAITING_VM = "Error waiting for a machine that should be provided by ";
    private static final String ERROR_POWEROFF_VM = "Cannot poweroff the machine\n]";
    private static final String ERROR_GRANTED_NULL = "Error: Granted description is null";
    private static final String ERROR_CONFIGURE_ACCESS_VM = "Error configuring access to machine ";
    private static final String ERROR_PREPARING_VM = "Exception preparing machine ";
    private static final String ERROR_ANNOUNCE_VM = "Error announcing the machine ";
    private static final String ERROR_WORKER_SHUTDOWN = "Exception raised on worker shutdown";
    private static final String ERROR_ANNOUNCE_VM_DESTROY = "Error announcing VM destruction";
    private static final String ERROR_USELESS_VM = "Useless VM";
    private static final String WARN_VM_REFUSED = "New resource has been refused because COMPSs has been stopped";
    private static final String WARN_CANNOT_PROVIDE_VM = "Provider can not provide the vm";
    private static ResourceUser listener;
    private static final AtomicInteger COUNT;
    private final Operations operations;
    private final String name;
    private final CloudProvider provider;
    private final ResourceCreationRequest rcr;
    private final VM reused;

    public CreationThread(Operations operations, String name, CloudProvider provider, ResourceCreationRequest rR, VM reused) {
        this.setName("Creation Thread " + name);
        this.operations = operations;
        this.provider = provider;
        this.name = name;
        this.rcr = rR;
        this.reused = reused;
        COUNT.incrementAndGet();
    }

    public static int getCount() {
        return COUNT.get();
    }

    @Override
    public void run() {
        VM granted;
        boolean check = this.operations.getCheck();
        RUNTIME_LOGGER.debug("Operations check = " + check);
        CloudMethodResourceDescription requested = this.rcr.getRequested();
        if (this.reused == null) {
            this.setName("Creation Thread " + this.name);
            try {
                granted = this.createResourceOnProvider(requested);
            }
            catch (Exception e) {
                RUNTIME_LOGGER.error(ERROR_ASKING_NEW_RESOURCE + this.provider, (Throwable)e);
                this.notifyFailure();
                return;
            }
            if (DEBUG) {
                RUNTIME_LOGGER.debug("Resource " + granted.getName() + " with id  " + granted.getEnvId() + " has been created ");
            }
            RESOURCE_LOGGER.info("RESOURCE_GRANTED = [\n\tNAME = " + granted.getName() + "\n\tSTATUS = ID " + granted.getEnvId() + " CREATED\n]");
        } else {
            granted = this.reused;
            if (DEBUG) {
                RUNTIME_LOGGER.debug("Resource " + granted.getName() + " with id  " + granted.getEnvId() + " has been reused ");
            }
            RESOURCE_LOGGER.info("RESOURCE_GRANTED = [\n\tNAME = " + this.reused.getName() + "\n\tSTATUS = ID " + granted.getEnvId() + " REUSED\n]");
        }
        String grantedName = granted.getName();
        this.setName("Creation Thread " + grantedName);
        CloudMethodWorker r = (CloudMethodWorker)ResourceManager.getDynamicResource(granted.getName());
        if (r == null) {
            if (this.reused == null) {
                try {
                    if (DEBUG) {
                        RUNTIME_LOGGER.debug(" Preparing new worker resource " + granted.getName() + ".");
                    }
                    r = this.prepareNewResource(granted);
                    this.operations.vmReady(granted);
                }
                catch (Exception e) {
                    RUNTIME_LOGGER.error(ERROR_PREPARING_VM, (Throwable)e);
                    this.powerOff(granted);
                    this.notifyFailure();
                    return;
                }
            } else {
                int limitOfTasks = granted.getDescription().getTotalCPUComputingUnits();
                int limitGPUTasks = granted.getDescription().getTotalGPUComputingUnits();
                int limitFPGATasks = granted.getDescription().getTotalFPGAComputingUnits();
                int limitOTHERTasks = granted.getDescription().getTotalOTHERComputingUnits();
                r = new CloudMethodWorker(grantedName, this.provider, granted.getDescription(), granted.getNode(), limitOfTasks, limitGPUTasks, limitFPGATasks, limitOTHERTasks, this.rcr.getRequested().getImage().getSharedDisks());
                if (DEBUG) {
                    RUNTIME_LOGGER.debug("Worker for new resource " + grantedName + " set.");
                }
            }
            granted.setWorker(r);
            ResourceManager.addCloudWorker(this.rcr, r, granted.getDescription());
        } else {
            ResourceManager.increasedCloudWorker(this.rcr, r, granted.getDescription());
        }
        COUNT.decrementAndGet();
    }

    public static void setTaskDispatcher(ResourceUser listener) {
        CreationThread.listener = listener;
    }

    public static ResourceUser getTaskDispatcher() {
        return listener;
    }

    private VM createResourceOnProvider(CloudMethodResourceDescription requested) throws ConnectorException {
        VM granted;
        Object envID;
        try {
            envID = this.operations.poweron(this.name, requested);
        }
        catch (ConnectorException e) {
            RUNTIME_LOGGER.error(ERROR_ASKING_NEW_RESOURCE + this.provider + "\n", (Throwable)e);
            RESOURCE_LOGGER.error("ERROR_MSG = [\n\tError asking a new Resource to " + this.provider + "\n]", (Throwable)e);
            throw e;
        }
        if (envID == null) {
            RUNTIME_LOGGER.info(WARN_CANNOT_PROVIDE_VM);
            RESOURCE_LOGGER.info("INFO_MSG = [\n\t" + this.provider + WARN_CANNOT_PROVIDE_VM + "\n]");
            throw new ConnectorException(WARN_CANNOT_PROVIDE_VM);
        }
        try {
            granted = this.operations.waitCreation(envID, requested);
        }
        catch (ConnectorException e) {
            RUNTIME_LOGGER.error(ERROR_WAITING_VM + this.provider + "\n", (Throwable)e);
            RESOURCE_LOGGER.error("ERROR_MSG = [\n\tError waiting for a machine that should be provided by " + this.provider + "\n]", (Throwable)e);
            try {
                this.operations.destroy(envID);
            }
            catch (ConnectorException ex) {
                RUNTIME_LOGGER.error(ERROR_POWEROFF_VM);
                RESOURCE_LOGGER.error("ERROR_MSG = [\n\tCannot poweroff the machine\n]\n]");
            }
            throw new ConnectorException("Error waiting for the vm");
        }
        if (granted == null) {
            throw new ConnectorException(ERROR_GRANTED_NULL);
        }
        RESOURCE_LOGGER.debug("CONNECTOR_REQUEST = [");
        RESOURCE_LOGGER.debug("\tPROC_CPU_CU = " + requested.getTotalCPUComputingUnits());
        RESOURCE_LOGGER.debug("\tPROC_GPU_CU = " + requested.getTotalGPUComputingUnits());
        RESOURCE_LOGGER.debug("\tPROC_FPGA_CU = " + requested.getTotalFPGAComputingUnits());
        RESOURCE_LOGGER.debug("\tPROC_OTHER_CU = " + requested.getTotalOTHERComputingUnits());
        RESOURCE_LOGGER.debug("\tOS = " + requested.getOperatingSystemType());
        RESOURCE_LOGGER.debug("\tMEM = " + requested.getMemorySize());
        RESOURCE_LOGGER.debug("]");
        CloudMethodResourceDescription desc = granted.getDescription();
        RESOURCE_LOGGER.debug("CONNECTOR_GRANTED = [");
        RESOURCE_LOGGER.debug("\tPROC_CPU_CU = " + desc.getTotalCPUComputingUnits());
        RESOURCE_LOGGER.debug("\tPROC_GPU_CU = " + desc.getTotalGPUComputingUnits());
        RESOURCE_LOGGER.debug("\tPROC_FPGA_CU = " + desc.getTotalFPGAComputingUnits());
        RESOURCE_LOGGER.debug("\tPROC_OTHER_CU = " + desc.getTotalOTHERComputingUnits());
        RESOURCE_LOGGER.debug("\tOS = " + desc.getOperatingSystemType());
        RESOURCE_LOGGER.debug("\tMEM = " + desc.getMemorySize());
        RESOURCE_LOGGER.debug("]");
        return granted;
    }

    private CloudMethodWorker prepareNewResource(VM vm) throws ConnectorException {
        CloudMethodResourceDescription granted = vm.getDescription();
        CloudImageDescription cid = granted.getImage();
        Map<String, String> workerProperties = cid.getProperties();
        String user = cid.getConfig().getUser();
        String password = workerProperties.get("Password");
        try {
            this.operations.configureAccess(granted.getName(), user, password);
        }
        catch (ConnectorException e) {
            RUNTIME_LOGGER.error(ERROR_CONFIGURE_ACCESS_VM + granted.getName(), (Throwable)e);
            RESOURCE_LOGGER.error("ERROR_MSG = [\n\tError configuring access to machine \n\tNAME = " + granted.getName() + "\n\tPROVIDER =  " + this.provider + "\n]", (Throwable)e);
            throw e;
        }
        try {
            this.operations.prepareMachine(granted.getName(), cid);
        }
        catch (ConnectorException e) {
            RUNTIME_LOGGER.error(ERROR_PREPARING_VM + granted.getName(), (Throwable)e);
            RESOURCE_LOGGER.error("ERROR_MSG = [\n\tException preparing machine " + granted.getName() + "]", (Throwable)e);
            throw e;
        }
        MethodConfiguration mc = cid.getConfig();
        int limitOfTasks = mc.getLimitOfTasks();
        int computingUnits = granted.getTotalCPUComputingUnits();
        if (limitOfTasks < 0 && computingUnits < 0) {
            mc.setLimitOfTasks(0);
            mc.setTotalComputingUnits(0);
        } else {
            mc.setLimitOfTasks(Math.max(limitOfTasks, computingUnits));
            mc.setTotalComputingUnits(Math.max(limitOfTasks, computingUnits));
        }
        mc.setHost(granted.getName());
        mc.setLimitOfGPUTasks(granted.getTotalGPUComputingUnits());
        mc.setTotalGPUComputingUnits(granted.getTotalGPUComputingUnits());
        mc.setLimitOfFPGATasks(granted.getTotalFPGAComputingUnits());
        mc.setTotalFPGAComputingUnits(granted.getTotalFPGAComputingUnits());
        mc.setLimitOfOTHERSTasks(granted.getTotalOTHERComputingUnits());
        mc.setTotalOTHERComputingUnits(granted.getTotalOTHERComputingUnits());
        CloudMethodWorker worker = new CloudMethodWorker(granted.getName(), this.provider, granted, mc, cid.getSharedDisks());
        try {
            worker.announceCreation();
        }
        catch (Exception e) {
            RUNTIME_LOGGER.error("Machine " + granted.getName() + " shut down because an error announcing creation");
            RESOURCE_LOGGER.error("ERROR_MSG = [\n\tError announcing the machine \n\tNAME = " + granted.getName() + "\n\tPROVIDER =  " + this.provider + "\n]", (Throwable)e);
            throw new ConnectorException(e);
        }
        if (this.operations.getTerminate()) {
            RESOURCE_LOGGER.info("INFO_MSG = [\n\tNew resource has been refused because COMPSs has been stopped\n\tRESOURCE_NAME = " + granted.getName() + "\n]");
            try {
                worker.announceDestruction();
            }
            catch (Exception e) {
                RESOURCE_LOGGER.error("ERROR_MSG = [\n\tError announcing VM destruction\n\tVM_NAME = " + granted.getName() + "\n]", (Throwable)e);
            }
            Semaphore sem = new Semaphore(0);
            ShutdownListener sl = new ShutdownListener(sem);
            worker.stop(sl);
            sl.enable();
            try {
                sem.acquire();
            }
            catch (Exception e) {
                RESOURCE_LOGGER.error(ERROR_WORKER_SHUTDOWN);
            }
            throw new ConnectorException(ERROR_USELESS_VM);
        }
        return worker;
    }

    private void powerOff(VM granted) {
        try {
            this.operations.poweroff(granted);
        }
        catch (Exception e) {
            RESOURCE_LOGGER.error("ERROR_MSG = [\n\tCannot poweroff the machine\n]\n]", (Throwable)e);
        }
    }

    private void notifyFailure() {
        COUNT.decrementAndGet();
    }

    static {
        COUNT = new AtomicInteger(0);
    }
}

