/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.loaders;

import com.google.common.cache.CacheLoader;
import com.google.common.collect.Iterables;
import java.util.concurrent.ExecutionException;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.EC2ImageParser;
import org.jclouds.ec2.options.DescribeImagesOptions;
import org.jclouds.logging.Logger;

@Singleton
public class RegionAndIdToImage
extends CacheLoader<RegionAndName, Image> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final EC2ImageParser parser;
    private final EC2Api sync;

    @Inject
    public RegionAndIdToImage(EC2ImageParser parser, EC2Api sync) {
        this.parser = parser;
        this.sync = sync;
    }

    @Override
    public Image load(RegionAndName key) throws ExecutionException {
        try {
            org.jclouds.ec2.domain.Image image = Iterables.getOnlyElement(this.sync.getAMIApi().get().describeImagesInRegion(key.getRegion(), DescribeImagesOptions.Builder.imageIds(key.getName())));
            return this.parser.apply(image);
        }
        catch (Exception e) {
            throw new ExecutionException(RegionAndIdToImage.message(key, e), e);
        }
    }

    public static String message(RegionAndName key, Exception e) {
        return String.format("could not find image %s/%s: %s", key.getRegion(), key.getName(), e.getMessage());
    }
}

