/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi.sshlsf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gridlab.gat.AdaptorNotApplicableException;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.engine.GATEngine;
import org.gridlab.gat.monitoring.Metric;
import org.gridlab.gat.monitoring.MetricEvent;
import org.gridlab.gat.monitoring.MetricListener;
import org.gridlab.gat.resources.AbstractJobDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.ResourceBroker;
import org.gridlab.gat.resources.ResourceDescription;
import org.gridlab.gat.resources.SoftwareDescription;
import org.gridlab.gat.resources.WrapperJobDescription;
import org.gridlab.gat.resources.cpi.ResourceBrokerCpi;
import org.gridlab.gat.resources.cpi.Sandbox;
import org.gridlab.gat.resources.cpi.WrapperJobCpi;
import org.gridlab.gat.resources.cpi.sshlsf.LSFScriptWriter;
import org.gridlab.gat.resources.cpi.sshlsf.SshLSFJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshLsfResourceBrokerAdaptor
extends ResourceBrokerCpi
implements MetricListener {
    protected static Logger logger = LoggerFactory.getLogger(SshLsfResourceBrokerAdaptor.class);
    static final String SSHLSF_NATIVE_FLAGS = "sshlsf.native.flags";
    static final String SSHLSF_SCRIPT = "sshlsf.script";
    static final String SSHLSF_SUBMITTER_SCHEME = "sshlsf.submitter.scheme";

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = ResourceBrokerCpi.getSupportedCapabilities();
        capabilities.put("submitJob", true);
        return capabilities;
    }

    public static String[] getSupportedSchemes() {
        return new String[]{"sshlsf"};
    }

    public static Preferences getSupportedPreferences() {
        Preferences p = ResourceBrokerCpi.getSupportedPreferences();
        p.put(SSHLSF_NATIVE_FLAGS, (Object)"");
        p.put(SSHLSF_SCRIPT, (Object)"");
        p.put(SSHLSF_SUBMITTER_SCHEME, (Object)"ssh");
        return p;
    }

    public static void init() {
        GATEngine.registerUnmarshaller(SshLSFJob.class);
    }

    static GATContext getSubContext(GATContext context) {
        Preferences p = context.getPreferences();
        Preferences prefs = new Preferences();
        if (p != null) {
            prefs.putAll(p);
        }
        prefs.remove("resourcebroker.adaptor.name");
        prefs.remove("sshtrilead.stoppable");
        GATContext subContext = (GATContext)context.clone();
        subContext.removePreferences();
        subContext.addPreferences(prefs);
        return subContext;
    }

    static ResourceBroker subResourceBroker(GATContext context, URI broker) throws URISyntaxException, GATObjectCreationException {
        String subScheme = context.getPreferences() != null ? (String)context.getPreferences().get(SSHLSF_SUBMITTER_SCHEME, (Object)"ssh") : "ssh";
        URI subBroker = broker.setScheme(subScheme);
        return GAT.createResourceBroker((GATContext)context, (URI)subBroker);
    }

    public SshLsfResourceBrokerAdaptor(GATContext gatContext, URI brokerURI) throws GATObjectCreationException, AdaptorNotApplicableException {
        super(gatContext, brokerURI);
    }

    public Job submitJob(AbstractJobDescription abstractDescription, MetricListener listener, String metricDefinitionName) throws GATInvocationException {
        String jobid;
        ResourceBroker subBroker;
        if (!(abstractDescription instanceof JobDescription)) {
            throw new GATInvocationException("can only handle JobDescriptions: " + abstractDescription.getClass());
        }
        JobDescription description = (JobDescription)((JobDescription)abstractDescription).clone();
        SoftwareDescription sd = description.getSoftwareDescription();
        int nproc = description.getProcessCount();
        if (sd.streamingStderrEnabled() || sd.streamingStdinEnabled() || sd.streamingStdoutEnabled()) {
            throw new GATInvocationException("Streaming I/O not supported by SshLSF adaptor");
        }
        String authority = this.getAuthority();
        if (authority == null) {
            authority = "localhost";
        }
        String returnValueFile = ".rc." + Math.random();
        File bsubFile = this.createBsubScript(description, returnValueFile, nproc);
        if (logger.isDebugEnabled()) {
            logger.debug("**** Adding pre and post staging:\n  " + sd);
        }
        try {
            sd.addPostStagedFile(GAT.createFile((GATContext)this.gatContext, (URI)new URI(returnValueFile)));
        }
        catch (Throwable e) {
            throw new GATInvocationException("Error in file staging", e);
        }
        try {
            subBroker = SshLsfResourceBrokerAdaptor.subResourceBroker(SshLsfResourceBrokerAdaptor.getSubContext(this.gatContext), this.brokerURI);
        }
        catch (Throwable e) {
            throw new GATInvocationException("Could not create subbroker to submit LSF jobs through ssh", e);
        }
        Sandbox sandbox = new Sandbox(this.gatContext, description, authority, null, true, true, true, true);
        SshLSFJob sshLSFJob = new SshLSFJob(this.gatContext, this.brokerURI, description, sandbox, subBroker, returnValueFile);
        SshLSFJob job = null;
        if (description instanceof WrapperJobDescription) {
            WrapperJobCpi tmp = new WrapperJobCpi(this.gatContext, (Job)sshLSFJob, listener, metricDefinitionName);
            listener = tmp;
            job = tmp;
        } else {
            job = sshLSFJob;
        }
        if (listener != null && metricDefinitionName != null) {
            Metric metric = sshLSFJob.getMetricDefinitionByName(metricDefinitionName).createMetric(null);
            sshLSFJob.addMetricListener(listener, metric);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("*******We are going to perform the ssh submission: ");
        }
        if ((jobid = this.sshLsfSubmission(sshLSFJob, description, bsubFile, subBroker, sandbox)) == null) {
            throw new GATInvocationException("Could not submit sshLSF job");
        }
        sshLSFJob.setState(Job.JobState.SCHEDULED);
        sshLSFJob.setSoft(description.getSoftwareDescription());
        sshLSFJob.setJobID(jobid);
        sshLSFJob.startListener();
        bsubFile.delete();
        return job;
    }

    private File createBsubScript(JobDescription description, String returnValueFile, int nproc) throws GATInvocationException {
        String Queue = null;
        long Time = -1L;
        Integer cpus = null;
        String jobname = null;
        PrintWriter job = null;
        HashMap rd_HashMap = null;
        SoftwareDescription sd = description.getSoftwareDescription();
        ResourceDescription rd = description.getResourceDescription();
        if (rd != null) {
            rd_HashMap = (HashMap)rd.getDescription();
        }
        if (rd_HashMap == null) {
            rd_HashMap = new HashMap();
        }
        File temp = new File("lsf" + Math.random());
        try {
            job = new LSFScriptWriter(new BufferedWriter(new FileWriter(temp)));
            String userScript = (String)this.gatContext.getPreferences().get(SSHLSF_SCRIPT);
            if (userScript != null) {
                String s;
                BufferedReader f = new BufferedReader(new FileReader(userScript));
                while ((s = f.readLine()) != null) {
                    job.print(s + "\n");
                }
            } else {
                String path;
                Object o;
                job.print("#!/bin/sh\n");
                job.print("# bsub script automatically generated by GAT SshLsf adaptor\n");
                Queue = (String)rd_HashMap.get("machine.queue");
                if (Queue == null) {
                    Queue = sd.getStringAttribute("job.queue", null);
                }
                if (Queue != null) {
                    ((LSFScriptWriter)job).addOption("q", Queue);
                }
                Time = sd.getLongAttribute("walltime.max", -1L);
                cpus = (Integer)rd_HashMap.get("cpu.count");
                if (cpus == null) {
                    cpus = sd.getIntAttribute("coreCount", 1);
                }
                ((LSFScriptWriter)job).addOption("n", cpus);
                ((LSFScriptWriter)job).addOption("R", "\"span[ptile=" + cpus + "]\"");
                if (Time > 0L) {
                    int minutes = (int)(Time % 60L);
                    ((LSFScriptWriter)job).addOption("W", minutes);
                } else {
                    ((LSFScriptWriter)job).addOption("W", 60);
                }
                String nativeFlags = null;
                Object object = o = rd == null ? null : rd.getResourceAttribute(SSHLSF_NATIVE_FLAGS);
                if (o != null && o instanceof String) {
                    nativeFlags = (String)o;
                } else {
                    String s;
                    String string = s = sd == null ? null : sd.getStringAttribute(SSHLSF_NATIVE_FLAGS, null);
                    if (s != null) {
                        nativeFlags = s;
                    } else {
                        o = this.gatContext.getPreferences().get(SSHLSF_NATIVE_FLAGS);
                        if (o != null && o instanceof String) {
                            nativeFlags = (String)o;
                        }
                    }
                }
                if (nativeFlags != null) {
                    String[] splits;
                    for (String s : splits = nativeFlags.split("##")) {
                        ((LSFScriptWriter)job).addString(s);
                    }
                }
                if (!(path = sd.getStringAttribute("sandbox.root", "")).isEmpty() && !path.endsWith(File.separator)) {
                    path = path + File.separator;
                }
                if ((jobname = (String)rd_HashMap.get("Jobname")) == null && ((jobname = this.brokerURI.getUserInfo()) == null || "".equals(jobname))) {
                    jobname = "compss_remotejob_" + System.getProperty("user.name");
                }
                if (jobname != null) {
                    ((LSFScriptWriter)job).addOption("J", jobname);
                }
                if (sd.getStdout() != null) {
                    ((LSFScriptWriter)job).addOption("oo", path + sd.getStdout().getName());
                }
                if (sd.getStderr() != null) {
                    ((LSFScriptWriter)job).addOption("eo", path + sd.getStderr().getName());
                }
                this.addScriptExecution((LSFScriptWriter)job, sd, rd);
            }
            job.print("echo retvalue = $? > " + returnValueFile + "\n");
        }
        catch (Throwable e) {
            throw new GATInvocationException("Cannot create temporary bsub file " + temp.getAbsolutePath(), e);
        }
        finally {
            if (job != null) {
                job.close();
            }
        }
        return temp;
    }

    private void addScriptExecution(LSFScriptWriter job, SoftwareDescription sd, ResourceDescription rd) {
        int i;
        Map env;
        String dir = sd.getStringAttribute("directory", null);
        if (dir != null) {
            job.print("cd " + dir + "\n");
        }
        if ((env = sd.getEnvironment()) != null) {
            Set s = env.keySet();
            Object[] keys = s.toArray();
            for (i = 0; i < keys.length; ++i) {
                String val = (String)env.get(keys[i]);
                job.print(keys[i] + "=" + val + " && export " + keys[i] + "\n");
            }
        }
        StringBuffer cmd = new StringBuffer();
        cmd.append(sd.getExecutable().toString());
        if (sd.getArguments() != null) {
            String[] args = sd.getArguments();
            for (i = 0; i < args.length; ++i) {
                cmd.append(" ");
                cmd.append(args[i]);
            }
        }
        job.print(cmd.toString() + "\n");
    }

    private File createJobStarter(JobDescription description, int nproc, File jobScript) throws GATInvocationException {
        File temp;
        SoftwareDescription sd = description.getSoftwareDescription();
        try {
            temp = File.createTempFile("lsf", null);
        }
        catch (IOException e) {
            throw new GATInvocationException("Cannot create file", (Throwable)e);
        }
        try (PrintWriter job = null;){
            job = new PrintWriter(new BufferedWriter(new FileWriter(temp)));
            job.print("#!/bin/sh\n");
            job.print("# Job starter script.\n");
            job.print("# The jobs are distributed over the available nodes in round-robin fashion.\n");
            job.print("GAT_MYDIR=`pwd`\n");
            job.print("case X$LSB_HOSTS in\n");
            job.print("X)  GAT_HOSTS=$HOSTNAME\n");
            job.print("    ;;\n");
            job.print("*)  GAT_HOSTS=`cat $LSB_HOSTS | sed 's/ .*//'`\n");
            job.print("    ;;\n");
            job.print("esac\n");
            job.print("GAT_JOBNO=1\n");
            job.print("GAT_JOBS=" + nproc + "\n");
            job.print("set $GAT_HOSTS\n");
            job.print("shift\n");
            job.print("while :\n");
            job.print("do\n");
            job.print("  for GAT_HOST in \"$@\"\n");
            job.print("  do\n");
            job.print("    echo #!/bin/sh > .gat_script.$GAT_JOBNO\n");
            job.print("    echo cd $GAT_MYDIR >> .gat_script.$GAT_JOBNO\n");
            job.print("    echo trap \\\"touch .gat_done.$GAT_JOBNO\\\" 0 1 2 3 15 >> .gat_script.$GAT_JOBNO\n");
            job.print("    cat " + jobScript.getName() + " >> .gat_script.$GAT_JOBNO\n");
            job.print("    chmod +x .gat_script.$GAT_JOBNO\n");
            job.print("    ssh -o StrictHostKeyChecking=false $GAT_HOST \"$GAT_MYDIR/.gat_script.$GAT_JOBNO");
            if (sd.getStdin() != null) {
                job.print(" < $GAT_MYDIR/" + sd.getStdin().getName());
            } else {
                job.print(" < /dev/null");
            }
            job.print(" > $GAT_MYDIR/.out.$GAT_JOBNO 2>$GAT_MYDIR/.err.$GAT_JOBNO &\"\n");
            job.print("    GAT_JOBNO=`expr $GAT_JOBNO + 1`\n");
            job.print("    if expr $GAT_JOBNO \\>= $GAT_JOBS > /dev/null ; then break 2 ; fi\n");
            job.print("  done\n");
            job.print("  set $GAT_HOSTS\n");
            job.print("done\n");
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sshLsfSubmission(SshLSFJob lsfJob, JobDescription description, File bsubFile, ResourceBroker subBroker, Sandbox sandbox) throws GATInvocationException {
        File slurmResultFile = null;
        try {
            String job_prefix;
            if (logger.isDebugEnabled()) {
                logger.debug("***** Doing sandbox prestage " + sandbox.getSandboxPath());
            }
            sandbox.prestage();
            if (logger.isDebugEnabled()) {
                logger.debug("***** Sandbox prestage done " + sandbox.getSandboxPath());
            }
            SoftwareDescription sd = new SoftwareDescription();
            sd.setExecutable("sh");
            sd.setArguments(new String[]{"-c", "bsub < " + bsubFile.getName() + " 2>submit.err"});
            sd.setAttributes(description.getSoftwareDescription().getAttributes());
            sd.addAttribute("sandbox.useroot", (Object)"true");
            slurmResultFile = File.createTempFile("GAT", "tmp");
            try {
                sd.setStdout(GAT.createFile((GATContext)this.gatContext, (URI)new URI(slurmResultFile.toURI())));
                sd.addPreStagedFile(GAT.createFile((GATContext)this.gatContext, (URI)new URI(bsubFile.toURI())));
            }
            catch (Throwable e1) {
                try {
                    sandbox.removeSandboxDir();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new GATInvocationException("Could not create GAT object for temporary " + slurmResultFile.getAbsolutePath(), e1);
            }
            JobDescription jd = new JobDescription(sd);
            if (logger.isDebugEnabled()) {
                logger.debug("Submitting lsf job: " + sd);
            }
            Job job = subBroker.submitJob((AbstractJobDescription)jd, (MetricListener)this, "job.status");
            if (logger.isDebugEnabled()) {
                logger.debug("Job submitted.");
            }
            Job job2 = job;
            synchronized (job2) {
                while (job.getState() != Job.JobState.STOPPED && job.getState() != Job.JobState.SUBMISSION_ERROR) {
                    try {
                        job.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (job.getState() != Job.JobState.STOPPED || job.getExitStatus() != 0) {
                try {
                    sandbox.removeSandboxDir();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                logger.debug("jobState = " + job.getState() + ", exit status = " + job.getExitStatus());
                throw new GATInvocationException("Could not submit LSF job");
            }
            BufferedReader in = new BufferedReader(new FileReader(slurmResultFile.getAbsolutePath()));
            String result = in.readLine();
            if (logger.isDebugEnabled()) {
                logger.debug("bsub result line = " + result);
            }
            if (result.contains(job_prefix = "Job <")) {
                int i = result.indexOf(job_prefix);
                result = result.substring(i + job_prefix.length(), result.indexOf(">", i));
            }
            String string = result;
            return string;
        }
        catch (IOException e) {
            try {
                sandbox.removeSandboxDir();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new GATInvocationException("Got IOException", (Throwable)e);
        }
        finally {
            slurmResultFile.delete();
            bsubFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMetricEvent(MetricEvent event) {
        if (event.getValue().equals(Job.JobState.STOPPED) || event.getValue().equals(Job.JobState.SUBMISSION_ERROR)) {
            Object object = event.getSource();
            synchronized (object) {
                event.getSource().notifyAll();
            }
        }
    }
}

