/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.stage;

import java.nio.ByteBuffer;

public class Token {
    private static final int ONE_BYTE = 8;
    private static final int TWO_BYTES = 16;
    private static final int THREE_BYTES = 24;
    public static final int SIZE_LENGTH = 4;
    public static final int MAX_SIZE = 10240;
    private final byte[] sizeArray = new byte[4];
    private byte[] content;
    private int putPosition = 0;
    private int readPosition = 0;

    public Token() {
    }

    public Token(byte[] data) {
        int size = data.length;
        this.sizeArray[0] = (byte)(size >>> 24);
        this.sizeArray[1] = (byte)(size >>> 16);
        this.sizeArray[2] = (byte)(size >>> 8);
        this.sizeArray[3] = (byte)size;
        this.content = data;
        this.putPosition = 4 + data.length;
    }

    public void load(ByteBuffer data) {
        if (this.putPosition < 4) {
            while (this.putPosition < 4 && data.remaining() > 0) {
                this.sizeArray[this.putPosition] = data.get();
                ++this.putPosition;
            }
            if (this.putPosition == 4) {
                int size = this.sizeArray[3] & 0xFF | (this.sizeArray[2] & 0xFF) << 8 | (this.sizeArray[1] & 0xFF) << 16 | (this.sizeArray[0] & 0xFF) << 24;
                this.readPosition = 4;
                this.content = new byte[size];
            }
        }
        if (data.remaining() > 0) {
            int toRead = data.remaining();
            int toWrite = this.content.length - (this.putPosition - 4);
            int read = Math.min(toRead, toWrite);
            data.get(this.content, this.putPosition - 4, read);
            this.putPosition += read;
        }
    }

    public byte[] getArray() {
        return this.content;
    }

    public byte[] getSizeArray() {
        return this.sizeArray;
    }

    public int length() {
        return this.content != null ? this.content.length : 0;
    }

    public boolean isCompletelyFilled() {
        return this.content != null && this.putPosition == this.content.length + 4;
    }

    public boolean isCompletelyRead() {
        return this.content != null && this.readPosition == this.content.length + 4;
    }

    public void setReadComplete() {
        if (this.content != null) {
            this.readPosition = this.content.length + 4;
        }
    }

    public byte[] get(int size) {
        int arraySize = this.putPosition - this.readPosition;
        arraySize = Math.min(size, arraySize);
        byte[] b = new byte[arraySize];
        int idx = 0;
        while (this.readPosition < 4) {
            b[idx] = this.sizeArray[this.readPosition];
            ++idx;
            ++this.readPosition;
        }
        if (idx < arraySize && this.readPosition < this.putPosition) {
            System.arraycopy(this.content, this.readPosition - 4, b, idx, arraySize - idx);
            this.readPosition += arraySize - idx;
        }
        return b;
    }
}

