/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import es.bsc.comm.nio.NIONode;
import es.bsc.compss.types.data.location.DataLocation;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class NIOURI
implements Externalizable {
    private NIONode host;
    private String path;
    private DataLocation.Protocol protocol;

    public NIOURI() {
    }

    public NIOURI(NIONode host, String path, DataLocation.Protocol schema) {
        this.host = host;
        this.path = path;
        this.protocol = schema;
    }

    public String getInternalURI() {
        return this.toString();
    }

    public NIONode getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public String getScheme() {
        return this.protocol.getSchema();
    }

    public String toString() {
        return this.protocol.getSchema() + this.host + File.separator + this.path;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.host);
        out.writeUTF(this.path);
        out.writeUTF(this.protocol.getSchema());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.host = (NIONode)in.readObject();
        this.path = in.readUTF();
        this.protocol = DataLocation.Protocol.getBySchema(in.readUTF());
    }

    public DataLocation.Protocol getProtocol() {
        return this.protocol;
    }
}

