/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi.sockets;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import org.exolab.castor.xml.Marshaller;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.advert.Advertisable;
import org.gridlab.gat.engine.GATEngine;
import org.gridlab.gat.io.Pipe;
import org.gridlab.gat.io.PipeListener;
import org.gridlab.gat.io.cpi.EndpointCpi;
import org.gridlab.gat.io.cpi.sockets.SocketPipe;

public class SocketEndpointAdaptor
extends EndpointCpi
implements Serializable {
    int localPort;
    String localHost;
    int remotePort;
    String remoteHost;
    PipeListener listener;
    boolean localEndpoint = true;
    ServerSocket serverSocket;

    public static String getDescription() {
        return "The Socket Endpoint Adaptor implements the EndPoint object on top of Java sockets.";
    }

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = EndpointCpi.getSupportedCapabilities();
        capabilities.put("connect", true);
        capabilities.put("listen", true);
        return capabilities;
    }

    public SocketEndpointAdaptor() {
        super(null);
    }

    public SocketEndpointAdaptor(GATContext gatContext) throws GATObjectCreationException {
        super(gatContext);
        try {
            this.localHost = GATEngine.getLocalHostName();
            this.serverSocket = new ServerSocket(0, 0, GATEngine.getLocalHostAddress());
            this.localPort = this.serverSocket.getLocalPort();
        }
        catch (IOException e) {
            throw new GATObjectCreationException("socket endpoint", (Throwable)e);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof SocketEndpointAdaptor)) {
            return false;
        }
        SocketEndpointAdaptor other = (SocketEndpointAdaptor)object;
        if (this.localEndpoint != other.localEndpoint) {
            return false;
        }
        if (this.localEndpoint) {
            return this.localHost.equals(other.localHost) && this.localPort == other.localPort;
        }
        return this.remoteHost.equals(other.remoteHost) && this.remotePort == other.remotePort;
    }

    public int hashCode() {
        if (this.localEndpoint) {
            return this.localPort;
        }
        return this.remotePort;
    }

    public Pipe connect() throws GATInvocationException {
        if (this.localEndpoint) {
            throw new GATInvocationException("Trying to connect an endpoint that was not obtained through the advert service");
        }
        try {
            Socket s = new Socket(this.remoteHost, this.remotePort);
            return new SocketPipe(this.gatContext, s);
        }
        catch (IOException e) {
            throw new GATInvocationException("socketendpoint", (Throwable)e);
        }
    }

    public Pipe listen() throws GATInvocationException {
        return this.listen(0);
    }

    public Pipe listen(int timeout) throws GATInvocationException {
        if (!this.localEndpoint) {
            throw new GATInvocationException("cannot listen to local endpoint");
        }
        try {
            this.serverSocket.setSoTimeout(timeout);
            Socket s = this.serverSocket.accept();
            return new SocketPipe(this.gatContext, s);
        }
        catch (IOException e) {
            throw new GATInvocationException("socketPipe", (Throwable)e);
        }
    }

    public void listen(PipeListener pipeListener) throws GATInvocationException {
        if (!this.localEndpoint) {
            throw new GATInvocationException("cannot listen to local endpoint");
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public String marshal() {
        StringWriter sw = new StringWriter();
        try {
            Marshaller.marshal((Object)this, (Writer)sw);
        }
        catch (Exception e) {
            throw new Error("could not marshal object: " + e);
        }
        return sw.toString();
    }

    public static Advertisable unmarshal(GATContext context, String s) {
        try {
            SocketEndpointAdaptor res = (SocketEndpointAdaptor)GATEngine.defaultUnmarshal(SocketEndpointAdaptor.class, (String)s);
            res.remotePort = res.localPort;
            res.localPort = -1;
            res.remoteHost = res.localHost;
            res.localEndpoint = false;
            return res;
        }
        catch (Exception e) {
            throw new Error("could not unmarshal object: " + e);
        }
    }

    public String toString() {
        return "endpoint: localPort = " + this.localPort + ", localHost = " + this.localHost + ", remotePort = " + this.remotePort + ", remoteHost = " + this.remoteHost;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public void setLocalHost(String localHost) {
        this.localHost = localHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }
}

