/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi.sockets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.io.cpi.PipeCpi;

public class SocketPipe
extends PipeCpi {
    Socket s;

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = PipeCpi.getSupportedCapabilities();
        capabilities.put("close", true);
        capabilities.put("getInputStream", true);
        capabilities.put("getOutputStream", true);
        return capabilities;
    }

    public SocketPipe(GATContext gatContext, Socket s) {
        super(gatContext);
        this.s = s;
    }

    public InputStream getInputStream() throws GATInvocationException {
        try {
            return this.s.getInputStream();
        }
        catch (IOException e) {
            throw new GATInvocationException("socketpipe", (Throwable)e);
        }
    }

    public OutputStream getOutputStream() throws GATInvocationException {
        try {
            return this.s.getOutputStream();
        }
        catch (IOException e) {
            throw new GATInvocationException("socketpipe", (Throwable)e);
        }
    }

    public void close() throws GATInvocationException {
        try {
            this.s.close();
        }
        catch (Exception e) {
            throw new GATInvocationException("socketpipe", (Throwable)e);
        }
    }
}

