/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi.streaming;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.FileInputStream;
import org.gridlab.gat.io.FileOutputStream;
import org.gridlab.gat.io.cpi.FileCpi;

public class StreamingFileAdaptor
extends FileCpi {
    public static String getDescription() {
        return "The Streaming File Adaptor only implements the File copy operation, by creating a JavaGAT FileInputStream to read the source, and a JavaGAT FileOutputStream to write the destination.";
    }

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = FileCpi.getSupportedCapabilities();
        capabilities.put("copy", true);
        capabilities.put("exists", true);
        return capabilities;
    }

    public StreamingFileAdaptor(GATContext gatContext, URI location) {
        super(gatContext, location);
    }

    public void copy(URI dest) throws GATInvocationException {
        FilterInputStream dataIn = null;
        DataOutputStream dataOut = null;
        try {
            int len;
            FileInputStream in = GAT.createFileInputStream((GATContext)this.gatContext, (URI)this.location);
            dataIn = new DataInputStream((InputStream)in);
            FileOutputStream out = GAT.createFileOutputStream((GATContext)this.gatContext, (URI)dest);
            dataOut = new DataOutputStream((OutputStream)out);
            byte[] buffer = new byte[1024];
            while ((len = ((DataInputStream)dataIn).read(buffer)) != -1) {
                dataOut.write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            if (e instanceof GATInvocationException) {
                throw (GATInvocationException)e;
            }
            throw new GATInvocationException("StreamingFileAdaptor", (Throwable)e);
        }
        finally {
            if (dataIn != null) {
                try {
                    dataIn.close();
                }
                catch (Throwable throwable) {}
            }
            if (dataOut != null) {
                try {
                    dataOut.flush();
                }
                catch (Throwable throwable) {}
                try {
                    dataOut.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() throws GATInvocationException {
        FileInputStream in = null;
        if (!(this.location.isCompatible("http") || this.location.isCompatible("https") || this.location.isCompatible("ftp"))) {
            throw new UnsupportedOperationException("Not implemented");
        }
        try {
            in = GAT.createFileInputStream((GATContext)this.gatContext, (URI)this.location);
            in.read();
            boolean bl = true;
            return bl;
        }
        catch (GATObjectCreationException e) {
            throw new GATInvocationException("StreamingFileAdaptor" + e.toString("    "));
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

