/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi.localQ;

import java.util.Map;
import java.util.PriorityQueue;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.monitoring.Metric;
import org.gridlab.gat.monitoring.MetricListener;
import org.gridlab.gat.resources.AbstractJobDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.SoftwareDescription;
import org.gridlab.gat.resources.WrapperJobDescription;
import org.gridlab.gat.resources.cpi.ResourceBrokerCpi;
import org.gridlab.gat.resources.cpi.Sandbox;
import org.gridlab.gat.resources.cpi.WrapperJobCpi;
import org.gridlab.gat.resources.cpi.localQ.LocalQJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalQResourceBrokerAdaptor
extends ResourceBrokerCpi
implements Runnable {
    protected static Logger logger = LoggerFactory.getLogger(LocalQResourceBrokerAdaptor.class);
    private static boolean ended = false;
    private final PriorityQueue<LocalQJob> queue;

    public static String getDescription() {
        return "The LocalQ ResourceBroker Adaptor implements the ResourceBroker object using the Java ProcessBuilder facility, but in contrast with the Local ResourceBroker Adaptor, this one has a job queue and can run a number of jobs simultaneously, see the localq.max.concurrent.jobs preference.";
    }

    public static Preferences getSupportedPreferences() {
        Preferences preferences = ResourceBrokerCpi.getSupportedPreferences();
        preferences.put("localq.max.concurrent.jobs", (Object)"<number of cores>");
        return preferences;
    }

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = ResourceBrokerCpi.getSupportedCapabilities();
        capabilities.put("submitJob", true);
        return capabilities;
    }

    public static String[] getSupportedSchemes() {
        return new String[]{"localq", ""};
    }

    private static synchronized boolean hasEnded() {
        return ended;
    }

    public static synchronized void end() {
        ended = true;
    }

    public LocalQResourceBrokerAdaptor(GATContext gatContext, URI brokerURI) throws GATObjectCreationException {
        super(gatContext, brokerURI);
        if (!brokerURI.refersToLocalHost()) {
            throw new GATObjectCreationException("The LocalQResourceBrokerAdaptor doesn't refer to localhost, but to a remote host: " + brokerURI.toString());
        }
        String path = brokerURI.getPath();
        if (path != null && !path.equals("")) {
            throw new GATObjectCreationException("The LocalQResourceBrokerAdaptor does not understand the specified path: " + path);
        }
        this.queue = new PriorityQueue();
        Integer maxConcurrentJobs = (Integer)gatContext.getPreferences().get("localq.max.concurrent.jobs");
        if (maxConcurrentJobs == null) {
            maxConcurrentJobs = Runtime.getRuntime().availableProcessors();
        }
        if (maxConcurrentJobs <= 0) {
            throw new GATObjectCreationException("cannot create local Q resource broker with " + maxConcurrentJobs + " concurrent jobs");
        }
        for (int i = 0; i < maxConcurrentJobs; ++i) {
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job submitJob(AbstractJobDescription abstractDescription, MetricListener listener, String metricDefinitionName) throws GATInvocationException {
        if (!(abstractDescription instanceof JobDescription)) {
            throw new GATInvocationException("can only handle JobDescriptions: " + abstractDescription.getClass());
        }
        JobDescription description = (JobDescription)abstractDescription;
        SoftwareDescription sd = description.getSoftwareDescription();
        if (sd == null) {
            throw new GATInvocationException("The job description does not contain a software description");
        }
        if (description.getProcessCount() != 1) {
            throw new GATInvocationException("Adaptor cannot handle: process count > 1: " + description.getProcessCount());
        }
        if (description.getResourceCount() != 1) {
            throw new GATInvocationException("Adaptor cannot handle: resource count > 1: " + description.getResourceCount());
        }
        String home = System.getProperty("user.home");
        if (home == null) {
            throw new GATInvocationException("local broker could not get user home dir");
        }
        Sandbox sandbox = new Sandbox(this.gatContext, description, "localhost", home, true, true, true, true);
        LocalQJob result = new LocalQJob(this.gatContext, this, description, sandbox);
        LocalQJob job = null;
        if (description instanceof WrapperJobDescription) {
            WrapperJobCpi tmp = new WrapperJobCpi(this.gatContext, (Job)result, listener, metricDefinitionName);
            job = tmp;
            listener = tmp;
        } else {
            job = result;
        }
        if (listener != null && metricDefinitionName != null) {
            Metric metric = result.getMetricDefinitionByName(metricDefinitionName).createMetric(null);
            result.addMetricListener(listener, metric);
        }
        result.setState(Job.JobState.PRE_STAGING);
        sandbox.prestage();
        LocalQResourceBrokerAdaptor localQResourceBrokerAdaptor = this;
        synchronized (localQResourceBrokerAdaptor) {
            this.queue.add(result);
            this.notifyAll();
        }
        return job;
    }

    private synchronized LocalQJob getJob() {
        while (!LocalQResourceBrokerAdaptor.hasEnded()) {
            LocalQJob result = this.queue.poll();
            if (result != null) {
                return result;
            }
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    @Override
    public void run() {
        LocalQJob next;
        while ((next = this.getJob()) != null) {
            try {
                next.run();
                continue;
            }
            catch (Throwable t) {
                logger.error("error while running job: " + t);
                t.printStackTrace();
                continue;
            }
            break;
        }
        return;
    }
}

