/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.domain.User;

public class UserPredicates {
    public static Predicate<User> apiKeyEquals(String apiKey) {
        return new ApiKeyEquals(apiKey);
    }

    public static Predicate<User> accountTypeEquals(Account.Type type) {
        return new AccountTypeEquals(type);
    }

    public static Predicate<User> isUserAccount() {
        return UserPredicates.accountTypeEquals(Account.Type.USER);
    }

    public static Predicate<User> isDomainAdminAccount() {
        return UserPredicates.accountTypeEquals(Account.Type.DOMAIN_ADMIN);
    }

    public static Predicate<User> isAdminAccount() {
        return UserPredicates.accountTypeEquals(Account.Type.ADMIN);
    }

    public static class AccountTypeEquals
    implements Predicate<User> {
        private final Account.Type type;

        public AccountTypeEquals(Account.Type type) {
            this.type = Preconditions.checkNotNull(type, "type");
        }

        @Override
        public boolean apply(User input) {
            return Preconditions.checkNotNull(input, "user").getAccountType() == this.type;
        }

        public String toString() {
            return "accountTypeEquals(" + (Object)((Object)this.type) + ")";
        }
    }

    public static class ApiKeyEquals
    implements Predicate<User> {
        private final String apiKey;

        public ApiKeyEquals(String apiKey) {
            this.apiKey = Preconditions.checkNotNull(apiKey, "apiKey");
        }

        @Override
        public boolean apply(User input) {
            return this.apiKey.equals(Preconditions.checkNotNull(input, "user").getApiKey());
        }

        public String toString() {
            return "apiKeyEquals(" + this.apiKey + ")";
        }
    }
}

