/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Map;
import org.gridlab.gat.FilePrestageException;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.FileInterface;
import org.gridlab.gat.io.cpi.FileCpi;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.SoftwareDescription;
import org.gridlab.gat.resources.cpi.JobCpi;
import org.gridlab.gat.resources.cpi.PostStagedFile;
import org.gridlab.gat.resources.cpi.PostStagedFileSet;
import org.gridlab.gat.resources.cpi.PreStagedFile;
import org.gridlab.gat.resources.cpi.PreStagedFileSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sandbox {
    protected static Logger logger = LoggerFactory.getLogger(Sandbox.class);
    private GATContext gatContext;
    private String authority;
    private String sandbox;
    private URI sandboxURI;
    private PreStagedFileSet pre;
    private PostStagedFileSet post;
    private PostStagedFileSet toWipe;
    private boolean wipePreStaged;
    private boolean wipePostStaged;
    private PostStagedFileSet toDelete;
    private boolean deletePreStaged;
    private boolean deletePostStaged;
    private String sandboxRoot;
    private boolean createSandboxDir;
    private boolean deleteSandboxDir;
    private long preStageTime;
    private long postStageTime;
    private long wipeTime;
    private long deleteTime;
    private String sandboxNameWithoutRoot;

    public Sandbox() {
    }

    public Sandbox(GATContext gatContext, JobDescription jobDescription, String authority, String sandboxRoot, boolean createSandboxDir, boolean preStageStdin, boolean postStageStdout, boolean postStageStderr) throws GATInvocationException {
        Map attr;
        this.gatContext = gatContext;
        this.authority = authority;
        this.createSandboxDir = createSandboxDir;
        this.deleteSandboxDir = true;
        this.sandboxRoot = sandboxRoot;
        String sandboxRootPref = null;
        String sandboxUseRootPref = null;
        String sandboxDeletePref = null;
        String sandboxPrestageStdInPref = null;
        String sandboxPoststageStdOutPref = null;
        String sandboxPoststageStdErrPref = null;
        SoftwareDescription sd = jobDescription.getSoftwareDescription();
        if (sd != null && (attr = sd.getAttributes()) != null) {
            sandboxRootPref = (String)attr.get("sandbox.root");
            sandboxUseRootPref = (String)attr.get("sandbox.useroot");
            sandboxDeletePref = (String)attr.get("sandbox.delete");
            sandboxPrestageStdInPref = (String)attr.get("sandbox.prestage.stdin");
            sandboxPoststageStdOutPref = (String)attr.get("sandbox.poststage.stdout");
            sandboxPoststageStdErrPref = (String)attr.get("sandbox.poststage.stderr");
        }
        if (sandboxRootPref != null) {
            this.sandboxRoot = sandboxRootPref;
            if (logger.isDebugEnabled()) {
                logger.debug("set sandboxRoot to " + sandboxRootPref);
            }
        }
        if (sandboxUseRootPref != null && sandboxUseRootPref.equalsIgnoreCase("true")) {
            this.createSandboxDir = false;
            this.deleteSandboxDir = false;
            this.sandboxNameWithoutRoot = sandboxRootPref;
        }
        if (sandboxDeletePref != null) {
            if (sandboxDeletePref.equalsIgnoreCase("false")) {
                this.deleteSandboxDir = false;
            } else if (sandboxDeletePref.equalsIgnoreCase("true")) {
                this.deleteSandboxDir = true;
            }
        }
        if (sandboxPrestageStdInPref != null) {
            if (sandboxPrestageStdInPref.equalsIgnoreCase("false")) {
                preStageStdin = false;
            } else if (sandboxPrestageStdInPref.equalsIgnoreCase("true")) {
                preStageStdin = true;
            }
        }
        if (sandboxPoststageStdOutPref != null) {
            if (sandboxPoststageStdOutPref.equalsIgnoreCase("false")) {
                postStageStdout = false;
            } else if (sandboxPoststageStdOutPref.equalsIgnoreCase("true")) {
                postStageStdout = true;
            }
        }
        if (sandboxPoststageStdErrPref != null) {
            if (sandboxPoststageStdErrPref.equalsIgnoreCase("false")) {
                postStageStderr = false;
            } else if (sandboxPoststageStdErrPref.equalsIgnoreCase("true")) {
                postStageStderr = true;
            }
        }
        this.initSandbox();
        this.pre = new PreStagedFileSet(gatContext, jobDescription, authority, this.sandbox, preStageStdin);
        this.post = new PostStagedFileSet(gatContext, jobDescription, authority, this.sandbox, postStageStdout, postStageStderr);
        if (sd != null) {
            this.wipePreStaged = sd.wipePreStaged();
            this.wipePostStaged = sd.wipePostStaged();
            this.toWipe = new PostStagedFileSet(gatContext, sd.getWipedFiles(), authority, this.sandbox);
            this.deletePreStaged = sd.deletePreStaged();
            this.deletePostStaged = sd.deletePostStaged();
            this.toDelete = new PostStagedFileSet(gatContext, sd.getDeletedFiles(), authority, this.sandbox);
        }
    }

    private void createSandboxDir(String authority) throws GATInvocationException {
        if (authority == null) {
            throw new FilePrestageException("Sandbox", (Throwable)new GATInvocationException("cannot create a sandbox without a authority"));
        }
        for (int i = 0; i < 10; ++i) {
            this.sandbox = this.getSandboxName();
            try {
                FileInterface f;
                this.sandboxURI = new URI("any://" + authority + "/" + this.sandbox);
                if (logger.isDebugEnabled()) {
                    logger.debug("sandbox dir: " + this.sandboxURI);
                }
                if (!(f = GAT.createFile((GATContext)this.gatContext, (URI)this.sandboxURI).getFileInterface()).mkdir()) continue;
                return;
            }
            catch (Exception e) {
                throw new GATInvocationException("Sandbox", (Throwable)e);
            }
        }
        throw new GATInvocationException("could not create a sandbox directory");
    }

    public void removeSandboxDir() throws GATInvocationException {
        if (this.deleteSandboxDir) {
            URI location = null;
            try {
                location = new URI("any://" + this.authority + "/" + this.sandbox);
            }
            catch (URISyntaxException e) {
                throw new GATInvocationException("sandbox", (Throwable)e);
            }
            FileCpi.recursiveDeleteDirectory(this.gatContext, location);
        }
    }

    private String getSandboxName() {
        if (logger.isInfoEnabled()) {
            logger.info("creating sandbox name, sandbox root = " + this.sandboxRoot);
        }
        String res = "";
        if (this.sandboxRoot != null) {
            res = res + new File(this.sandboxRoot).toURI().getPath() + "/";
        }
        this.sandboxNameWithoutRoot = ".JavaGAT_SANDBOX_" + Math.random();
        res = res + this.sandboxNameWithoutRoot;
        return res;
    }

    private void initSandbox() throws GATInvocationException {
        if (!this.createSandboxDir) {
            if (logger.isInfoEnabled()) {
                logger.info("sandbox: NO SANDBOX");
            }
            this.sandbox = this.sandboxRoot;
            return;
        }
        try {
            this.createSandboxDir(this.authority);
        }
        catch (Exception e) {
            throw new FilePrestageException("sandbox", (Throwable)e);
        }
        if (logger.isInfoEnabled()) {
            logger.info("sandbox: " + this.sandbox);
        }
    }

    private void doPrestage() throws GATInvocationException {
        if (logger.isInfoEnabled()) {
            logger.info("pre stage starting");
        }
        long start = System.currentTimeMillis();
        try {
            this.pre.prestage();
        }
        catch (Exception e) {
            if (logger.isInfoEnabled()) {
                logger.info("prestage FAILED, cleaning up");
            }
            this.removeSandboxDir();
            throw new FilePrestageException("Sandbox", (Throwable)e);
        }
        finally {
            this.preStageTime = System.currentTimeMillis() - start;
        }
        if (logger.isInfoEnabled()) {
            logger.info("pre stage done (SUCCESS)");
        }
    }

    private void wipe() throws GATInvocationException {
        GATInvocationException wipeException = new GATInvocationException();
        if (logger.isInfoEnabled()) {
            logger.info("wipe starting");
        }
        long start = System.currentTimeMillis();
        try {
            if (this.wipePreStaged) {
                this.pre.wipe();
            }
        }
        catch (GATInvocationException e) {
            wipeException.add("sandbox", (Throwable)e);
        }
        try {
            if (this.wipePostStaged) {
                this.post.wipe();
            }
        }
        catch (GATInvocationException e) {
            wipeException.add("sandbox", (Throwable)e);
        }
        try {
            this.toWipe.wipe();
        }
        catch (GATInvocationException e) {
            wipeException.add("sandbox", (Throwable)e);
        }
        if (logger.isInfoEnabled()) {
            logger.info("wipe done " + (wipeException.getNrChildren() == 0 ? "(SUCCESS)" : "(FAILURE)"));
        }
        this.wipeTime = System.currentTimeMillis() - start;
        if (wipeException.getNrChildren() != 0) {
            throw wipeException;
        }
    }

    private void delete() throws GATInvocationException {
        GATInvocationException deleteException = new GATInvocationException();
        if (logger.isInfoEnabled()) {
            logger.info("delete starting");
        }
        long start = System.currentTimeMillis();
        if (this.deletePreStaged) {
            try {
                this.pre.delete();
            }
            catch (GATInvocationException e) {
                deleteException.add("delete", (Throwable)e);
            }
        }
        if (this.deletePostStaged) {
            try {
                this.post.delete();
            }
            catch (GATInvocationException e) {
                deleteException.add("delete", (Throwable)e);
            }
        }
        try {
            this.toDelete.delete();
        }
        catch (GATInvocationException e) {
            deleteException.add("delete", (Throwable)e);
        }
        if (logger.isInfoEnabled()) {
            logger.info("delete done " + (deleteException.getNrChildren() == 0 ? "(SUCCESS)" : "(FAILURE)"));
        }
        this.deleteTime = System.currentTimeMillis() - start;
        if (deleteException.getNrChildren() != 0) {
            throw deleteException;
        }
    }

    public void prestage() throws GATInvocationException {
        this.doPrestage();
    }

    public void retrieveAndCleanup(JobCpi j) {
        GATInvocationException poststageException = null;
        GATInvocationException wipeException = null;
        GATInvocationException deleteException = null;
        GATInvocationException removeSandboxException = null;
        if (this.gatContext == null) {
            this.gatContext = GAT.getDefaultGATContext();
            if (this.post != null) {
                this.post.setGatContext(this.gatContext);
            }
            if (this.pre != null) {
                this.pre.setGatContext(this.gatContext);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("post stage starting");
        }
        long start = System.currentTimeMillis();
        try {
            this.post.poststage();
        }
        catch (GATInvocationException e) {
            poststageException = e;
        }
        if (logger.isInfoEnabled()) {
            logger.info("post stage done " + (poststageException == null ? "(SUCCESS)" : "(FAILURE)"));
            logger.info("poststage exception: " + (Object)((Object)poststageException));
        }
        this.postStageTime = System.currentTimeMillis() - start;
        try {
            this.wipe();
        }
        catch (GATInvocationException e) {
            wipeException = e;
        }
        try {
            this.delete();
        }
        catch (GATInvocationException e) {
            deleteException = e;
        }
        if (this.deleteSandboxDir) {
            if (logger.isInfoEnabled()) {
                logger.info("removing sandbox dir: any://" + this.authority + "/" + this.sandbox);
            }
            try {
                this.removeSandboxDir();
            }
            catch (GATInvocationException e) {
                removeSandboxException = e;
            }
            if (logger.isInfoEnabled()) {
                logger.info("removing sandbox dir done " + (removeSandboxException == null ? "(SUCCESS)" : "(FAILURE)"));
            }
        } else if (logger.isInfoEnabled()) {
            logger.info("sandbox persists at: any://" + this.authority + "/" + this.sandbox);
        }
        if (j != null) {
            j.deleteException = deleteException;
            j.wipeException = wipeException;
            j.postStageException = poststageException;
            j.removeSandboxException = removeSandboxException;
        }
    }

    public String getSandbox() {
        return this.sandboxNameWithoutRoot;
    }

    public String getSandboxPath() {
        return this.sandbox;
    }

    public URI getSandboxURI() {
        return this.sandboxURI;
    }

    public org.gridlab.gat.io.File getResolvedExecutable() {
        PreStagedFile f = this.pre.getExecutable();
        if (f == null) {
            return null;
        }
        return f.getResolvedDest();
    }

    public org.gridlab.gat.io.File getResolvedStdin() {
        PreStagedFile f = this.pre.getStdin();
        if (f == null) {
            return null;
        }
        return f.getResolvedDest();
    }

    public org.gridlab.gat.io.File getResolvedStdout() {
        PostStagedFile f = this.post.getStdout();
        if (f == null) {
            return null;
        }
        return f.getResolvedSrc();
    }

    public org.gridlab.gat.io.File getResolvedStderr() {
        PostStagedFile f = this.post.getStderr();
        if (f == null) {
            return null;
        }
        return f.getResolvedSrc();
    }

    public URI getRelativeStdin() {
        PreStagedFile f = this.pre.getStdin();
        if (f == null) {
            return null;
        }
        return f.relativeURI;
    }

    public URI getRelativeStdout() {
        PostStagedFile f = this.post.getStdout();
        if (f == null) {
            return null;
        }
        return f.relativeURI;
    }

    public URI getRelativeStderr() {
        PostStagedFile f = this.post.getStderr();
        if (f == null) {
            return null;
        }
        return f.relativeURI;
    }

    public String getAuthority() {
        return this.authority;
    }

    public PreStagedFileSet getPrestagedFileSet() {
        return this.pre;
    }

    public PostStagedFileSet getPostStagedFileSet() {
        return this.post;
    }

    public long getDeleteTime() {
        return this.deleteTime;
    }

    public long getPostStageTime() {
        return this.postStageTime;
    }

    public long getPreStageTime() {
        return this.preStageTime;
    }

    public long getWipeTime() {
        return this.wipeTime;
    }

    public boolean isCreateSandboxDir() {
        return this.createSandboxDir;
    }

    public void setCreateSandboxDir(boolean createSandboxDir) {
        this.createSandboxDir = createSandboxDir;
    }

    public PostStagedFileSet getPost() {
        return this.post;
    }

    public void setPost(PostStagedFileSet post) {
        this.post = post;
    }

    public PreStagedFileSet getPre() {
        return this.pre;
    }

    public void setPre(PreStagedFileSet pre) {
        this.pre = pre;
    }

    public String getSandboxRoot() {
        return this.sandboxRoot;
    }

    public void setSandboxRoot(String sandboxRoot) {
        this.sandboxRoot = sandboxRoot;
    }

    public void setDeleteTime(long deleteTime) {
        this.deleteTime = deleteTime;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public void setPostStageTime(long postStageTime) {
        this.postStageTime = postStageTime;
    }

    public void setPreStageTime(long preStageTime) {
        this.preStageTime = preStageTime;
    }

    public void setSandbox(String sandbox) {
        this.sandbox = sandbox;
    }

    public void setWipeTime(long wipeTime) {
        this.wipeTime = wipeTime;
    }

    public boolean isDeletePostStaged() {
        return this.deletePostStaged;
    }

    public void setDeletePostStaged(boolean deletePostStaged) {
        this.deletePostStaged = deletePostStaged;
    }

    public boolean isDeletePreStaged() {
        return this.deletePreStaged;
    }

    public void setDeletePreStaged(boolean deletePreStaged) {
        this.deletePreStaged = deletePreStaged;
    }

    public PostStagedFileSet getToDelete() {
        return this.toDelete;
    }

    public void setToDelete(PostStagedFileSet toDelete) {
        this.toDelete = toDelete;
    }

    public PostStagedFileSet getToWipe() {
        return this.toWipe;
    }

    public void setToWipe(PostStagedFileSet toWipe) {
        this.toWipe = toWipe;
    }

    public boolean isWipePostStaged() {
        return this.wipePostStaged;
    }

    public void setWipePostStaged(boolean wipePostStaged) {
        this.wipePostStaged = wipePostStaged;
    }

    public boolean isWipePreStaged() {
        return this.wipePreStaged;
    }

    public void setWipePreStaged(boolean wipePreStaged) {
        this.wipePreStaged = wipePreStaged;
    }

    public void setDeleteSandboxDir(boolean b) {
        this.deleteSandboxDir = b;
    }

    public boolean getDeleteSandboxDir() {
        return this.deleteSandboxDir;
    }

    public void setContext(GATContext context) {
        this.gatContext = context;
        if (this.post != null) {
            this.post.setGatContext(this.gatContext);
        }
        if (this.pre != null) {
            this.pre.setGatContext(this.gatContext);
        }
        if (this.toWipe != null) {
            this.toWipe.setGatContext(this.gatContext);
        }
    }
}

