/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.chef;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.domain.chef.DataBag;
import org.jclouds.scriptbuilder.domain.chef.Role;
import org.jclouds.scriptbuilder.domain.chef.RunList;

public class ChefSolo
implements Statement {
    public static final String DEFAULT_SOLO_PATH = "/var/chef";
    private String fileCachePath;
    private String rolePath;
    private String databagPath;
    private List<String> cookbookPath;
    private Optional<String> cookbooksArchiveLocation;
    private Optional<String> jsonAttributes;
    private Optional<String> group;
    private Optional<Integer> interval;
    private Optional<String> logLevel;
    private Optional<String> logFile;
    private Optional<String> nodeName;
    private Optional<Integer> splay;
    private Optional<String> user;
    private Optional<List<Role>> roles;
    private Optional<List<DataBag>> databags;
    private RunList runlist;

    public static Builder builder() {
        return new Builder();
    }

    protected ChefSolo(Optional<String> fileCachePath, Optional<String> rolePath, Optional<String> databagPath, Optional<ImmutableList<String>> cookbookPath, Optional<String> cookbooksArchiveLocation, Optional<String> jsonAttributes, Optional<String> group, Optional<Integer> interval, Optional<String> logLevel, Optional<String> logFile, Optional<String> nodeName, Optional<Integer> splay, Optional<String> user, Optional<List<Role>> roles, Optional<List<DataBag>> databags, Optional<RunList> runlist) {
        this.fileCachePath = Preconditions.checkNotNull(fileCachePath, "fileCachePath must be set").or(DEFAULT_SOLO_PATH);
        this.rolePath = Preconditions.checkNotNull(rolePath, "rolePath must be set").or(this.fileCachePath + "/roles");
        this.databagPath = Preconditions.checkNotNull(databagPath, "databagPath must be set").or(this.fileCachePath + "/data_bags");
        this.cookbooksArchiveLocation = Preconditions.checkNotNull(cookbooksArchiveLocation, "cookbooksArchiveLocation must be set");
        this.jsonAttributes = Preconditions.checkNotNull(jsonAttributes, "jsonAttributes must be set");
        this.group = Preconditions.checkNotNull(group, "group must be set");
        this.interval = Preconditions.checkNotNull(interval, "interval must be set");
        this.logLevel = Preconditions.checkNotNull(logLevel, "logLevel must be set");
        this.logFile = Preconditions.checkNotNull(logFile, "logFile must be set");
        this.nodeName = Preconditions.checkNotNull(nodeName, "nodeName must be set");
        this.splay = Preconditions.checkNotNull(splay, "splay must be set");
        this.user = Preconditions.checkNotNull(user, "user must be set");
        this.roles = Preconditions.checkNotNull(roles, "roles must be set");
        this.databags = Preconditions.checkNotNull(databags, "databags must be set");
        this.runlist = Preconditions.checkNotNull(runlist, "runlist must be set").or(RunList.builder().build());
        this.user = Preconditions.checkNotNull(user, "user must be set");
        this.cookbookPath = !Preconditions.checkNotNull(cookbookPath, "cookbookPath must be set").isPresent() || cookbookPath.get().isEmpty() ? ImmutableList.of(this.fileCachePath + "/cookbooks") : ImmutableList.copyOf((Collection)cookbookPath.get());
    }

    @Override
    public String render(OsFamily family) {
        if (family == OsFamily.WINDOWS) {
            throw new UnsupportedOperationException("windows not yet implemented");
        }
        ImmutableList.Builder<Statement> statements = ImmutableList.builder();
        this.checkChefIsInstalled(statements);
        this.createSoloConfiguration(statements);
        this.createRolesIfNecessary(statements);
        this.createDatabagsIfNecessary(statements);
        this.createNodeConfiguration(statements);
        ImmutableMap.Builder<String, String> options = ImmutableMap.builder();
        options.put("-c", this.fileCachePath + "/solo.rb");
        options.put("-j", this.fileCachePath + "/node.json");
        options.put("-N", this.nodeName.or("`hostname`"));
        if (this.group.isPresent()) {
            options.put("-g", this.group.get());
        }
        if (this.interval.isPresent()) {
            options.put("-i", this.interval.get().toString());
        }
        if (this.logLevel.isPresent()) {
            options.put("-l", this.logLevel.get());
        }
        if (this.logFile.isPresent()) {
            options.put("-L", this.logFile.get());
        }
        if (this.cookbooksArchiveLocation.isPresent()) {
            options.put("-r", this.cookbooksArchiveLocation.get());
        }
        if (this.splay.isPresent()) {
            options.put("-s", this.splay.get().toString());
        }
        if (this.user.isPresent()) {
            options.put("-u", this.user.get());
        }
        String strOptions = Joiner.on(' ').withKeyValueSeparator(" ").join(options.build());
        statements.add((Object)Statements.exec(String.format("chef-solo %s", strOptions)));
        return new StatementList(statements.build()).render(family);
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return Collections.emptyList();
    }

    private void checkChefIsInstalled(ImmutableList.Builder<Statement> statements) {
        statements.add((Object)Statements.exec("if ! hash chef-solo 2>/dev/null; then"));
        statements.add((Object)Statements.exec("echo 'chef-solo not found. Please, install Chef first'"));
        statements.add((Object)Statements.exec("exit 1"));
        statements.add((Object)Statements.exec("fi"));
    }

    @VisibleForTesting
    void createSoloConfiguration(ImmutableList.Builder<Statement> statements) {
        statements.add((Object)Statements.exec("{md} " + this.fileCachePath));
        for (String path : this.cookbookPath) {
            statements.add((Object)Statements.exec("{md} " + path));
        }
        String cookbookPathJoined = Joiner.on(',').join(Iterables.transform(this.cookbookPath, ChefSolo.quote()));
        statements.add((Object)Statements.createOrOverwriteFile(this.fileCachePath + "/solo.rb", ImmutableSet.of("file_cache_path \"" + this.fileCachePath + "\"", "cookbook_path [" + cookbookPathJoined + "]", "role_path \"" + this.rolePath + "\"", "data_bag_path \"" + this.databagPath + "\"")));
    }

    @VisibleForTesting
    void createNodeConfiguration(ImmutableList.Builder<Statement> statements) {
        StringBuilder json = new StringBuilder();
        if (this.jsonAttributes.isPresent()) {
            String attributes = this.jsonAttributes.get();
            json.append(attributes, 0, attributes.lastIndexOf(125));
            json.append(",");
        } else {
            json.append("{");
        }
        json.append("\"run_list\":");
        json.append(this.runlist.toString());
        json.append("}");
        statements.add((Object)Statements.createOrOverwriteFile(this.fileCachePath + "/node.json", ImmutableSet.of(json.toString())));
    }

    @VisibleForTesting
    void createRolesIfNecessary(ImmutableList.Builder<Statement> statements) {
        if (this.roles.isPresent() && !this.roles.get().isEmpty()) {
            statements.add((Object)Statements.exec("{md} " + this.rolePath));
            for (Role role : this.roles.get()) {
                statements.add((Object)Statements.createOrOverwriteFile(this.rolePath + "/" + role.getName() + ".json", ImmutableSet.of(role.toJsonString())));
            }
        }
    }

    @VisibleForTesting
    void createDatabagsIfNecessary(ImmutableList.Builder<Statement> statements) {
        if (this.databags.isPresent() && !this.databags.get().isEmpty()) {
            statements.add((Object)Statements.exec("{md} " + this.databagPath));
            for (DataBag databag : this.databags.get()) {
                String databagFolder = this.databagPath + "/" + databag.getName();
                statements.add((Object)Statements.exec("{md} " + databagFolder));
                for (Map.Entry<String, String> item : databag.getItems().entrySet()) {
                    statements.add((Object)Statements.createOrOverwriteFile(databagFolder + "/" + item.getKey() + ".json", ImmutableSet.of(item.getValue())));
                }
            }
        }
    }

    private static Function<String, String> quote() {
        return new Function<String, String>(){

            @Override
            public String apply(String input) {
                return "\"" + input + "\"";
            }
        };
    }

    public static class Builder {
        private String fileCachePath = "/var/chef";
        private String rolePath;
        private String databagPath;
        private ImmutableList.Builder<String> cookbookPath = ImmutableList.builder();
        private String cookbooksArchiveLocation;
        private String jsonAttributes;
        private String group;
        private Integer interval;
        private String logLevel;
        private String logFile;
        private String nodeName;
        private Integer splay;
        private String user;
        private List<Role> roles = Lists.newArrayList();
        private List<DataBag> databags = Lists.newArrayList();
        private RunList runlist;

        public Builder fileCachePath(String fileCachePath) {
            this.fileCachePath = Preconditions.checkNotNull(fileCachePath, "fileCachePath");
            return this;
        }

        public Builder rolePath(String rolePath) {
            this.rolePath = Preconditions.checkNotNull(rolePath, "rolePath");
            return this;
        }

        public Builder dataBagPath(String dataBagPath) {
            this.databagPath = Preconditions.checkNotNull(dataBagPath, "dataBagPath");
            return this;
        }

        public Builder cookbookPath(String cookbookPath) {
            this.cookbookPath.add((Object)Preconditions.checkNotNull(cookbookPath, "cookbookPath"));
            return this;
        }

        public Builder cookbookPaths(Iterable<String> cookbookPaths) {
            this.cookbookPath.addAll((Iterable)Preconditions.checkNotNull(cookbookPaths, "cookbookPath"));
            return this;
        }

        public Builder cookbooksArchiveLocation(String cookbooksArchiveLocation) {
            this.cookbooksArchiveLocation = Preconditions.checkNotNull(cookbooksArchiveLocation, "cookbooksArchiveLocation");
            return this;
        }

        public Builder jsonAttributes(String jsonAttributes) {
            this.jsonAttributes = Preconditions.checkNotNull(jsonAttributes, "jsonAttributes");
            return this;
        }

        public Builder group(String group) {
            this.group = Preconditions.checkNotNull(group, "group");
            return this;
        }

        public Builder interval(Integer interval) {
            this.interval = Preconditions.checkNotNull(interval, "interval");
            return this;
        }

        public Builder logLevel(String logLevel) {
            this.logLevel = Preconditions.checkNotNull(logLevel, "logLevel");
            return this;
        }

        public Builder logFile(String logFile) {
            this.logFile = Preconditions.checkNotNull(logFile, "logFile");
            return this;
        }

        public Builder nodeName(String nodeName) {
            this.nodeName = Preconditions.checkNotNull(nodeName, "nodeName");
            return this;
        }

        public Builder splay(Integer splay) {
            this.splay = Preconditions.checkNotNull(splay, "splay");
            return this;
        }

        public Builder user(String user) {
            this.user = Preconditions.checkNotNull(user, "user");
            return this;
        }

        public Builder defineRole(Role role) {
            this.roles.add(Preconditions.checkNotNull(role, "role"));
            return this;
        }

        public Builder defineRoles(Iterable<Role> roles) {
            this.roles = ImmutableList.copyOf(Preconditions.checkNotNull(roles, "roles"));
            return this;
        }

        public Builder defineDataBag(DataBag dataBag) {
            this.databags.add(Preconditions.checkNotNull(dataBag, "dataBag"));
            return this;
        }

        public Builder defineDataBags(Iterable<DataBag> databags) {
            this.databags = ImmutableList.copyOf(Preconditions.checkNotNull(databags, "databags"));
            return this;
        }

        public Builder runlist(RunList runlist) {
            this.runlist = Preconditions.checkNotNull(runlist, "runlist");
            return this;
        }

        public ChefSolo build() {
            return new ChefSolo(Optional.of(this.fileCachePath), Optional.fromNullable(this.rolePath), Optional.fromNullable(this.databagPath), Optional.of(this.cookbookPath.build()), Optional.fromNullable(this.cookbooksArchiveLocation), Optional.fromNullable(this.jsonAttributes), Optional.fromNullable(this.group), Optional.fromNullable(this.interval), Optional.fromNullable(this.logLevel), Optional.fromNullable(this.logFile), Optional.fromNullable(this.nodeName), Optional.fromNullable(this.splay), Optional.fromNullable(this.user), Optional.of(this.roles), Optional.of(this.databags), Optional.fromNullable(this.runlist));
        }
    }
}

