/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.commands;

import es.bsc.comm.Connection;
import es.bsc.compss.nio.NIOAgent;
import es.bsc.compss.nio.NIOTaskResult;
import es.bsc.compss.nio.commands.Command;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class CommandNIOTaskDone
extends Command
implements Externalizable {
    private boolean successful;
    private NIOTaskResult tr;

    public CommandNIOTaskDone() {
    }

    public CommandNIOTaskDone(NIOAgent ng, NIOTaskResult tr, boolean successful) {
        super(ng);
        this.tr = tr;
        this.successful = successful;
    }

    @Override
    public Command.CommandType getType() {
        return Command.CommandType.TASK_DONE;
    }

    @Override
    public void handle(Connection c) {
        NIOAgent nm = this.agent;
        nm.receivedNIOTaskDone(c, this.tr, this.successful);
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.successful = in.readBoolean();
        this.tr = (NIOTaskResult)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.successful);
        out.writeObject(this.tr);
    }

    public String toString() {
        return "Job" + this.tr.getJobId() + " finishes " + (this.successful ? "properly" : "with some errors");
    }
}

