/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.config;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Atomics;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.ec2.compute.config.EC2BindComputeStrategiesByClass;
import org.jclouds.ec2.compute.config.EC2BindComputeSuppliersByClass;
import org.jclouds.ec2.compute.config.EC2ComputeServiceDependenciesModule;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.loaders.RegionAndIdToImage;
import org.jclouds.ec2.compute.suppliers.RegionAndNameToImageSupplier;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.suppliers.SetAndThrowAuthorizationExceptionSupplier;

public class EC2ComputeServiceContextModule
extends BaseComputeServiceContextModule {
    @Override
    protected void configure() {
        this.installDependencies();
        this.install(new EC2BindComputeStrategiesByClass());
        this.install(new EC2BindComputeSuppliersByClass());
        super.configure();
    }

    protected void installDependencies() {
        this.install(new EC2ComputeServiceDependenciesModule());
    }

    @Override
    protected boolean shouldEagerlyParseImages(Injector injector) {
        String[] amiOwners = injector.getInstance(Key.get(String[].class, (Annotation)Names.named("jclouds.ec2.ami-owners")));
        return amiOwners.length > 0;
    }

    @Override
    protected Supplier<Set<? extends Image>> supplyNonParsingImageCache(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, Supplier<Set<? extends Image>> imageSupplier, Injector injector) {
        final Supplier<LoadingCache<RegionAndName, ? extends Image>> cache = injector.getInstance(Key.get(new TypeLiteral<Supplier<LoadingCache<RegionAndName, ? extends Image>>>(){}));
        return new Supplier<Set<? extends Image>>(){

            @Override
            public Set<? extends Image> get() {
                return ImmutableSet.copyOf(((LoadingCache)cache.get()).asMap().values());
            }
        };
    }

    @Provides
    @Singleton
    protected Supplier<LoadingCache<RegionAndName, ? extends Image>> provideRegionAndNameToImageSupplierCache(RegionAndNameToImageSupplier supplier) {
        return supplier;
    }

    @Provides
    @Singleton
    protected Supplier<CacheLoader<RegionAndName, Image>> provideRegionAndNameToImageSupplierCacheLoader(final RegionAndIdToImage delegate) {
        return Suppliers.ofInstance(new CacheLoader<RegionAndName, Image>(){
            private final AtomicReference<AuthorizationException> authException = Atomics.newReference();

            @Override
            public Image load(final RegionAndName key) throws Exception {
                Supplier<Image> rawSupplier = new Supplier<Image>(){

                    @Override
                    public Image get() {
                        try {
                            return delegate.load(key);
                        }
                        catch (ExecutionException e) {
                            throw Throwables.propagate(e);
                        }
                    }
                };
                return new SetAndThrowAuthorizationExceptionSupplier<Image>(rawSupplier, this.authException).get();
            }
        });
    }

    @Provides
    @Singleton
    @Named(value="jclouds.ec2.ami-owners")
    String[] amiOwners(@Named(value="jclouds.ec2.ami-owners") String amiOwners) {
        if (amiOwners.trim().equals("")) {
            return new String[0];
        }
        return Iterables.toArray(Splitter.on(',').split(amiOwners), String.class);
    }

    @Override
    protected Optional<ImageExtension> provideImageExtension(Injector i) {
        return Optional.of(i.getInstance(ImageExtension.class));
    }

    @Override
    protected Optional<SecurityGroupExtension> provideSecurityGroupExtension(Injector i) {
        return Optional.of(i.getInstance(SecurityGroupExtension.class));
    }
}

