/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.Image;
import org.jclouds.ec2.options.DescribeImagesOptions;
import org.jclouds.logging.Logger;

@Singleton
public class DescribeImagesParallel
implements Function<Iterable<Map.Entry<String, DescribeImagesOptions>>, Iterable<? extends Image>> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final EC2Api api;
    final ListeningExecutorService userExecutor;

    @Inject
    public DescribeImagesParallel(EC2Api api, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.api = api;
        this.userExecutor = userExecutor;
    }

    @Override
    public Iterable<? extends Image> apply(Iterable<Map.Entry<String, DescribeImagesOptions>> queries) {
        ListenableFuture<List<? extends Set<? extends Image>>> futures = Futures.allAsList(Iterables.transform(queries, new Function<Map.Entry<String, DescribeImagesOptions>, ListenableFuture<? extends Set<? extends Image>>>(){

            @Override
            public ListenableFuture<Set<? extends Image>> apply(final Map.Entry<String, DescribeImagesOptions> from) {
                return DescribeImagesParallel.this.userExecutor.submit(new Callable<Set<? extends Image>>(){

                    @Override
                    public Set<? extends Image> call() throws Exception {
                        return DescribeImagesParallel.this.api.getAMIApi().get().describeImagesInRegion((String)from.getKey(), (DescribeImagesOptions)from.getValue());
                    }
                });
            }
        }));
        this.logger.trace("amis", new Object[0]);
        return Iterables.concat((Iterable)Futures.getUnchecked(futures));
    }
}

