/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.domain.Statement;

public class LiteralStatement
implements Statement {
    private String statement;

    public LiteralStatement(String statement) {
        this.statement = Preconditions.checkNotNull(statement, "statement");
    }

    @Override
    public String render(OsFamily family) {
        return this.statement + ShellToken.LF.to(family);
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return ImmutableList.of();
    }

    public int hashCode() {
        return Objects.hashCode(this.statement);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LiteralStatement)) {
            return false;
        }
        LiteralStatement other = (LiteralStatement)LiteralStatement.class.cast(obj);
        return Objects.equal(this.statement, other.statement);
    }

    public String toString() {
        return this.statement + "{lf}";
    }
}

