/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class VirtualGuestAttribute {
    private final String value;

    @ConstructorProperties(value={"value"})
    public VirtualGuestAttribute(String value) {
        this.value = Preconditions.checkNotNull(value, "value");
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualGuestAttribute that = (VirtualGuestAttribute)o;
        return Objects.equal(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("value", this.value).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return VirtualGuestAttribute.builder().fromVirtualGuestAttribute(this);
    }

    public static class Builder {
        private String value;

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public VirtualGuestAttribute build() {
            return new VirtualGuestAttribute(this.value);
        }

        public Builder fromVirtualGuestAttribute(VirtualGuestAttribute in) {
            return this.value(in.getValue());
        }
    }
}

