/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi.lsf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.gridlab.gat.CommandNotFoundException;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.engine.util.ProcessBundle;
import org.gridlab.gat.engine.util.StreamForwarder;
import org.gridlab.gat.io.FileInputStream;
import org.gridlab.gat.io.FileOutputStream;
import org.gridlab.gat.monitoring.Metric;
import org.gridlab.gat.monitoring.MetricListener;
import org.gridlab.gat.resources.AbstractJobDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.SoftwareDescription;
import org.gridlab.gat.resources.WrapperJobDescription;
import org.gridlab.gat.resources.cpi.ResourceBrokerCpi;
import org.gridlab.gat.resources.cpi.Sandbox;
import org.gridlab.gat.resources.cpi.WrapperJobCpi;
import org.gridlab.gat.resources.cpi.lsf.LsfJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LsfResourceBrokerAdaptor
extends ResourceBrokerCpi {
    public static String LSB_JOBID = null;
    public static String LSB_JOBINDEX = null;
    public static String LSB_JOBRES_CALLBACK = null;
    public static String LSB_MCPU_HOSTS = null;
    public static String LSF_BINDIR = null;
    protected static Logger logger = LoggerFactory.getLogger(LsfResourceBrokerAdaptor.class);

    public static String getDescription() {
        return "The LSF ResourceBroker Adaptor implements the ResourceBroker using the Java ProcessBuilder facility.";
    }

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = ResourceBrokerCpi.getSupportedCapabilities();
        capabilities.put("beginMultiJob", true);
        capabilities.put("endMultiJob", true);
        capabilities.put("submitJob", true);
        return capabilities;
    }

    public static String[] getSupportedSchemes() {
        return new String[]{"lsf", "fork", ""};
    }

    public LsfResourceBrokerAdaptor(GATContext gatContext, URI brokerURI) throws GATObjectCreationException {
        super(gatContext, brokerURI);
        String path = brokerURI.getUnresolvedPath();
        if (path != null && !path.equals("")) {
            throw new GATObjectCreationException("The LsfResourceBrokerAdaptor does not understand the specified path: " + path);
        }
    }

    public Job submitJob(AbstractJobDescription abstractDescription, MetricListener listener, String metricDefinitionName) throws GATInvocationException {
        StreamForwarder forwarder;
        if (!(abstractDescription instanceof JobDescription)) {
            throw new GATInvocationException("can only handle JobDescriptions: " + abstractDescription.getClass());
        }
        JobDescription description = (JobDescription)abstractDescription;
        SoftwareDescription sd = description.getSoftwareDescription();
        if (sd == null) {
            throw new GATInvocationException("The job description does not contain a software description");
        }
        if (description.getProcessCount() < 1) {
            throw new GATInvocationException("Adaptor cannot handle: process count < 1: " + description.getProcessCount());
        }
        if (description.getResourceCount() != 1) {
            throw new GATInvocationException("Adaptor cannot handle: resource count > 1: " + description.getResourceCount());
        }
        String home = System.getProperty("user.home");
        if (home == null) {
            throw new GATInvocationException("lsf broker could not get user home dir");
        }
        Sandbox sandbox = new Sandbox(this.gatContext, description, "localhost", home, true, true, false, false);
        LsfJob lsfJob = new LsfJob(this.gatContext, description, sandbox);
        LsfJob job = null;
        if (description instanceof WrapperJobDescription) {
            WrapperJobCpi tmp = new WrapperJobCpi(this.gatContext, (Job)lsfJob, listener, metricDefinitionName);
            listener = tmp;
            job = tmp;
        } else {
            job = lsfJob;
        }
        if (listener != null && metricDefinitionName != null) {
            Metric metric = lsfJob.getMetricDefinitionByName(metricDefinitionName).createMetric(null);
            lsfJob.addMetricListener(listener, metric);
        }
        lsfJob.setState(Job.JobState.PRE_STAGING);
        lsfJob.waitForTrigger(Job.JobState.PRE_STAGING);
        sandbox.prestage();
        String exe = sandbox.getResolvedExecutable() != null ? sandbox.getResolvedExecutable().getPath() : this.getExecutable(description);
        String[] args = this.getArgumentsArray(description);
        File f = new File(sandbox.getSandboxPath());
        if (!f.exists()) {
            throw new GATInvocationException("Unable to find directory " + f.getAbsolutePath());
        }
        Map env = sd.getEnvironment();
        String host = this.brokerURI.getHost();
        String blExe = this.getBlaunchCommand();
        String[] blArgs = this.getBlaunchArgs(host, exe, args);
        ProcessBundle bundle = new ProcessBundle(description.getProcessCount(), blExe, blArgs, f, env);
        lsfJob.setSubmissionTime();
        lsfJob.setState(Job.JobState.SCHEDULED);
        try {
            lsfJob.setState(Job.JobState.RUNNING);
            lsfJob.waitForTrigger(Job.JobState.RUNNING);
            lsfJob.setStartTime();
            bundle.startBundle();
            lsfJob.setProcess(bundle);
        }
        catch (IOException e) {
            throw new CommandNotFoundException("LsfResourceBrokerAdaptor", (Throwable)e);
        }
        if (!sd.streamingStderrEnabled()) {
            try {
                if (sd.getStderr() != null) {
                    FileOutputStream err = GAT.createFileOutputStream((GATContext)this.gatContext, (org.gridlab.gat.io.File)sd.getStderr());
                    forwarder = new StreamForwarder(bundle.getStderr(), (OutputStream)err, sd.getExecutable() + " [stderr]");
                    lsfJob.setErrorStream(forwarder);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Created stderr forwarder to file " + sd.getStderr());
                    }
                } else {
                    new StreamForwarder(bundle.getStderr(), null, sd.getExecutable() + " [stderr]");
                }
            }
            catch (GATObjectCreationException e) {
                throw new GATInvocationException("Unable to create file output stream for stderr!", (Throwable)e);
            }
        }
        if (!sd.streamingStdoutEnabled()) {
            try {
                if (sd.getStdout() != null) {
                    FileOutputStream out = GAT.createFileOutputStream((GATContext)this.gatContext, (org.gridlab.gat.io.File)sd.getStdout());
                    forwarder = new StreamForwarder(bundle.getStdout(), (OutputStream)out, sd.getExecutable() + " [stdout]");
                    lsfJob.setOutputStream(forwarder);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Created stdout forwarder to file " + sd.getStdout());
                    }
                } else {
                    new StreamForwarder(bundle.getStdout(), null, sd.getExecutable() + " [stdout]");
                }
            }
            catch (GATObjectCreationException e) {
                throw new GATInvocationException("Unable to create file output stream for stdout!", (Throwable)e);
            }
        }
        if (!sd.streamingStdinEnabled() && sd.getStdin() != null) {
            try {
                FileInputStream in = GAT.createFileInputStream((GATContext)this.gatContext, (org.gridlab.gat.io.File)sd.getStdin());
                bundle.setStdin(sd.getExecutable(), (InputStream)in);
            }
            catch (GATObjectCreationException e) {
                throw new GATInvocationException("Unable to create file input stream for stdin!", (Throwable)e);
            }
        }
        lsfJob.monitorState();
        return job;
    }

    private void prepareBLaunchEnv(Map<String, Object> env) throws GATInvocationException {
        if (env != null) {
            LSB_JOBID = (String)env.get("LSB_JOBID");
        }
        if (LSB_JOBID == null) {
            LSB_JOBID = System.getenv("LSB_JOBID");
        }
        if (LSB_JOBID == null) {
            throw new GATInvocationException("LSB_JOBID environment varible not defined");
        }
        if (env != null) {
            LSB_JOBINDEX = (String)env.get("LSB_JOBINDEX");
        }
        if (LSB_JOBINDEX == null) {
            LSB_JOBINDEX = System.getenv("LSB_JOBINDEX");
        }
        if (LSB_JOBINDEX == null) {
            throw new GATInvocationException("LSB_JOBINDEX environment varible not defined");
        }
        if (env != null) {
            LSB_JOBRES_CALLBACK = (String)env.get("LSB_JOBRES_CALLBACK");
        }
        if (LSB_JOBRES_CALLBACK == null) {
            LSB_JOBRES_CALLBACK = System.getenv("LSB_JOBRES_CALLBACK");
        }
        if (LSB_JOBRES_CALLBACK == null) {
            throw new GATInvocationException("LSB_JOBRES_CALLBACK environment varible not defined");
        }
        if (env != null) {
            LSB_MCPU_HOSTS = (String)env.get("LSB_MCPU_HOSTS");
        }
        if (LSB_MCPU_HOSTS == null) {
            LSB_MCPU_HOSTS = System.getenv("LSB_MCPU_HOSTS");
        }
        if (LSB_MCPU_HOSTS == null) {
            throw new GATInvocationException("LSB_MCPU_HOSTS environment varible not defined");
        }
        if (env != null) {
            LSF_BINDIR = (String)env.get("LSF_BINDIR");
        }
        if (LSF_BINDIR == null) {
            LSF_BINDIR = System.getenv("LSF_BINDIR");
        }
        if (LSF_BINDIR == null) {
            throw new GATInvocationException("LSF_BINDIR environment varible not defined");
        }
    }

    private String getBlaunchCommand() {
        return "/broad/software/free/Linux/redhat_6_x86_64/pkgs/openmpi_uge-1.10.1/bin/mpirun";
    }

    private String[] getBlaunchArgs(String host, String exe, String[] args) {
        String[] argsTmp = new String[args.length + 2];
        argsTmp[0] = "--host " + host + ".broadinstitute.org";
        argsTmp[1] = exe;
        for (int i = 0; i < args.length; ++i) {
            argsTmp[2 + i] = args[i];
        }
        return argsTmp;
    }
}

