/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.ec2.xml.SecurityGroupHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DescribeSecurityGroupsResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Set<SecurityGroup>> {
    private final SecurityGroupHandler securityGroupHandler;
    private StringBuilder currentText = new StringBuilder();
    private ImmutableSet.Builder<SecurityGroup> securityGroups = ImmutableSet.builder();
    private boolean inSecurityGroupInfo;
    protected int itemDepth;

    @Inject
    public DescribeSecurityGroupsResponseHandler(SecurityGroupHandler securityGroupHandler) {
        this.securityGroupHandler = securityGroupHandler;
    }

    @Override
    public ParseSax.HandlerForGeneratedRequestWithResult<Set<SecurityGroup>> setContext(HttpRequest request) {
        this.securityGroupHandler.setContext(request);
        return super.setContext(request);
    }

    @Override
    public Set<SecurityGroup> getResult() {
        return this.securityGroups.build();
    }

    @Override
    public void startElement(String url, String name, String qName, Attributes attributes) throws SAXException {
        if (SaxUtils.equalsOrSuffix(qName, "item")) {
            ++this.itemDepth;
        } else if (SaxUtils.equalsOrSuffix(qName, "securityGroupInfo")) {
            this.inSecurityGroupInfo = true;
        }
        if (this.inSecurityGroupInfo) {
            this.securityGroupHandler.startElement(url, name, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXException {
        if (SaxUtils.equalsOrSuffix(qName, "item")) {
            this.endItem(uri, name, qName);
            --this.itemDepth;
        } else if (SaxUtils.equalsOrSuffix(qName, "securityGroupInfo")) {
            this.inSecurityGroupInfo = false;
        } else if (this.inSecurityGroupInfo) {
            this.securityGroupHandler.endElement(uri, name, qName);
        }
        this.currentText.setLength(0);
    }

    protected void endItem(String uri, String name, String qName) throws SAXException {
        if (this.inSecurityGroupInfo) {
            if (this.itemDepth == 1) {
                this.securityGroups.add((Object)this.securityGroupHandler.getResult());
            } else {
                this.securityGroupHandler.endElement(uri, name, qName);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inSecurityGroupInfo) {
            this.securityGroupHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

