/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.security.cpi;

import java.util.ArrayList;
import java.util.List;
import org.gridlab.gat.CouldNotInitializeCredentialException;
import org.gridlab.gat.CredentialExpiredException;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.InvalidUsernameOrPasswordException;
import org.gridlab.gat.URI;
import org.gridlab.gat.security.SecurityContext;
import org.gridlab.gat.security.cpi.SecurityContextCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityContextUtils {
    protected static Logger logger = LoggerFactory.getLogger(SecurityContextUtils.class);

    public static List<SecurityContext> getValidSecurityContexts(GATContext context, String adaptorName, String host, int port) {
        return SecurityContextUtils.getValidSecurityContextsByType(context, null, adaptorName, host, port);
    }

    public static List<SecurityContext> getValidSecurityContextsByType(GATContext context, String type, String adaptorName, String host, int port) {
        ArrayList<SecurityContext> result = new ArrayList<SecurityContext>();
        List l = type != null ? context.getSecurityContextsByType(type) : context.getSecurityContexts();
        if (l == null) {
            return null;
        }
        for (int i = 0; i < l.size(); ++i) {
            SecurityContext c = (SecurityContext)l.get(i);
            if (!c.isValidFor(adaptorName, host, port)) continue;
            result.add(c);
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    public static Object getSecurityUserData(GATContext context, String adaptorName, String dataObjectKey, URI location, int defaultPort, SecurityContextCreator creator) throws CouldNotInitializeCredentialException, CredentialExpiredException, InvalidUsernameOrPasswordException {
        List<SecurityContext> l = SecurityContextUtils.getValidSecurityContexts(context, adaptorName, location.resolveHost(), location.getPort(defaultPort));
        if (l != null) {
            for (int i = 0; i < l.size(); ++i) {
                SecurityContext c = l.get(i);
                Object userData = c.getDataObject(dataObjectKey);
                if (userData != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("reusing security object for adaptor " + adaptorName);
                    }
                    return userData;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("creating a new security object based on a security context for adaptor " + adaptorName);
                }
                if ((userData = creator.createUserData(context, location, c)) == null) continue;
                c.putDataObject(dataObjectKey, userData);
                return userData;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Getting default security object for adaptor " + adaptorName);
        }
        SecurityContext c = creator.createDefaultSecurityContext(context, location);
        c.addNote("adaptors", adaptorName);
        context.addSecurityContext(c);
        Object userData = c.getDataObject(dataObjectKey);
        return userData;
    }

    public static void killSecurityUserData(GATContext context, String adaptorName, String dataObjectKey, URI location, int defaultPort) {
        List<SecurityContext> l = SecurityContextUtils.getValidSecurityContexts(context, adaptorName, location.resolveHost(), location.getPort(defaultPort));
        if (l != null) {
            for (int i = 0; i < l.size(); ++i) {
                SecurityContext c = l.get(i);
                Object userData = c.getDataObject(dataObjectKey);
                if (userData == null) continue;
                c.putDataObject(dataObjectKey, null);
                if (logger.isDebugEnabled()) {
                    logger.debug("killing security object for adaptor " + adaptorName);
                }
                return;
            }
        }
    }

    public static String getUser(GATContext context, SecurityContext securityContext, URI location) throws CouldNotInitializeCredentialException, CredentialExpiredException, InvalidUsernameOrPasswordException {
        String user = location.getUserInfo();
        if (user != null) {
            return user;
        }
        if (securityContext != null && (user = securityContext.getUsername()) != null) {
            return user;
        }
        user = System.getProperty("user.name");
        if (user != null) {
            return user;
        }
        throw new CouldNotInitializeCredentialException("Could not get user name");
    }
}

