/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi.srcToLocalToDestCopy;

import java.util.Map;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.File;
import org.gridlab.gat.io.cpi.FileCpi;

public class SrcToLocalToDestCopyFileAdaptor
extends FileCpi {
    public static String getDescription() {
        return "The SrcToLocalToDest File Adaptor only implements the File copy operation, via a local temporary file. Its purpose is to allow copying of a file from one adaptor to another.";
    }

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = FileCpi.getSupportedCapabilities();
        capabilities.put("copy", true);
        return capabilities;
    }

    public SrcToLocalToDestCopyFileAdaptor(GATContext gatContext, URI location) throws GATObjectCreationException {
        super(gatContext, location);
        if (this.toURI().isCompatible("file") && this.toURI().refersToLocalHost()) {
            throw new GATObjectCreationException("SrcToLocalToDestCopyFileAdaptor can only be used for remote files");
        }
    }

    public void copy(URI dest) throws GATInvocationException {
        if (dest.isCompatible("file") && dest.refersToLocalHost()) {
            throw new GATInvocationException("SrcToLocalToDestCopyFileAdaptor destination refers to localhost");
        }
        File tmpFile = null;
        try {
            java.io.File tmp = null;
            tmp = java.io.File.createTempFile("GATgridFTP", ".tmp");
            URI tmpFileURI = new URI("any:///" + tmp.getPath());
            File srcFile = GAT.createFile((GATContext)this.gatContext, (URI)this.location);
            srcFile.copy(tmpFileURI);
            tmpFile = GAT.createFile((GATContext)this.gatContext, (URI)tmpFileURI);
            tmpFile.copy(dest);
        }
        catch (Exception e) {
            throw new GATInvocationException("SrcToLocalToDestCopyFileAdaptor", (Throwable)e);
        }
        finally {
            if (tmpFile != null) {
                try {
                    tmpFile.delete();
                }
                catch (Exception exception) {}
            }
        }
    }
}

