/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;
import org.jclouds.softlayer.SoftLayerApi;
import org.jclouds.softlayer.compute.options.SoftLayerTemplateOptions;
import org.jclouds.softlayer.domain.ContainerVirtualGuestConfiguration;
import org.jclouds.softlayer.domain.Datacenter;
import org.jclouds.softlayer.domain.NetworkVlan;
import org.jclouds.softlayer.domain.OperatingSystem;
import org.jclouds.softlayer.domain.Password;
import org.jclouds.softlayer.domain.SecuritySshKey;
import org.jclouds.softlayer.domain.SoftwareDescription;
import org.jclouds.softlayer.domain.SoftwareLicense;
import org.jclouds.softlayer.domain.VirtualDiskImage;
import org.jclouds.softlayer.domain.VirtualDiskImageSoftware;
import org.jclouds.softlayer.domain.VirtualGuest;
import org.jclouds.softlayer.domain.VirtualGuestAttribute;
import org.jclouds.softlayer.domain.VirtualGuestBlockDevice;
import org.jclouds.softlayer.domain.VirtualGuestBlockDeviceTemplate;
import org.jclouds.softlayer.domain.VirtualGuestBlockDeviceTemplateGroup;
import org.jclouds.softlayer.domain.VirtualGuestNetworkComponent;
import org.jclouds.util.Predicates2;

@Singleton
public class SoftLayerComputeServiceAdapter
implements ComputeServiceAdapter<VirtualGuest, Hardware, OperatingSystem, Datacenter> {
    private static final String USER_META_NOTES = "notes";
    private static final int USER_META_NOTES_MAX_LENGTH = 1000;
    private static final String BOOTABLE_DEVICE = "0";
    public static final String DEFAULT_DISK_TYPE = "LOCAL";
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final SoftLayerApi api;
    private final Supplier<ContainerVirtualGuestConfiguration> createObjectOptionsSupplier;
    private final Predicate<VirtualGuest> loginDetailsTester;
    private final long guestLoginDelay;
    private final long activeTransactionsDelay;

    @Inject
    public SoftLayerComputeServiceAdapter(SoftLayerApi api, VirtualGuestHasLoginDetailsPresent virtualGuestHasLoginDetailsPresent, @Memoized Supplier<ContainerVirtualGuestConfiguration> createObjectOptionsSupplier, @Named(value="jclouds.softlayer.virtualguest.login_details_delay") long guestLoginDelay, @Named(value="jclouds.softlayer.virtualguest.active_transactions_delay") long activeTransactionsDelay) {
        this.api = Preconditions.checkNotNull(api, "api");
        this.guestLoginDelay = Preconditions.checkNotNull(guestLoginDelay, "guestLoginDelay");
        this.activeTransactionsDelay = Preconditions.checkNotNull(activeTransactionsDelay, "activeTransactionsDelay");
        this.createObjectOptionsSupplier = Preconditions.checkNotNull(createObjectOptionsSupplier, "createObjectOptionsSupplier");
        Preconditions.checkArgument(guestLoginDelay > 500L, "guestOrderDelay must be in milliseconds and greater than 500");
        this.loginDetailsTester = Predicates2.retry(virtualGuestHasLoginDetailsPresent, guestLoginDelay);
    }

    @Override
    public ComputeServiceAdapter.NodeAndInitialCredentials<VirtualGuest> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        Preconditions.checkNotNull(template, "template was null");
        Preconditions.checkNotNull(template.getOptions(), "template options was null");
        Preconditions.checkArgument(template.getOptions().getClass().isAssignableFrom(SoftLayerTemplateOptions.class), "options class %s should have been assignable from SoftLayerTemplateOptions", template.getOptions().getClass());
        SoftLayerTemplateOptions templateOptions = template.getOptions().as(SoftLayerTemplateOptions.class);
        String domainName = templateOptions.getDomainName();
        String diskType = templateOptions.getDiskType() == null ? DEFAULT_DISK_TYPE : templateOptions.getDiskType();
        boolean hourlyBillingFlag = templateOptions.isHourlyBillingFlag() == null ? true : templateOptions.isHourlyBillingFlag();
        Integer portSpeed = templateOptions.getPortSpeed();
        ImmutableSet<VirtualGuestNetworkComponent> networkComponents = portSpeed != null ? ImmutableSet.of(VirtualGuestNetworkComponent.builder().speed(portSpeed).build()) : ImmutableSet.of();
        Datacenter datacenter = ((Datacenter.Builder)Datacenter.builder().name(template.getLocation().getId())).build();
        String imageId = template.getImage().getId();
        int cores = (int)template.getHardware().getProcessors().get(0).getCores();
        String notes = this.getNotes(templateOptions);
        Object virtualGuestBuilder = ((VirtualGuest.Builder)((VirtualGuest.Builder)((VirtualGuest.Builder)((VirtualGuest.Builder)((VirtualGuest.Builder)((VirtualGuest.Builder)((VirtualGuest.Builder)VirtualGuest.builder().domain(domainName)).hostname(name)).hourlyBillingFlag(hourlyBillingFlag)).startCpus(cores)).maxMemory(template.getHardware().getRam())).datacenter(datacenter)).localDiskFlag(SoftLayerComputeServiceAdapter.isLocalDisk(diskType))).networkComponents(networkComponents);
        Optional<OperatingSystem> optionalOperatingSystem = this.tryExtractOperatingSystemFrom(imageId);
        if (optionalOperatingSystem != null) {
            ((VirtualGuest.Builder)virtualGuestBuilder).operatingSystem(optionalOperatingSystem.get());
        } else {
            VirtualGuestBlockDeviceTemplateGroup blockDeviceTemplateGroup = VirtualGuestBlockDeviceTemplateGroup.builder().globalIdentifier(imageId).build();
            ((VirtualGuest.Builder)((VirtualGuest.Builder)virtualGuestBuilder).blockDeviceTemplateGroup(blockDeviceTemplateGroup)).build();
        }
        if (!templateOptions.getBlockDevices().isEmpty()) {
            List<VirtualGuestBlockDevice> blockDevices = SoftLayerComputeServiceAdapter.getBlockDevices(templateOptions.getBlockDevices(), diskType);
            ((VirtualGuest.Builder)virtualGuestBuilder).blockDevices(blockDevices);
        }
        if (templateOptions.isDedicatedAccountHostOnlyFlag() != null) {
            ((VirtualGuest.Builder)virtualGuestBuilder).dedicatedAccountHostOnly(templateOptions.isDedicatedAccountHostOnlyFlag());
        }
        if (templateOptions.isPrivateNetworkOnlyFlag() != null) {
            ((VirtualGuest.Builder)virtualGuestBuilder).privateNetworkOnlyFlag(templateOptions.isPrivateNetworkOnlyFlag());
        }
        if (templateOptions.getPrimaryNetworkComponentNetworkVlanId() != null) {
            int primaryNetworkComponentNetworkVlanId = templateOptions.getPrimaryNetworkComponentNetworkVlanId();
            ((VirtualGuest.Builder)virtualGuestBuilder).primaryNetworkComponent(VirtualGuestNetworkComponent.builder().networkVlan(NetworkVlan.builder().id(primaryNetworkComponentNetworkVlanId).build()).build());
        }
        if (templateOptions.getPrimaryBackendNetworkComponentNetworkVlanId() != null) {
            int primaryBackendNetworkComponentNetworkVlanId = templateOptions.getPrimaryBackendNetworkComponentNetworkVlanId();
            ((VirtualGuest.Builder)virtualGuestBuilder).primaryBackendNetworkComponent(VirtualGuestNetworkComponent.builder().networkVlan(NetworkVlan.builder().id(primaryBackendNetworkComponentNetworkVlanId).build()).build());
        }
        if (templateOptions.getPostInstallScriptUri() != null) {
            ((VirtualGuest.Builder)virtualGuestBuilder).postInstallScriptUri(templateOptions.getPostInstallScriptUri());
        }
        if (templateOptions.getUserData() != null) {
            ((VirtualGuest.Builder)virtualGuestBuilder).virtualGuestAttribute(VirtualGuestAttribute.builder().value(templateOptions.getUserData()).build());
        }
        if (!templateOptions.getSshKeys().isEmpty()) {
            HashSet<SecuritySshKey> sshKeys = Sets.newHashSet();
            for (int sshKeyId : templateOptions.getSshKeys()) {
                sshKeys.add(SecuritySshKey.builder().id(sshKeyId).build());
            }
            ((VirtualGuest.Builder)virtualGuestBuilder).sshKeys(sshKeys);
        }
        VirtualGuest virtualGuest = ((VirtualGuest.Builder)virtualGuestBuilder).build();
        this.logger.debug(">> creating new VirtualGuest(%s)", virtualGuest);
        VirtualGuest result = this.api.getVirtualGuestApi().createVirtualGuest(virtualGuest);
        this.logger.trace("<< VirtualGuest(%s)", result.getId());
        if (!templateOptions.getTags().isEmpty()) {
            this.api.getVirtualGuestApi().setTags(result.getId(), templateOptions.getTags());
        }
        if (!Strings.isNullOrEmpty(notes)) {
            this.api.getVirtualGuestApi().setNotes(result.getId(), notes);
        }
        this.logger.debug(">> awaiting login details for virtualGuest(%s)", result.getId());
        boolean orderInSystem = this.loginDetailsTester.apply(result);
        this.logger.trace("<< VirtualGuest(%s) complete(%s)", result.getId(), orderInSystem);
        if (!orderInSystem) {
            this.logger.warn("VirtualGuest(%s) doesn't have login details within %sms so it will be destroyed.", result, Long.toString(this.guestLoginDelay));
            this.api.getVirtualGuestApi().deleteVirtualGuest(result.getId());
            throw new IllegalStateException(String.format("VirtualGuest(%s) is being destroyed as it doesn't have login details after %sms. Please, try by increasing `jclouds.softlayer.virtualguest.login_details_delay` and  try again", result, Long.toString(this.guestLoginDelay)));
        }
        result = this.api.getVirtualGuestApi().getVirtualGuest(result.getId());
        Password pwd = Iterables.get(result.getOperatingSystem().getPasswords(), 0);
        return new ComputeServiceAdapter.NodeAndInitialCredentials<VirtualGuest>(result, result.getId() + "", LoginCredentials.builder().user(pwd.getUsername()).password(pwd.getPassword()).build());
    }

    private String getNotes(SoftLayerTemplateOptions templateOptions) {
        String notes = null;
        Map<String, String> meta = templateOptions.getUserMetadata();
        if (meta != null && !Strings.isNullOrEmpty(notes = meta.get(USER_META_NOTES))) {
            Preconditions.checkArgument(notes.length() <= 1000, "'notes' property in user metadata should be long at most 1000 characters.");
        }
        return notes;
    }

    @Override
    public Iterable<Hardware> listHardwareProfiles() {
        ContainerVirtualGuestConfiguration virtualGuestConfiguration = this.createObjectOptionsSupplier.get();
        ImmutableSortedSet.Builder<Hardware> hardware = ImmutableSortedSet.orderedBy(new Comparator<Hardware>(){

            @Override
            public int compare(Hardware h1, Hardware h2) {
                List<? extends Volume> volumes1 = h1.getVolumes();
                List<? extends Volume> volumes2 = h2.getVolumes();
                ComparisonChain comparisonChain = ComparisonChain.start().compare(ComputeServiceUtils.getCores(h1), ComputeServiceUtils.getCores(h2)).compare(h1.getRam(), h2.getRam()).compare(ComputeServiceUtils.getSpace(h1), ComputeServiceUtils.getSpace(h2)).compare(SoftLayerComputeServiceAdapter.getBootableDeviceType(h1), SoftLayerComputeServiceAdapter.getBootableDeviceType(h2));
                if (!volumes1.isEmpty() && !volumes2.isEmpty() && volumes1.size() == volumes2.size()) {
                    for (int i = 0; i < volumes1.size(); ++i) {
                        comparisonChain = comparisonChain.compare((Comparable<?>)((Object)volumes1.get(i).getType()), (Comparable<?>)((Object)volumes2.get(i).getType()));
                    }
                }
                return comparisonChain.result();
            }
        });
        for (VirtualGuestBlockDevice blockDevice : virtualGuestConfiguration.getVirtualGuestBlockDevices()) {
            Volume.Type type;
            float capacity = blockDevice.getVirtualDiskImage().getCapacity();
            Volume.Type type2 = type = blockDevice.getVirtualGuest().isLocalDiskFlag() ? Volume.Type.LOCAL : Volume.Type.SAN;
            if (!blockDevice.getDevice().equals(BOOTABLE_DEVICE)) continue;
            for (Integer cpus : virtualGuestConfiguration.getCpusOfProcessors()) {
                for (Integer memory : virtualGuestConfiguration.getMemories()) {
                    String id = String.format("cpu=%s,memory=%s,disk=%s,type=%s", new Object[]{cpus, memory, Math.round(capacity), type});
                    ((ImmutableSet.Builder)hardware).add(new HardwareBuilder().ids(id).ram(memory).processors(ImmutableList.of(new Processor(cpus.intValue(), 2.0))).hypervisor("XenServer").volumes(ImmutableList.of(new VolumeImpl(blockDevice.getId() + "", type, Float.valueOf(capacity), blockDevice.getDevice(), blockDevice.getBootableFlag() == 1, true))).build());
                }
            }
        }
        return ((ImmutableSet.Builder)hardware).build();
    }

    @Override
    public Set<OperatingSystem> listImages() {
        HashSet<OperatingSystem> result = Sets.newHashSet();
        Set<SoftwareDescription> allObjects = this.api.getSoftwareDescriptionApi().getAllObjects();
        for (OperatingSystem os : this.createObjectOptionsSupplier.get().getVirtualGuestOperatingSystems()) {
            result.addAll(FluentIterable.from(allObjects).filter(new IsOperatingSystem()).filter(new HasSameOsReferenceCode(os.getOperatingSystemReferenceCode())).transform(new SoftwareDescriptionToOperatingSystem(os.getId())).toSet());
        }
        return result;
    }

    @Override
    public OperatingSystem getImage(final String id) {
        Optional<OperatingSystem> operatingSystemOptional = Iterables.tryFind(this.listImages(), new Predicate<OperatingSystem>(){

            @Override
            public boolean apply(OperatingSystem input) {
                return input.getId().equals(id);
            }
        });
        if (operatingSystemOptional.isPresent()) {
            return operatingSystemOptional.get();
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        VirtualGuestBlockDeviceTemplateGroup image = this.api.getVirtualGuestBlockDeviceTemplateGroupApi().getObject(id);
        this.logger.trace("<< Image(%s) found in (%s)", id, stopwatch.elapsed(TimeUnit.SECONDS));
        return this.tryExtractOperatingSystemFrom(image).orNull();
    }

    @Override
    public Iterable<VirtualGuest> listNodes() {
        return this.api.getAccountApi().listVirtualGuests();
    }

    @Override
    public Iterable<VirtualGuest> listNodesByIds(final Iterable<String> ids) {
        return Iterables.filter(this.listNodes(), new Predicate<VirtualGuest>(){

            @Override
            public boolean apply(VirtualGuest server) {
                return Iterables.contains(ids, server.getId());
            }
        });
    }

    @Override
    public Iterable<Datacenter> listLocations() {
        HashSet<Datacenter> result = Sets.newHashSet();
        Set<Datacenter> unfiltered = this.api.getDatacenterApi().listDatacenters();
        Set<Datacenter> datacenterAvailable = this.createObjectOptionsSupplier.get().getVirtualGuestDatacenters();
        for (Datacenter datacenter : datacenterAvailable) {
            final String datacenterName = datacenter.getName();
            result.addAll(Sets.newHashSet(Iterables.filter(unfiltered, new Predicate<Datacenter>(){

                @Override
                public boolean apply(Datacenter input) {
                    return input.getName().equals(datacenterName);
                }
            })));
        }
        return result;
    }

    @Override
    public VirtualGuest getNode(String id) {
        long serverId = Long.parseLong(id);
        return this.api.getVirtualGuestApi().getVirtualGuest(serverId);
    }

    @Override
    public void destroyNode(String id) {
        VirtualGuest guest = this.getNode(id);
        if (guest == null) {
            return;
        }
        this.logger.debug(">> awaiting virtualGuest(%s) without active transactions", guest.getId());
        Preconditions.checkState(Predicates2.retry(new Predicate<VirtualGuest>(){

            @Override
            public boolean apply(VirtualGuest guest) {
                return SoftLayerComputeServiceAdapter.this.getNode(guest.getId() + "").getActiveTransactionCount() == 0;
            }
        }, this.activeTransactionsDelay).apply(guest), "%s still has active transactions!", guest);
        this.logger.debug(">> canceling virtualGuest with globalIdentifier(%s)", id);
        Preconditions.checkState(this.api.getVirtualGuestApi().deleteVirtualGuest(guest.getId()), "server(%s) still there after deleting!?", id);
    }

    @Override
    public void rebootNode(String id) {
        this.api.getVirtualGuestApi().rebootHardVirtualGuest(Long.parseLong(id));
    }

    @Override
    public void resumeNode(String id) {
        this.api.getVirtualGuestApi().resumeVirtualGuest(Long.parseLong(id));
    }

    @Override
    public void suspendNode(String id) {
        this.api.getVirtualGuestApi().pauseVirtualGuest(Long.parseLong(id));
    }

    private static List<VirtualGuestBlockDevice> getBlockDevices(List<Integer> blockDeviceCapacities, String diskType) {
        ImmutableList.Builder blockDevicesBuilder = ImmutableList.builder();
        int devicePosition = 0;
        for (int i = 0; i < blockDeviceCapacities.size(); ++i) {
            if (i > 0) {
                devicePosition = i + 1;
            }
            blockDevicesBuilder.add(VirtualGuestBlockDevice.builder().device(devicePosition + "").diskImage(VirtualDiskImage.builder().capacity(blockDeviceCapacities.get(i).intValue()).typeId(Volume.Type.valueOf(diskType).ordinal()).build()).build());
        }
        return blockDevicesBuilder.build();
    }

    private static boolean isLocalDisk(String diskType) {
        return diskType.equalsIgnoreCase(Volume.Type.LOCAL.name());
    }

    private static int getBootableDeviceType(Hardware hardware) {
        List<? extends Volume> volumes = hardware.getVolumes();
        Optional<Volume> optionalBootableVolume = Iterables.tryFind(volumes, new Predicate<Volume>(){

            @Override
            public boolean apply(Volume volume) {
                return volume.getDevice().equals(SoftLayerComputeServiceAdapter.BOOTABLE_DEVICE);
            }
        });
        if (!optionalBootableVolume.isPresent()) {
            return Volume.Type.LOCAL.ordinal();
        }
        return optionalBootableVolume.get().getType().ordinal();
    }

    private Optional<OperatingSystem> tryExtractOperatingSystemFrom(final String imageId) {
        Set<OperatingSystem> operatingSystemsAvailable = this.createObjectOptionsSupplier.get().getVirtualGuestOperatingSystems();
        return FluentIterable.from(operatingSystemsAvailable).filter(new Predicate<OperatingSystem>(){

            @Override
            public boolean apply(OperatingSystem input) {
                if (input == null) {
                    return false;
                }
                return input.getId().contains(imageId);
            }
        }).first();
    }

    private Optional<OperatingSystem> tryExtractOperatingSystemFrom(VirtualGuestBlockDeviceTemplateGroup image) {
        if (image.getGlobalIdentifier() == null) {
            return Optional.absent();
        }
        return FluentIterable.from(image.getChildren()).transformAndConcat(new BlockDeviceTemplateGroupToBlockDeviceTemplateIterable()).filter(new IsBootableDevice()).transformAndConcat(new BlockDeviceTemplateToDiskImageSoftware()).transform(new DiskImageSoftwareToSoftwareDescription()).filter(new IsOperatingSystem()).transform(new SoftwareDescriptionToOperatingSystem(image.getGlobalIdentifier())).first();
    }

    private class IsOperatingSystem
    implements Predicate<SoftwareDescription> {
        private IsOperatingSystem() {
        }

        @Override
        public boolean apply(SoftwareDescription softwareDescription) {
            return softwareDescription.getOperatingSystem() == 1;
        }
    }

    private static class HasSameOsReferenceCode
    implements Predicate<SoftwareDescription> {
        private final String osReferenceCode;

        public HasSameOsReferenceCode(String osReferenceCode) {
            this.osReferenceCode = osReferenceCode;
        }

        @Override
        public boolean apply(SoftwareDescription input) {
            return input.getReferenceCode().equals(this.osReferenceCode);
        }
    }

    private static class DiskImageSoftwareToSoftwareDescription
    implements Function<VirtualDiskImageSoftware, SoftwareDescription> {
        private DiskImageSoftwareToSoftwareDescription() {
        }

        @Override
        public SoftwareDescription apply(VirtualDiskImageSoftware software) {
            return software.getSoftwareDescription();
        }
    }

    private static class BlockDeviceTemplateToDiskImageSoftware
    implements Function<VirtualGuestBlockDeviceTemplate, Iterable<VirtualDiskImageSoftware>> {
        private BlockDeviceTemplateToDiskImageSoftware() {
        }

        @Override
        public Iterable<VirtualDiskImageSoftware> apply(VirtualGuestBlockDeviceTemplate bootableDevice) {
            return bootableDevice.getDiskImage().getSoftwareReferences();
        }
    }

    private static class BlockDeviceTemplateGroupToBlockDeviceTemplateIterable
    implements Function<VirtualGuestBlockDeviceTemplateGroup, Iterable<VirtualGuestBlockDeviceTemplate>> {
        private BlockDeviceTemplateGroupToBlockDeviceTemplateIterable() {
        }

        @Override
        public Iterable<VirtualGuestBlockDeviceTemplate> apply(VirtualGuestBlockDeviceTemplateGroup input) {
            return input.getBlockDevices();
        }
    }

    private static class IsBootableDevice
    implements Predicate<VirtualGuestBlockDeviceTemplate> {
        private IsBootableDevice() {
        }

        @Override
        public boolean apply(VirtualGuestBlockDeviceTemplate blockDeviceTemplate) {
            return blockDeviceTemplate.getDevice().equals(SoftLayerComputeServiceAdapter.BOOTABLE_DEVICE);
        }
    }

    private static class SoftwareDescriptionToOperatingSystem
    implements Function<SoftwareDescription, OperatingSystem> {
        private final String osId;

        public SoftwareDescriptionToOperatingSystem(String osId) {
            this.osId = osId;
        }

        @Override
        public OperatingSystem apply(SoftwareDescription input) {
            return OperatingSystem.builder().id(this.osId).softwareLicense(SoftwareLicense.builder().softwareDescription(input).build()).operatingSystemReferenceCode(input.getReferenceCode()).build();
        }
    }

    public static class VirtualGuestHasLoginDetailsPresent
    implements Predicate<VirtualGuest> {
        private final SoftLayerApi client;

        @Inject
        public VirtualGuestHasLoginDetailsPresent(SoftLayerApi client) {
            this.client = Preconditions.checkNotNull(client, "client was null");
        }

        @Override
        public boolean apply(VirtualGuest guest) {
            boolean hasPasswords;
            Preconditions.checkNotNull(guest, "virtual guest was null");
            VirtualGuest virtualGuest = this.client.getVirtualGuestApi().getVirtualGuest(guest.getId());
            boolean hasBackendIp = virtualGuest.getPrimaryBackendIpAddress() != null;
            boolean hasPrimaryIp = virtualGuest.getPrimaryIpAddress() != null;
            boolean bl = hasPasswords = virtualGuest.getOperatingSystem() != null && !virtualGuest.getOperatingSystem().getPasswords().isEmpty();
            return virtualGuest.isPrivateNetworkOnly() ? hasBackendIp && hasPasswords : hasBackendIp && hasPrimaryIp && hasPasswords;
        }
    }
}

